//------------------------------------------------------------------------------
//	File:					bound_3d.cp
//	Date:					9/30/96
//	Author:				Bretton Wade
//
//	Description:	this file contains the class methods for a bounding box
//
//------------------------------------------------------------------------------

#include "precompile.h"
#include "bound_3d.h"

//------------------------------------------------------------------------------
//	constructor
//------------------------------------------------------------------------------
bound_3d::bound_3d (void)																												//	constructor
{																																								//	begin
	maxp (-INFINITY, -INFINITY, -INFINITY);																				//	start maxp at -inf
	minp (INFINITY, INFINITY, INFINITY);																					//	start minp at inf
}																																								//	end

//------------------------------------------------------------------------------
//	self addition
//------------------------------------------------------------------------------
void		bound_3d::operator += (const bound_3d &box)															//	add a bounding box into this one
{																																								//	begin
	if (box.maxp[X] > maxp[X]) maxp[X] = box.maxp[X] + EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
	if (box.maxp[Y] > maxp[Y]) maxp[Y] = box.maxp[Y] + EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
	if (box.maxp[Z] > maxp[Z]) maxp[Z] = box.maxp[Z] + EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
	if (box.minp[X] < minp[X]) minp[X] = box.minp[X] - EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
	if (box.minp[Y] < minp[Y]) minp[Y] = box.minp[Y] - EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
	if (box.minp[Z] < minp[Z]) minp[Z] = box.minp[Z] - EPSILON;										//	compare the coordinate value, and replace if the magintude is appropriate
}																																								//	end

//------------------------------------------------------------------------------
//	self addition
//------------------------------------------------------------------------------
void		bound_3d::operator += (const point_3d &pt)															//	add a point_3d into the bounding box
{																																								//	begin
	if (pt[X] > maxp[X]) maxp[X] = pt[X] + EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
	if (pt[Y] > maxp[Y]) maxp[Y] = pt[Y] + EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
	if (pt[Z] > maxp[Z]) maxp[Z] = pt[Z] + EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
	if (pt[X] < minp[X]) minp[X] = pt[X] - EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
	if (pt[Y] < minp[Y]) minp[Y] = pt[Y] - EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
	if (pt[Z] < minp[Z]) minp[Z] = pt[Z] - EPSILON;																//	compare the coordinate value, and replace if the magintude is appropriate
}																																								//	end

//------------------------------------------------------------------------------
//	containment test
//------------------------------------------------------------------------------
Bool		bound_3d::Contains (const point_3d &pt) const														//	return whether or not a point_3d is inside the bounding box
{																																								//	begin
	return	Bool ((pt[X] <= maxp[X]) && (pt[X] >= minp[X]) &&											//	if the x component is in
								(pt[Y] <= maxp[Y]) && (pt[Y] >= minp[Y]) &&											//	and the y component is on
								(pt[Z] <= maxp[Z]) && (pt[Z] >= minp[Z]));											//	and the z component is in...
}																																								//	end

//------------------------------------------------------------------------------
