/*
      convert dem to x, y, z format, one dem profile at a time.
      converts 3 arc second to lat/long,  sol katz, mar. 94.
      added sampling and cutting to size, sol katz, apr 94.
      changed the calculation of start position in sampling code, 
					  sol katz, jan 95.

      Modified to handle writing a release 12 DXF file
      instead of an XYZ file,
      					David Bunch, April 13, 1997.
*/

#include <stdio.h>
#include <stdlib.h>

void	getheader(FILE *);
void	processProfiles(FILE *, FILE *);
void	writeFile(FILE *, double, double);
void	writeHeader(FILE *);
void    writeCount();

#define     YMAX     2048          /*  max length of an NCIC scan line */
#define     XMAX     2048          /*  max # of NCIC scan lines */

#define MIN(x,y)     (((x) < (y)) ? (x) : (y))
#define MAX(x,y)     (((x) > (y)) ? (x) : (y))

#define SW     0
#define NW     1
#define NE     2
#define SE     3


int             base[XMAX];         /* array of base elevations */
char            mapLabel[145];
int             DEMlevel, elevationPattern, groundSystem, groundZone;
double          projectParams[15];
int             planeUnitOfMeasure, elevUnitOfMeasure, polygonSizes;
double          groundCoords[4][2], elevBounds[2], localRotation;
int             accuracyCode;
double          spatialResolution[3];
int             profileDimension[2];
int             firstRow, lastRow;
int             wcount = 0;

double          verticalScale;      /* to stretch or shrink elevations */
double          deltaY;
char            inText[24], **junk;

double          eastMost, westMost, southMost, northMost;
int             eastMostSample,  westMostSample, 
                southMostSample, northMostSample;
int             rowCount, columnCount, r, c;
long int        cellCount = 0 ;
long int	N1,S1,E1,W1,SP0,SP1,TINT1;
int		rowStr=1,rowEnd, colStr=1, colEnd,
		colInt=1, rowInt=1, outType ;

void main(argc, argv)
    char           *argv[];

{
    FILE       *inf, *outf;
    double     comp = 0.0;

    if (argc != 3) {
       (void) fprintf(stderr, "Usage: dem2xyz dem_name xyz_file\n");
       exit(1);
    }

    if ((inf = fopen(argv[1], "r")) == NULL) {
       perror(argv[1]);
       exit(1);
    }
    fprintf(stderr,"DEM to x,y,z ascii file, ver 3.1, 1-95 -- Sol Katz, BLM \n ");

    verticalScale = 1.0;

    (void)getheader(inf);


    /* 3 second DEMs overlap next one by one row, others don't */

    if (spatialResolution[0] == 3.0) {
	 comp   = spatialResolution[0] - 1.0 ;
	 deltaY = spatialResolution[1] / 3600.  ;
    }
    else {
	 comp   = 0.;
	 deltaY = spatialResolution[1] ;
    }

    eastMost  = MAX(groundCoords[NE][0], groundCoords[SE][0]);
    westMost  = MIN(groundCoords[NW][0], groundCoords[SW][0]);
    northMost = MAX(groundCoords[NE][1], groundCoords[NW][1]);
    southMost = MIN(groundCoords[SW][1], groundCoords[SE][1]);
    E1 = eastMost / spatialResolution[0];
    W1 = (westMost+comp) / spatialResolution[0];
    N1 = northMost / spatialResolution[1];
    S1 = (southMost+comp) / spatialResolution[1];
    SP0 = spatialResolution[0];
    SP1 = spatialResolution[1];
    eastMostSample = E1 * SP0;
    westMostSample = W1 * SP0;
    northMostSample = N1 * SP1;
    southMostSample = S1 * SP1;
    if (spatialResolution[0] == 3.0) { /* then it's a 1x1 degree DEM */
       printf(" eastMostSample %10f,  westMostSample %10f\n",
		eastMostSample/3600., westMostSample/3600.);
       printf("northMostSample %10f, southMostSample %10f\n",
	       northMostSample/3600., southMostSample/3600.);
       }


    columnCount = (eastMostSample  - westMostSample)
		  / SP0 + 1;
    rowCount    = (northMostSample - southMostSample)
		  / SP1 + 1;

    if (columnCount != profileDimension[1]) {
      (void) printf("       CALCULATED column Count %d != HEADER %d \n",
	    columnCount, profileDimension[1]);
      (void) printf("       will use SMALLER column Count \n");
	    columnCount =MIN( profileDimension[1], columnCount);
    }

    (void) printf("number of rows %d, number of columns %d\n",
		rowCount, columnCount);

    if (argc > 2) {
      if ((outf = fopen(argv[2], "wb")) == NULL) {
	  (void) fprintf(stderr, "can't open output file %s\n", argv[2]);
	 exit(1);
       }
    }

    colInt = 1 ;
    rowInt = 1 ;
    fprintf(stderr,
	"Enter 0 for all,  1 for samples,  2 for subset : ");
    scanf("%d",&outType);

    if ( outType == 1)
    {
       fprintf(stderr,"Enter column sample interval :");
       scanf("%d",&colInt);
       fprintf(stderr,"Enter row    sample interval :");
       scanf("%d",&rowInt);
       /* adjust deltaY */
       deltaY = deltaY * rowInt;
    }
    else if ( outType == 2)
    {
       fprintf(stderr,"Enter start column  :");
       scanf("%d",&colStr);
       fprintf(stderr,"Enter end   column  :");
       scanf("%d",&colEnd);
       fprintf(stderr,"Enter start row     :");
       scanf("%d",&rowStr);
       fprintf(stderr,"Enter end   row     :");
       scanf("%d",&rowEnd);
     }

    fprintf(stderr,"Enter a vertical scaling factor: ");
    scanf("%lf",&verticalScale);
    fprintf(stderr,"\n");

    /* adjust the end of the file */
    if ( outType == 2 && columnCount > colEnd ) columnCount = colEnd;

    /* have to read everything */
    (void) processProfiles(inf,outf);

    fprintf(stderr,"\n  %ld lines were written to the file. \n",cellCount);
/*    writeCount(); */
    exit(0);
}

/*
 * read profiles
 */

void processProfiles(inputFile,outputFile)
    FILE           *inputFile,*outputFile;
{
    int 	    c, r, mod ;
    int             count, tempInt, lastProfile = 0;

    float           noValue = 0.0;
    int             profileID[2], profileSize[2];
    double          planCoords[2], localElevation, elevExtremea[2];
    writeHeader(outputFile);

    for (c = 1; c <= columnCount; c++) {
       count = fscanf(inputFile, "%6d%6d%6d%6d",
		 &profileID[0],        /* 1 */
		 &profileID[1],        /* 1 */
		 &profileSize[0],      /* 2 */
		 &profileSize[1]);     /* 2 */
       if (count != 4) {
	   (void) fprintf(stderr, "\nshort read of %d on column %d\n",count, c);
       fprintf(stderr,"\n  %ld lines were written to the file. \n",cellCount);
/*	    writeCount(); */
	    exit (1);
       }
       fscanf(inputFile,"%24c", inText);
       inText[20] = 'E';
       planCoords[0]   = strtod(inText,junk);     /* 3 */
       fscanf(inputFile,"%24c", inText);
       inText[20] = 'E';
       planCoords[1]   = strtod(inText,junk);     /* 3 */
       fscanf(inputFile,"%24c", inText);
       inText[20] = 'E';
       localElevation  = strtod(inText,junk);     /* 4 */
       fscanf(inputFile,"%24c", inText);
       inText[20] = 'E';
       elevExtremea[0] = strtod(inText,junk);     /* 5 */
       fscanf(inputFile,"%24c", inText);
       inText[20] = 'E';
       elevExtremea[1] = strtod(inText,junk);     /* 5 */

/*     next 2 lines are a kludge to force the end of processing */
       if ( profileID[1]-1 != lastProfile )
       {
         fprintf(stderr,"\n  %ld lines were written to the file. \n",cellCount);
         /* writeCount(); */
	 exit(0);
       }
       lastProfile =  profileID[1];

       (void) printf("Column %d has %d samples              \r",
		       profileID[1], profileSize[0]);
       TINT1 = planCoords[1] - southMostSample;
       firstRow = TINT1 / SP1;
       lastRow = firstRow + profileSize[0] - 1;

       for ( r = 0 ; r < firstRow  ; r++ ) base[r] = 0;


/*     read in all the data for this column */
       for (r = firstRow; r <= lastRow; r++ )
       {
	   count = fscanf(inputFile, "%6d",	&tempInt);
	   base[r] = tempInt;
       }

/*     if cutting out a section, adjust the rows */
       if ( outType == 2 )
       {
	 if ( firstRow < rowStr )
	 {
	    firstRow = rowStr ;
	    /* adjust the ycoord */
/* suggested change */
            planCoords[1] = planCoords[1] + ( firstRow -1 ) * (deltaY);
/* ssk jan 3, 95:	i haven't checked if we need (deltaY / 3600.);*/
/* old version
            planCoords[1] = planCoords[1] + ( rowInt -1 ) * deltaY;
*/
	 }
	 if ( lastRow  > rowEnd ) lastRow  = rowEnd ;
       }
       mod = c % colInt;
       if ( mod == 0 && c >= colStr )
       {
       /*   fprintf(stderr,"\n profile = %d , colINt = %d, mod = %d\n",c, mod); */
	   writeFile(outputFile, planCoords[0], planCoords[1]);
       }
   }
   fprintf(outputFile,"0\nENDSEC\n0\nEOF\n");
}

/*
 * write data to xyz file
 *
 */

void writeFile(outputFile, XCoord, YCoord)
    FILE           *outputFile;
    double         XCoord,   YCoord;
{
    int             r, c ;
    double          tempFloat;

/*
   wcount++;
   fprintf(stderr,"\n in writeFile %d %d %d %d \n",firstRow,lastRow,rowInt,wcount);
*/
   if (spatialResolution[1] >= 3.0)
   {
	 /* 3 degrees of arc */
	 XCoord /=  3600. ;
	 YCoord /=  3600. ;
   }

   for (r = firstRow; r <= lastRow; r += rowInt) {

      /* now, scale the raw value */

      tempFloat = base[r]  * verticalScale;

      /*   and finally write it out to the file   */

      fprintf(outputFile,"0\nPOINT\n8\n0\n10\n%f\n20\n%f\n30\n%f\n",
	      XCoord, YCoord, tempFloat);
      cellCount++ ;
       /*    move up the delta y distance */
      YCoord += deltaY;
   }
}


void getheader(inputFile)
    FILE           *inputFile;
{
    int             count,k,l ;
    count = fscanf(inputFile, "%144c%6d%6d%6d%6d",
	     mapLabel,              /* 1 */
	     &DEMlevel,             /* 2 */
	     &elevationPattern,     /* 3 */
             &groundSystem,         /* 4 */
             &groundZone );         /* 5 */
/*    (void) printf(" 5 there were %d items read from the header\n", count);*/


    for ( k=0; k<15 ; k++) {
      fscanf(inputFile,"%24c", inText);    /* 6 */
      inText[20] = 'E';
      projectParams[k]  = strtod(inText,junk);
    }

    count = fscanf(inputFile,"%6d%6d%6d",
             &planeUnitOfMeasure,   /* 7 */
             &elevUnitOfMeasure,    /* 8 */
             &polygonSizes);        /* 9 */
/*    (void) printf("3 there were %d items read from the header\n", count); */

    for ( k=0; k < 4 ; k++)
           for ( l=0; l < 2 ; l++) {
             fscanf(inputFile,"%24c", inText);    /* 6 */
             inText[20] = 'E';
             groundCoords[k][l]  = strtod(inText,junk);
	   }

    fscanf(inputFile,"%24c", inText);
    inText[20] = 'E';
    elevBounds[0] = strtod(inText,junk);       /* 10 */
    fscanf(inputFile,"%24c", inText);
    inText[20] = 'E';
    elevBounds[1] = strtod(inText,junk);      /* 11 */
    fscanf(inputFile,"%24c", inText);
    inText[20] = 'E';
    localRotation  = strtod(inText,junk);      /* 12 */

/*    (void) printf("11 there were %d items read from the header\n", count); */
    count = fscanf(inputFile,"%1d%12le%12le%12le%6d%6d",
             &accuracyCode,             /* 13 */
	     &spatialResolution[0],     /* 14 */
             &spatialResolution[1],     /* 14 */
             &spatialResolution[2],     /* 14 */
             &profileDimension[0],      /* 15 */
             &profileDimension[1]);     /* 15 */
/*    (void) printf("6 there were %d items read from the header\n", count); */

           printf("Map label: %s\n",mapLabel);
    (void) printf("[ 2] DEMlevel:  %d\n",DEMlevel );
    (void) printf("[ 3] elevation Pattern: %d\n",elevationPattern);
    (void) printf("[ 4] planimetric reference system: %d\n", groundSystem);
    (void) printf("[ 5] ground Zone: %d\n", groundZone);
    (void) printf("[ 6] proj: %15.7lf %15.7lf %15.7lf\n",
           projectParams[0], projectParams[1], projectParams[2]);
    (void) printf("[ 6] proj: %15.7lf %15.7lf %15.7lf\n",
           projectParams[3], projectParams[4], projectParams[5]);
    (void) printf("[ 6] proj: %15.7lf %15.7lf %15.7lf\n",
           projectParams[6], projectParams[7], projectParams[8]);
    (void) printf("[ 6] proj: %15.7lf %15.7lf %15.7lf\n",
           projectParams[9], projectParams[10], projectParams[11]);
    (void) printf("[ 6] proj: %15.7lf %15.7lf %15.7lf\n",
           projectParams[12], projectParams[13], projectParams[14]);
    (void) printf("[ 7] plane Unit Of Measure: %d\n",planeUnitOfMeasure );
    (void) printf("[ 8] elevation measurement units code: %d\n",
                        elevUnitOfMeasure);
    (void) printf("[ 9] polygon Sides: %d\n",polygonSizes );
    (void) printf("[10] ground coordinates\n");
    (void) printf("     NW (%14.5lf, %14.5lf)  NE (%14.5lf, %14.5lf)\n",
        groundCoords[1][0], groundCoords[1][1],
        groundCoords[2][0], groundCoords[2][1]);
    (void) printf("     SW (%14.5lf, %14.5lf)  SE (%14.5lf, %14.5lf)\n",
        groundCoords[0][0], groundCoords[0][1],
        groundCoords[3][0], groundCoords[3][1]);
        printf("Min: %15.5lf, Max: %15.5lf, Accuracy code: %d\n",
                        elevBounds[0],elevBounds[1],accuracyCode);
        printf("Spatial Resolution: %15.5lf, %15.5lf, %15.5lf \n",
           spatialResolution[0],spatialResolution[1],spatialResolution[2]);

    (void) printf("[15] map size is %d x %d\n",
                   profileDimension[0], profileDimension[1]);
}
void writeHeader(outputFile)
    FILE           *outputFile;
{
fprintf(outputFile,"  0\n");
fprintf(outputFile,"SECTION\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"HEADER\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ACADVER\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"AC1009\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$INSBASE\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$EXTMIN\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$EXTMAX\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LIMMIN\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LIMMAX\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"12.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"9.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ORTHOMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$REGENMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$FILLMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$QTEXTMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$MIRRTEXT\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DRAGMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     2\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LTSCALE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$OSMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ATTMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TEXTSIZE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.2\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TRACEWID\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.05\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TEXTSTYLE\n");
fprintf(outputFile,"  7\n");
fprintf(outputFile,"STANDARD\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$CLAYER\n");
fprintf(outputFile,"  8\n");
fprintf(outputFile,"0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$CELTYPE\n");
fprintf(outputFile,"  6\n");
fprintf(outputFile,"BYLAYER\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$CECOLOR\n");
fprintf(outputFile," 62\n");
fprintf(outputFile,"   256\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSCALE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMASZ\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.18\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMEXO\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0625\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMDLI\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.38\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMRND\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMDLE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMEXE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.18\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTP\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTM\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTXT\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.18\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMCEN\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.09\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTSZ\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTOL\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMLIM\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTIH\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTOH\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSE1\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSE2\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTAD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMZIN\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMBLK\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMASO\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSHO\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMPOST\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMAPOST\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMALT\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMALTD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     2\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMALTF\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"25.4\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMLFAC\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTOFL\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTVP\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTIX\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSOXD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSAH\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMBLK1\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMBLK2\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMSTYLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"*UNNAMED\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMCLRD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMCLRE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMCLRT\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMTFAC\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DIMGAP\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.09\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LUNITS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     2\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LUPREC\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     4\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SKETCHINC\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$FILLETRAD\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$AUNITS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$AUPREC\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$MENU\n");
fprintf(outputFile,"  1\n");
fprintf(outputFile,"acad\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ELEVATION\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PELEVATION\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$THICKNESS\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$LIMCHECK\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$BLIPMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$CHAMFERA\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$CHAMFERB\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SKPOLY\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TDCREATE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"2450552.789015509\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TDUPDATE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"2450552.789015509\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TDINDWG\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0000000000\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TDUSRTIMER\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0000000000\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USRTIMER\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ANGBASE\n");
fprintf(outputFile," 50\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ANGDIR\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PDMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PDSIZE\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PLINEWID\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$COORDS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SPLFRAME\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SPLINETYPE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SPLINESEGS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     8\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ATTDIA\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$ATTREQ\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$HANDLING\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$HANDSEED\n");
fprintf(outputFile,"  5\n");
fprintf(outputFile,"0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SURFTAB1\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SURFTAB2\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SURFTYPE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SURFU\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SURFV\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     6\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$UCSNAME\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$UCSORG\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$UCSXDIR\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$UCSYDIR\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PUCSNAME\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PUCSORG\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PUCSXDIR\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PUCSYDIR\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERI1\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERI2\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERI3\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERI4\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERI5\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERR1\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERR2\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERR3\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERR4\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$USERR5\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$WORLDVIEW\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SHADEDGE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     3\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$SHADEDIF\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"    70\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TILEMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$MAXACTVP\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"    16\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PINSBASE\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PLIMCHECK\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PEXTMIN\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"1.000000E+20\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PEXTMAX\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile," 30\n");
fprintf(outputFile,"-1.000000E+20\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PLIMMIN\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PLIMMAX\n");
fprintf(outputFile," 10\n");
fprintf(outputFile,"12.0\n");
fprintf(outputFile," 20\n");
fprintf(outputFile,"9.0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$UNITMODE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$VISRETAIN\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PLINEGEN\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$PSLTSCALE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$TREEDEPTH\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"  3020\n");
fprintf(outputFile,"  9\n");
fprintf(outputFile,"$DWGCODEPAGE\n");
fprintf(outputFile,"  3\n");
fprintf(outputFile,"iso8859-1\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDSEC\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"SECTION\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"TABLES\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"LTYPE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"LTYPE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"CONTINUOUS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"    64\n");
fprintf(outputFile,"  3\n");
fprintf(outputFile,"Solid line\n");
fprintf(outputFile," 72\n");
fprintf(outputFile,"    65\n");
fprintf(outputFile," 73\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"LAYER\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"LAYER\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"0\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile," 62\n");
fprintf(outputFile,"     7\n");
fprintf(outputFile,"  6\n");
fprintf(outputFile,"CONTINUOUS\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"STYLE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"STYLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"STANDARD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile," 40\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 41\n");
fprintf(outputFile,"1.0\n");
fprintf(outputFile," 50\n");
fprintf(outputFile,"0.0\n");
fprintf(outputFile," 71\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile," 42\n");
fprintf(outputFile,"0.2\n");
fprintf(outputFile,"  3\n");
fprintf(outputFile,"txt\n");
fprintf(outputFile,"  4\n");
fprintf(outputFile,"\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"VIEW\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"UCS\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"APPID\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     1\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"APPID\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"ACAD\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"    64\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"TABLE\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"DIMSTYLE\n");
fprintf(outputFile," 70\n");
fprintf(outputFile,"     0\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDTAB\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDSEC\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"SECTION\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"BLOCKS\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"ENDSEC\n");
fprintf(outputFile,"  0\n");
fprintf(outputFile,"SECTION\n");
fprintf(outputFile,"  2\n");
fprintf(outputFile,"ENTITIES\n");
}
