#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

char *cmdname;
void usage(void);

#define TIMINGINFO 1
#ifdef TIMINGINFO
LARGE_INTEGER __freq;
LARGE_INTEGER __tp1, __tp2;
double __ttime;
int __tbytes;
#endif

int __cdecl
main(int argc, char **argv)
{
    int frames = 1;
    char *filename = 0;
    int width = 720, height = 480, bytespp = 2;
    int img_size, img_padded_size;
    char *image, *imagex;
    int ix;

    HANDLE hfile;

    int imgcount, hdr_padded_size, nwritten;

    cmdname = argv[0];

    argc--;
    argv++;

    while (argc > 0) {
	if (!strcmp(*argv, "-f")) {
	    ++argv;
	    --argc;
	    if (argc)
		filename = *argv;
	} else if (!strcmp(*argv, "-n")) {
	    ++argv;
	    --argc;
	    if (argc)
		frames = atoi(*argv);
	} else if (!strcmp(*argv, "-w")) {
	    ++argv;
	    --argc;
	    if (argc)
		width = atoi(*argv);
	} else if (!strcmp(*argv, "-h")) {
	    ++argv;
	    --argc;
	    if (argc)
		height = atoi(*argv);
	} else if (!strcmp(*argv, "-b")) {
	    ++argv;
	    --argc;
	    if (argc)
		bytespp = atoi(*argv);
	}

	--argc;
	++argv;
    }

    if (!frames || !width || !height || !filename || !bytespp)
	usage();

#ifdef TIMINGINFO
    if (!QueryPerformanceFrequency(&__freq)) {
        printf("No frequency counter\n");
        return -1;
    } else {
	printf("Frequency counter rate is %ld\n", __freq);
    }
#endif

printf ("Creating file %s, %d frames, width %d, height %d, bytesperpixel %d\n",
	filename, frames, width, height, bytespp);

    // Figure out the image size
    img_size = width * height * bytespp;

    // Figure out the padded image (buffer) size
#define PADTO	4096
    img_padded_size = ((img_size + (PADTO-1)) / PADTO) * PADTO;

    // Make an image given the image sizes
    imagex = malloc(width*height*bytespp + PADTO);
    if (!imagex) {
	printf ("Oops line %d\n", __LINE__);
	exit(1);
    }
    image = (char *)(((unsigned)imagex + PADTO ) & ~(PADTO-1));
    for (ix = 0; ix < width*height*bytespp; ix++)
	image[ix] = 0xee;
#undef PADTO

    // Open the file
    hfile = CreateFile(filename,
		      GENERIC_WRITE,	// write access
		      0,		// share mode - do not share
		      NULL,		// no security heritage
		      CREATE_ALWAYS,	// open existing, fail otherwise
		      FILE_ATTRIBUTE_NORMAL
		      | FILE_FLAG_NO_BUFFERING, // use Direct I/O
		      NULL );		// no template file

    if (!hfile) {
	printf ("Oops line %d\n", __LINE__);
	exit(1);
    }

#ifdef TIMINGINFO
    if (!QueryPerformanceCounter(&__tp1)) {
	printf ("QueryPerformanceCounter failed line %d\n", __LINE__);
    }
#endif

    // Write the image to the file
    for (imgcount = 0; imgcount < frames; ++imgcount) {
	if ((WriteFile(hfile, image, 
		    img_padded_size, &nwritten, NULL) == FALSE)
		|| (nwritten != img_padded_size)) {
	    printf ("Unable to write entire buffer %d\n", imgcount);
	    break;
	}
    }

#ifdef TIMINGINFO
    if (!QueryPerformanceCounter(&__tp2)) {
	printf ("QueryPerformanceCounter failed line %d\n", __LINE__);
    }
#endif

    // Close the file
    CloseHandle(hfile);

    // Free up the image we created
    free(imagex);

    printf ("File size should be %d bytes\n", 
	imgcount * img_padded_size);

#ifdef TIMINGINFO
    __ttime = (double)(__tp2.QuadPart - __tp1.QuadPart)/__freq.QuadPart;
    __tbytes = imgcount * img_padded_size;

    printf ("Elapsed time: %3.3f seconds\n", __ttime);
    printf ("Writing performance: %3.3f bytes/sec, %d byte writes\n", 
	__tbytes/__ttime, img_padded_size);
#endif
    
    return 0;
}

void 
usage(void)
{
    printf ("%s -f filename -n count -w width -h height -b bytesperpixel\n",
	cmdname);
    exit(1);
}

