//------------------------------------------------------------------------------
//	File:					initapp.cp
//	Date:					9/30/96
//	Author:				Bretton Wade
//
//	Description:	this file contains the application code for the Win95
//								interface. This is not intended to be a model Win95
//								application.
//
//------------------------------------------------------------------------------

#include	"precompile.h"
#include	"view.h"
#include	"cube.h"
#include	"bsptree_3d.h"
#include	"transform_3d.h"

//------------------------------------------------------------------------------
#define	CLASS_NAME	"BSP Tree Demo"																							//	name of the window class and menu name

//------------------------------------------------------------------------------
static	MSG			gMessage;																												//	place to get a message
static	HWND		gWindow;																												//	global handle to the window structure
static	bool		gClick = FALSE;																									//	whether or not the mouse is down
static	bool		gDrawn;																													//	whether or not the view has been drawn
static	view		*gView;																													//	the world viewer
bsptree					*world;																													//	the bsp tree based world description

//------------------------------------------------------------------------------
void	InitializeModel (void)																										//	build the model that we want to display
{																																								//	begin
	world = new bsptree;																													//	create a new bsp tree
	world->Insert (Cube (IDENTITY_MATRIX), HC_OUT, HC_OUT);												//	insert a basic cube
	world->Insert (																																//	cut out the cube to make a big "C"
		Cube (
			Scale (R(-1.5), R(-0.875), R(-1.5)) * 
			Translate (R(0.625), R(0.0), R(0.0))
		), 
		HC_IN, HC_SPANNING);
	world->Reduce ();																															//	strip out polygons which are no longer part of the object
	world->Insert (																																//	then add a slab
		Cube (
			Scale (R(0.75), R(1.25), R(0.125)) * 
			RotateY (R(-15.0)) * 
			Translate (R(0.5), R(0.0), R(0.0))
		), 
		HC_OUT, HC_SPANNING);
}																																								//	end

//------------------------------------------------------------------------------
long FAR PASCAL	WinProc (HWND window, UINT message, WPARAM wpar, LPARAM lpar)		//	window proc for the application window
{																																								//	begin
	switch (message)																															//	check the message
	{																																							//	begin
		case WM_ACTIVATE:																														//	on a window activate
			gDrawn = FALSE;																														//	clear the drawn flag
			break;																																		//	end case
		case WM_MOUSEMOVE:																													//	on a mouse moved
			if (gClick)																																//	if the mouse is down
			{																																					//	begin
				POINT	pt;																																//	placeholder point
				pt.x = LOWORD (lpar);																										//	fetch the x coordinate of the mouse
				pt.y = HIWORD (lpar);																										//	fetch the y coordinate of the mouse
				gView->HandleDrag (pt);																									//	drag the view according to the mouse location
			}																																					//	end
			break;																																		//	end case
		case WM_LBUTTONDOWN:																												//	if the left mouse button is clicked down
			{																																					//	begin
			ShowCursor (FALSE);																												//	hide the cursor
			gClick = TRUE;																														//	set the click flag
				POINT	pt;																																//	placeholder point
				pt.x = LOWORD (lpar);																										//	fetch the x coordinate of the mouse
				pt.y = HIWORD (lpar);																										//	fetch the y coordinate of the mouse
			gView->HandleClick (pt);																									//	start the drawing environment for a drag
			}																																					//	end
			return 0;																																	//	end case, don't let anybody else do anything with this event
		case WM_LBUTTONUP:																													//	left mouse button lifted
			gClick = FALSE;																														//	clear the click flag
			gView->StartDrawing ();																										//	open the drawing environment
			gView->DrawScene ();																											//	re-draw the scene
			gView->StopDrawing ();																										//	close the drawing environment
			ShowCursor (TRUE);																												//	show the cursor
			return 0;																																	//	end case, don't let anybody else do anything with this event
		case WM_KEYDOWN:																														//	key pressed message
			if (wpar == VK_ESCAPE)																										//	if the key is the escape key
			{																																					//	begin
				delete gView;																														//	release the view
				PostMessage (window, WM_CLOSE, 0, 0);																		//	close the window
			}																																					//	end
			break;																																		//	end case
		case WM_DESTROY:																														//	destroy the window
			PostQuitMessage (0);																											//	quit
			break;																																		//	end case
	}																																							//	end
	return DefWindowProc (window, message, wpar, lpar);														//	default window behavior
}																																								//	end

//------------------------------------------------------------------------------
static	void	Open (HINSTANCE instance, int show)																//	initialize the application
{																																								//	begin
	WNDCLASS	wClass;																															//	window class definition
	wClass.style = CS_HREDRAW | CS_VREDRAW;																				//	style flags
	wClass.lpfnWndProc = WinProc;																									//	set the window proc
	wClass.cbClsExtra = 0;																												//	no extra data
	wClass.cbWndExtra = 0;																												//	no extra data
	wClass.hInstance = instance;																									//	the application instance
	wClass.hIcon = LoadIcon (instance, IDI_APPLICATION);													//	generic application
	wClass.hCursor = LoadCursor (0, IDC_ARROW);																		//	normal cursor
	wClass.hbrBackground = 0;																											//	no background
	wClass.lpszMenuName = CLASS_NAME;																							//	class name
	wClass.lpszClassName = CLASS_NAME;																						//	class name
	RegisterClass (&wClass);																											//	register the class
	gWindow = CreateWindowEx (WS_EX_TOPMOST, CLASS_NAME, CLASS_NAME, WS_POPUP, 0, 0, GetSystemMetrics (SM_CXSCREEN), GetSystemMetrics (SM_CYSCREEN), 0,0, instance, 0);//	create the window
	ShowWindow (gWindow, show);																										//	show the window
	UpdateWindow (gWindow);																												//	update the window
	SetFocus (gWindow);																														//	set the window focus to my window
	InitializeModel ();																														//	build the model
	gView = new view (gWindow);																										//	create the world view
}																																								//	end

//------------------------------------------------------------------------------
static	void	Loop (void)																												//	the main application loop
{																																								//	begin
	bool	done = FALSE;																														//	the done flag
	while (!done)																																	//	loop until we are done
		if (PeekMessage (&gMessage, 0, 0, 0, PM_NOREMOVE))													//	if there is a message in the queue
			if (GetMessage (&gMessage, gWindow, 0, 0) == TRUE)												//	if the message is not a quit message
				DispatchMessage (&gMessage);																						//	send the message to the appropriate window
			else																																			//	otherwise we want to quit
				done = TRUE;																														//	set the finished flag
		else																																				//	otherwise, the application is not active
			if (!gDrawn)																															//	if the interface has not been drawn
			{																																					//	begin
				gView->StartDrawing ();																									//	start the drawing environment
				gView->DrawScene ();																										//	draw the scene
				gView->StopDrawing ();																									//	close the drawing environment
				gDrawn = TRUE;																													//	set the drawn flag
			}																																					//	end
			else																																			//	otherwise
				WaitMessage ();																													//	just wait for a message
}																																								//	end

//------------------------------------------------------------------------------
static	void	Close (void)																											//	close the application
{																																								//	begin
}																																								//	end

//------------------------------------------------------------------------------
int PASCAL	WinMain (HINSTANCE inst, HINSTANCE prev, LPSTR cmdLine, int show)		//	windows main
{																																								//	begin
	Open (inst, show);																														//	open the application
	Loop ();																																			//	do the main loop
	Close ();																																			//	close the application
	return TRUE;																																	//	return success
}																																								//	end

//------------------------------------------------------------------------------
