{This code contains sprite handling routines and variables etc.}
{
- Type Sprite8Type = Array[0..7] Of Byte;
       SpriteColorArrayType=Array[0..15] Of Byte;

- Const ArrowSprite :Sprite8Type = ($fe,$fc,$f0,$f8,$dc,$ce,$87,$03);
        ArrowSprite2:Sprite8Type = ($fe,$84,$88,$88,$b4,$ca,$85,$02);
        FingerSprite:Sprite8Type = ($06,$06,$06,$57,$7f,$7f,$7e,$3c);
        SquareSprite:Sprite8Type = (255,129,129,129,129,129,129,255);
        TimeGlassSprite:Sprite8Type =($7e,$7e,$3c,$18,$18,$3c,$7e,$7e);
        WhiteArray  :SpriteColorArrayType = (15,15,15,15,15,15,15,15,
                                             15,15,15,15,15,15,15,15);
                                             (Use to create white sprite.)

        YellowArray  :SpriteColorArrayType = (10,10,10,10,10,10,10,10,
                                             10,10,10,10,10,10,10,10);
        RedArray  :SpriteColorArrayType = (8,8,8,8,8,8,8,8,
                                           8,8,8,8,8,8,8,8);
- Procedure SetSpritePattern(PatternNumber:Byte;Var PatternArray:Sprite8Type);
- Procedure PutSprite(SpriteNum,SpritePatternNum,x,y:Byte);
- Procedure SetSpriteColors(SpriteNum:Byte; AttributeA:SpriteColorArrayType);

- Procedure _WriteVram(VramBlockUsed:Byte;
                     VramAddr,RamAddr,ByteCount:Integer);  (system used)
- Procedure _FillVram(VramBlockUsed:Byte;
                     VramAddr:Integer;FillValue :Byte;     (system used )
                     ByteCount:Integer);
}

Type Sprite8Type = Array[0..7] Of Byte;
     SpriteColorArrayType=Array[0..15] Of Byte;

Const ArrowSprite :Sprite8Type = ($fe,$fc,$f0,$f8,$dc,$ce,$87,$03);
      ArrowSprite2:Sprite8Type = ($fe,$84,$88,$88,$b4,$ca,$85,$02);
      FingerSprite:Sprite8Type = ($06,$06,$06,$57,$7f,$7f,$7e,$3c);
      SquareSprite:Sprite8Type = (255,129,129,129,129,129,129,255);
      TimeGlassSprite:Sprite8Type =($7e,$7e,$3c,$18,$18,$3c,$7e,$7e);

      WhiteArray  :SpriteColorArrayType = (15,15,15,15,15,15,15,15,
                                           15,15,15,15,15,15,15,15);
      YellowArray  :SpriteColorArrayType = (10,10,10,10,10,10,10,10,
                                             10,10,10,10,10,10,10,10);

      RedArray  :SpriteColorArrayType = (8,8,8,8,8,8,8,8,
                                           8,8,8,8,8,8,8,8);

Procedure _WriteVram(VramBlockUsed:Byte;
                    VramAddr,RamAddr,ByteCount:Integer);

{ VramBlocUsed  = 0 = first 64 Kb
                  1 = second 64 Kb
                  2 = Expansion Vram 64 Kb }


Var Expansion, AddrHi, AddrMid, AddrLo :Byte;

Begin
  If VramBlockUsed = 2 Then Expansion := $40 {Set the bit 6 (MXC) }
   Else Expansion := 0 ; {No expansion vram used}
  AddrHi := Hi(VramAddr) Div $40;
  If VramBlockUsed = 1 Then AddrHi := AddrHi + 4 ;
    {Set addr bit 16 in reg 14 = bit 2 }
  AddrLo := Lo(VramAddr);
  AddrMid := Hi(Vramaddr) And 63 ;

  Inline(
      $F3/$3A/ Expansion /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$3A/ AddrHi /$D3/      $99/$3E/$0E/$F6/$80/$D3/$99/$3A/ AddrLo /$00/$D3/$99/$3A/ AddrMid /$F6/      $40/$D3/$99/$2A/ RamAddr /$ED/$4B/ ByteCount /$7E/$D3/$98/$23/$0B/$79/      $B0/$20/$F7/ $F3/$3e/ 0  /$D3/$99/$3E/$2D/$F6/$80/$D3/$99
        );End;

Procedure _FillVram(VramBlockUsed:Byte;
                    VramAddr:Integer;FillValue :Byte;
                    ByteCount:Integer);

{ VramBlocUsed  = 0 = first 64 Kb
                  1 = second 64 Kb
                  2 = Expansion Vram 64 Kb }


Var Expansion, AddrHi, AddrMid, AddrLo :Byte;
    RamAddr :Integer;
Begin
  If VramBlockUsed = 2 Then Expansion := $40 {Set the bit 6 (MXC) }
   Else Expansion := 0 ; {No expansion vram used}
  AddrHi := Hi(VramAddr) Div $40;
  If VramBlockUsed = 1 Then AddrHi := AddrHi + 4 ;
    {Set addr bit 16 in reg 14 = bit 2 }
  AddrLo := Lo(VramAddr);
  AddrMid := Hi(Vramaddr) And 63 ;
  RamAddr := Addr(FillValue);
  Inline(
      $F3/$3A/ Expansion /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$3A/ AddrHi /$D3/      $99/$3E/$0E/$F6/$80/$D3/$99/$3A/ AddrLo /$00/$D3/$99/$3A/ AddrMid /$F6/      $40/$D3/$99/$2A/ RamAddr /$ED/$4B/ ByteCount /$7E/$D3/$98/0/$0B/$79/      $B0/$20/$F7/ $F3/$3e/ 0  /$D3/$99/$3E/$2D/$F6/$80/$D3/$99
        );End;

Procedure SetSpritePattern(PatternNumber:Byte;Var PatternArray:Sprite8Type);

  Var  Vdp6 :Byte absolute  $f3e5;
       VramAddr :Integer;
       A  :Sprite8Type;
  Begin
    A := PatternArray;
    VramAddr := (Vdp6 * $800) + (PatternNumber * 8);
    WriteVram(0,VramAddr,Addr(A),8);
  End;

Procedure PutSprite(SpriteNum,SpritePatternNum,x,y:Byte);

  Var  Vdp5 :Byte Absolute  $f3e4;
       Vdp11:Byte Absolute  $ffea;

  Var VramAddr :Integer;
      Buf      :Array[0..3] Of Byte;

  Begin
    VramAddr := ((Vdp5 And 252) * $80) +(Vdp11 * $8000) + (SpriteNum * 4);
    Buf[0] := y;
    Buf[1] := x;
    Buf[2] := SpritePatternNum;

    WriteVram(0,VramAddr,Addr(Buf),4);
  End;

Procedure SetSpriteColors(SpriteNum:Byte; AttributeA:SpriteColorArrayType);

{Attribute bit 7 = EC  32 bit shit 1=on 0=off}
{          bit 6 = CC  Change priority (read vdp manual }
{          bit 5 = IC  this line ,bit set 0, does not conflict other sprites}
{          bit 4 = 0   not used}
{          bits 3..0   colour code 0 to 15;}

   Var Vdp5  :Byte Absolute $f3e4;
       Vdp11 :Byte Absolute $ffea;
       AttrA :SpriteColorArrayType ;
       VramAddr :Integer;
   Begin
       AttrA := AttributeA;
       VramAddr := ((Vdp5 And 252) * $80) + (Vdp11 * $8000) - 512
                    + (SpriteNum * 16) ; {Colour table}
       WriteVram(0,VramAddr,Addr(AttrA),16);
   End;

Procedure ClearAllSprites;
 Const FillValue = 0;
 Var VramAddr :Integer;
     Vdp6 :Byte absolute  $f3e5;
 Begin
   VramAddr := Vdp6 * $800;
   FillVram(0,VramAddr,FillValue,8*256); { Zero the Sprite Pattern table }
 End;