; macro's.asm needs to be included first


; how to call the routine:
	ld de,$3600		
	ld hl,spritedata1
	ld bc,32
	ld a,0
	Call CopyRamVram			; copy a block from ram to vram
	
      ret

     
;--------------
CopyRamVram:
; routine : Copy part of RAM to VRAM.
; in      : A - VRAM page, DE - Offset VRAM (destination), HL - Source pointer, BC - Number of
;             Bytes...
; out     : none.
; cmnt    : none.

	push	af

	ld	a,c
	ld	(CRVLastOut),a

	pop	af
	push	hl

	ex	de,hl
	call	SetVramWrite
	pop	hl
	ld	a,b
	or	a
	jp	z,CRVLoop1Done
	ld	d,b
	ld	c,$98

CpRamVramLp1:
	ld	b,$00
	otir

	dec	d
	jr	nz,CpRamVramLp1

CRVLoop1Done:
	ld	a,(CRVLastOut)
	or	a
	ret	z

	ld	b,a

	ld	c,$98
	otir

	ret

SetVramWrite:
; routine : Set Vram Pointer in write mode.
; in      : A - page, HL - offset
; out     : none.
; cmnt    : none.

	di

	out	($99),a	 	; out page to 			register #14 of the VDP
	ld	a,14+128	;
	out	($99),a	;

	ld	a,l	; Get LSB of offset
	out	($99),a	; out to VDP

	ld	a,h	; Get MSB of offset

	and	$3f	; clear last two bits
	or	$40	; set bit 6 (write)

	out	($99),a	; iut to VDP

	ei

	ret

CRVLastOut:
	.db	0

