PROGRAM memStat(output);

CONST
   version = '1.0';

TYPE
   string50 = string[50];

VAR
  mmVersion : real;
  showJosTelInfo : boolean;
  output : text;


PROCEDURE printIntro;

BEGIN
   writeLn(output);
   writeLn(output,'MemStat ',version,' - by MJV');
   writeLn(output,'(c) 1991  Jos-Tel M.S. BBS');
   writeLn(output);
END;


PROCEDURE printJosTelInfo;

BEGIN
  writeLn(output);
  writeLn(output,'This program is a product of Jos-Tel M.S. BBS');
  writeLn(output,'Available 24 hours/day        Tel: 05149-1837');
  writeLn(output,'Boppelans 24, 8721 GG  Warns, The Netherlands');
  writeLn(output);
  writeLn(output,'Jos-Tel is raising funds for Multiple Sclersose research');
END;


PROCEDURE writeStatLn(line {in} : string50);

VAR
   i : integer;

BEGIN
   line := line + ' ';
   FOR i := length(line) + 1 TO 50 DO line[i] := '.';
   line[0] := #50;
   write(output,line)
END;


FUNCTION findMemMan(VAR mmVersion {out}: real) : boolean;

VAR
   checkSum : char;
   mmVer    : integer;

BEGIN
   inline
      ($AF/          { xor a            }
       $11/$4D1E/    { ld de,mmIniChk   }
       $CD/$FFCA/    { call extBio      }
       $32/checkSum/ { ld (checkSum),a  }
       $ED/$53/mmVer { ld (mmVer),de    }
      );

   IF checkSum = 'M'
      THEN
         BEGIN
            findMemMan := true;
            mmVersion := hi(mmVer) + lo(mmVer) / 10
         END
      ELSE findMemMan := false
END;


PROCEDURE printNoMemMan;

BEGIN
   writeStatLn('MemMan memory manager');
   writeLn(output,' Not installed')
END;


PROCEDURE printVersion(mmVersion {in}: real);

BEGIN
   writeStatLn('MemMan version');
   writeLn(output,mmVersion:4:1)
END;


PROCEDURE printMMStatus;

CONST
   pbName : string[12] = 'MJV Printbuf';

VAR
   connStat : byte;
   totalSeg,
   freeSeg,
   dos2Seg,
   rdSize,
   pbNameAddr,
   pbSize   : integer;

BEGIN
   inline
      ($11/$4D1F/          { ld de,mmStatus   }
       $CD/$FFCA/          { call extBio      }
       $32/connStat/       { ld (connStat),a  }
       $ED/$43/freeSeg/    { ld (freeSeg),bc  }
       $ED/$53/dos2Seg/    { ld (dos2Seg),de  }
       $22/totalSeg        { ld (totalSeg),hl }
      );
   writeStatLn('MSX-DOS2 Mapper Support routines');
   IF (connStat AND 1) = 1
      THEN writeLn(output,' Active')
      ELSE writeLn(output,' Not active');

   writeStatLn('Total amount of RAM memory');
   writeLn(output,totalSeg*16:5,'kB':5);

   writeStatLn('Total amount of mapper-memory registered by DOS2');
   writeLn(output,dos2Seg*16:5, 'kB':5);

   writeStatLn('Free memory in MemMan segments');
   writeLn(output,freeSeg*16:5, 'kB':5);

   writeStatLn('Total amount of memory in system segments');
   writeLn(output,(totalSeg - freeSeg - 4)*16:5, 'kB':5); { Do not count TPA }

   inline
      ($01/$FF68/          { ld bc,getRdSize  }
       $CD/>$0005/         { call bDos        }
       $ED/$43/rdSize      { LD (rdSize),bc   }
      );
   rdSize := hi(rdSize) * 16;   { Size was returned in B register }
   writeStatLn('Memory allocated by DOS2 RAMdisk');
   writeLn(output,rdSize:5, 'kB':5);

   pbNameAddr := addr(pbName[1]);
   inline
      ($2A/pbNameAddr/         { ld hl,(pbNameAddr)     }
       $11/ 62/$4D/            { ld d,'M'  ld e,GetTsrID}
       $CD/$FFCA/              { call extBio            }
       $21/>$0000/             { ld hl,0                }
       $38/$08/                { jr c,noPb              }
       $3E/$03/                { ld a,getFre            }
       $11/ 63/$4D/            { ld d,'M'  ld e,tsrCall }
       $CD/$FFCA/              { call extBio            }
       $22/pbSize              { noPb: ld (pbSize),hl   }
      );
   writeStatLn('Memory allocated by Printer Buffer');
   writeLn(output,pbSize:5, 'kB':5)
END;


PROCEDURE printTPAStatus;

VAR
   endTPA  : integer ABSOLUTE 6;
   freTPA  : real;

BEGIN
   freTPA := (endTPA - $100) / 1024;
   IF freTPA < 0 THEN freTPA := freTPA + 64; { Convert to unsigned integer }

   writeStatLn('Free DOS program memory (TPA)');
   writeLn(output,freTPA:7:1, ' kB');

   writeStatLn('Page 3 memory used by system variables');
   writeLn(output,64 - freTPA:7:1, ' kB')
END;


PROCEDURE printHeapStatus;

VAR
   heapMax : integer;

BEGIN
   inline
      ($11/$4D48/          { ld de,mmHeapMax  }
       $CD/$FFCA/          { call extBio      }
       $22/heapMax         { ld (heapMax),hl  }
      );
   writeStatLn('Largest available block of heap memory');
   writeLn(output,heapMax:7, ' bytes')
END;


BEGIN
  IF (pos('/',paramStr(1)) = 0) AND (paramCount > 0)
     THEN assign(output,paramStr(1))   { Allow redirectioning }
     ELSE assign(output,'con');
  rewrite(output);

  printIntro;

  IF findMemMan(mmVersion)
     THEN
        BEGIN
           printVersion(mmVersion);
           printMMStatus;
           printTPAStatus;
           IF trunc(mmVersion) > 1 THEN printHeapStatus
        END
     ELSE
        BEGIN
           printNoMemMan;
           printTPAStatus
        END;

  showJosTelInfo := (pos('/S',paramStr(paramCount)) +
     pos('/s',paramStr(paramCount))) = 0;
  IF showJosTelInfo THEN printJosTelInfo;

  close(output)
END.
