/* EXAMPLE.COM	- Example of how to work with SCSI from C
   v1.0 8 july 1995, (c)1995 Gert de Boom

   N.B. MSXBIOS.MAC should be linked !!

   Feel free to base your work upon this example
 */

#define SetWD3393	0x7f83
#define TermAct         0x7f86
#define RdSecDir        0x7f89
#define WrSecDir        0x7f8c
#define ReqSense        0x7f8f
#define Inquiry         0x7f92
#define ReadCap         0x7f95
#define ModeSense       0x7f98
#define ModeSel         0x7f9b
#define FmtUnit         0x7f9e
#define TstUnitRdy      0x7fa1
#define Initialise      0x7fa4
#define InsWork         0x7fa7
#define ClrEndLn        0x7faa
#define Verify          0x7fad
#define StrtStpUn       0x7fb0
#define SndDiag         0x7fb3
#define RdDefect        0x7fbf
#define GETWRK          0x7fc2
#define PartInfo        0x7fc5
#define GetUnitsOn      0x7fc8
#define SetHOST_ID      0x7fcb
#define SetTargetID     0x7fce
#define GetTargetID     0x7fd1
#define GetHOST_ID      0x7fd4
#define GetSense        0x7fd7
#define MedRemoval      0x7fda

#define true  1
#define false 0

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <msxbios.h>
#include <bdosfunc.h>

int slot;

int getHostId()
{
 REGS reg;
 calslt((TINY)slot, GetHOST_ID, &reg);
 return ((int)reg.a);
}

int isUnitReady(id)
int id;
{
 REGS reg;
 if (id == getHostId()) return(true);
 reg.a = (TINY)id; 
 calslt((TINY)slot, TstUnitRdy, &reg);
 return (reg.de/0xFF != 0x02);
}

/* Should check for versionnumber also */
int initSCSI()
{
 int i, result;
 TINY slt;
 result = -1;
 for(i=0; i<4; i++)
 {
  slt = (*(TINY *)(0xfb22+i*2));
  if (slt!=0)
  {
   if (rdslt(slt, 0x7ff0)=='K')
    if (rdslt(slt, 0x7ff1)=='M')
     if (rdslt(slt, 0x7ff2)=='c')
      if (rdslt(slt, 0x7ff3)=='s')
      {
       result = (int)slt;
       break;
      }  
  }
 }
 return (result);
}

int main(argc, argv)
int argc;
char **argv;
{
 int i;
 slot = initSCSI();
 if (slot==-1)
 {
  printf("SCSI BIOS not found, not installed or wrong version\n");
  exit(1); 
 }
 for(i=0; i<8; i++)
 { 
  printf("Device with ID %d is ", i);
  if (!isUnitReady(i)) printf("not ");
  printf("ready\n");  
 }
 return(true);
}
