program msx12cnv (input,output) ;
  {

    V1.0 Hans Otten

    first edit  17 september 1991

    last update 2-june-1999

    compile using Turbo Pascal V6

  }
  uses

    Dos, Crt, Graph;

  const

    outbuflen    = 20*1024 - 1 ;
    bufferlen    = 20*1024 - 1 ;
    picture_byte = $FE ;                { identification of file BSAVEd   }

  type

    filename       = string[255] ;
    buffertype     = array[0..bufferlen] of byte ;
    outbuffertype  = array[0..outbuflen] of byte ;

  var

    scr12_rgb : array[1..4] of byte ;

    view          : boolean ;   { true als display on screen   }
    output_file,                { output PCX 24 bit file       }
    picture_file  : file ;      { input MSX picture file       }
    output_name,
    picture_name  : filename ;  { MS(X)-DOS filename of picture}

    output_buffer : outbuffertype ;
                               { output buffer                 }
    buffer : buffertype ;      { holds to process input line   }

    end_line,
    dc,
    numread,
    outbufferpos,
    bufferpos  : integer ;     { position in line              }




procedure OpenGraph ;

  type

    ColorValue     = record
                       Rv, Gv, Bv: byte;
                     end;
    VGAPaletteType = array[0..256] of ColorValue;



  var

    r, g, b,
    vr, vg, vb  : integer ;
    color_nr : integer ;

    S: PathStr;
    Dir  : DirStr;
    Name : NameStr;
    Ext  : ExtStr;

    P : VGAPalettetype ;
    AutoDetectPointer : pointer;
    Driver, Mode : integer;
    ErrorCode : integer;

  {$F+}
  function DetectVGA256 : integer;

    var

      DetectedDriver : integer;
      SuggestedMode  : integer;

    begin
      DetectGraph(DetectedDriver, SuggestedMode);
      if (DetectedDriver = VGA) or
         (DetectedDriver = MCGA)
        then
          DetectVGA256 := 0        { Default video mode = 0 }
        else
          begin
            writeln ;
            writeln('VGA of MCGA display required for MSX12CNV') ;
            halt(1) ;
          end ;

    end; { DetectVGA256 }
    {$F-}

    procedure VGASetAllPalette (var P : VGAPaletteType) ;

      var

        Regs : Registers;

      begin

        with Regs do
          begin
            AX := $1012 ; { INT 10 subfunction 12 : fill Video DAC registers }
            BX := 0;
            CX := 256;
            ES := Seg(P);
            DX := Ofs(P);
          end;
        Intr($10, Regs);

      end ; { VGASetAllPalette }

  begin

    { try to locate VGA256.BGI on the path }
    S := FSearch('VGA256.BGI',GetEnv('PATH'));
    if S = ''
      then
        begin
          CloseGraph ;
          WriteLn('File VGA256.BGI not on PATH ') ;
          halt(1) ;
        end
      else
        { split filespec into directory path info for InitGraph }
        Fsplit(FExpand(S),Dir,Name,Ext) ;

    ClrScr;
    DirectVideo := false;
    AutoDetectPointer := @DetectVGA256; { Point to detection routine }
    Driver := InstallUserDriver(Name, AutoDetectPointer);
    Driver := Detect;
    InitGraph(Driver, Mode, Dir);
    ErrorCode := GraphResult;
    if ErrorCode <> grOK then
      begin
        CloseGraph ;
        Writeln('Fatal graphics error ', GraphErrorMsg(ErrorCode));
        Halt(1);
     end;

    { fill palette with fixed values for grey colors }
    for color_nr := 0 to 63 do
      begin
        p[color_nr].rv := color_nr ;
        p[color_nr].gv := color_nr ;
        p[color_nr].bv := color_nr ;
      end ;
    VGASetAllPalette(P);

  end ; { OpenGraph }

procedure Wait ;

  { wait until keypressed }

  var

    ch : char;
    count : word ;

  begin

    write(chr(7)) ;
    repeat
    until KeyPressed ;
    ch := ReadKey;
    if ch = #0
      then
        ch := ReadKey
    else if ch = chr(27)
      then
        begin
          CloseGraph ;
          writeln ;
          writeln('MSX12CNV V1.2(c) Hans Otten 1991,1999') ;
          halt(0) ;
        end ;


  end ;  { wait }


  procedure CheckParameters ;

    {

      command line syntax:

        MSX12CNV picture-file outputfile

    }


  procedure ShowHelp ;

    {
      show of argument is help a screen full of information
    }

    begin

      writeln('V1.2 (c) Hans Otten 1991,1999') ;
      writeln('') ;
      writeln('Command line syntax:') ;
      writeln('') ;
      writeln('  MSX12CNV <msx-file> [<pcx-file]') ;
      writeln('') ;
      writeln('MSX file is Bsaved screen 12 file') ;
      writeln('') ;
      writeln('no pcx-file will show picture') ;
      writeln('in grey only on VGA)') ;
      writeln('') ;
      writeln('') ;
      writeln('pcx-file is 24 bits PCX file') ;
      writeln('') ;
      writeln('MSX12CNV help : show this help') ;
      writeln('') ;

    end ; { ShowHelp }


  begin

    { say hello }
    writeln ;

    picture_name[0]   := chr(0) ;

    { see if help wanted }
    if (paramcount = 1) and
       ( (paramstr(1) = 'help') or (paramstr(1) = 'HELP'))
      then
        begin
          ShowHelp ;
          halt(0) ;
        end ;

    { no help, so check correct nr of arguments }
    if paramcount < 1
      then
        begin
          writeln('syntax error, type MSX12CNV help') ;
          halt(1) ;
        end
      else
        begin
          picture_name   := paramstr(1) ;
        end ;

      view := (paramcount < 2) ;
      if not view
        then
          output_name := paramstr(2) ;

  end ; { CheckParameters }


  procedure PutByte(b : byte) ;

    begin

      if outbufferpos = outbuflen
        then
          begin
            blockwrite(output_file,output_buffer,outbuflen) ;
            outbufferpos := 0 ;
          end ;

      output_buffer[outbufferpos] := b ;
      inc(outbufferpos) ;

    end ; { PutByte }


procedure OpenFiles ;

  {
    Turbo pascal V5 style: record size = 1
  }

  var

    filname : string[255] ;
    count : integer ;

  begin

    assign(picture_file, picture_name ) ;
    {$I-}
    reset(picture_file,1) ;
    {$I+}
    if IOresult <> 0
    then
      begin
        if view
          then
            CloseGraph ;
        writeln ;
        writeln('File ',picture_name, ' open error' ) ;
        halt(1) ;
      end ;

    { force buffered reading if get_char called first time }
    bufferpos := 0 ;
    numread := 0 ;

    if not view
      then
        begin
          assign(output_file, output_name ) ;
          {$I-}
          rewrite(output_file,1) ;
          {$I+}
          if IOresult <> 0
            then
              begin
                writeln ;
                writeln('File ', output_name, ' open error') ;
              end ;
          outbufferpos := 0 ;
        end
      else
        OpenGraph ;

  end ; { OpenFiles }


procedure CloseFiles ;

  begin

    close(picture_file) ;
    if not view
      then
        begin
          if outbufferpos > 0
            then
              blockwrite(output_file,output_buffer,outbufferpos) ;
         close(output_file) ;
        end
      else
        CloseGraph ;

  end ; { CloseFiles }

function GetByte : byte ;

  {
   returns next byte from input
  }

    procedure get_buffer ;

    {
     returns next buffer from input file
     expects file to be opened
     uses blockread to read file unstructured

     modifies

       bufferpos
       buffer
    }

    var

      count : integer ;

    begin

      bufferpos := 0 ;
      blockread(picture_file,buffer,bufferlen,numread) ;
      { fill rest of picture with black pixels }
      if numread = 0
        then
          begin
            for count := 0 to bufferlen  do
              buffer[count] := 0 ;
            numread := bufferlen ;
          end ;

     end ; { get_buffer }

  begin { main GetByte }

    if bufferpos = numread
      then
        get_buffer ;
    GetByte := buffer[bufferpos] ;
    bufferpos := bufferpos + 1 ;

  end ; { GetNextbyte }

procedure ConvertPicture ;

    var

      ch : char;
      count,
      current_byte,
      previous_byte,
      repeat_count,
      line_count, row_count : integer ;
      R_plane,
      G_plane,
      B_plane  : array[1..256] of byte ;


  procedure get_screensize ;

    {
      checks if this is picture file by checking first byte
      returns from screen file : start end
      skips executing address
    }

    var

      msxtype              : integer ;
      beginlow, beginhigh,
      endlow, endhigh      : integer ;

    begin

      { check picture filetype byte }

      msxtype := Getbyte ;
      if msxtype <> picture_byte
        then
          begin
            if view
              then
                CloseGraph ;
            CloseFiles ;
            writeln(picture_name,' is not MSX screen 12 BSaved') ;
            halt(1) ;
          end ;

      { skip begin and end bytes }
      beginlow  := GetByte ;
      beginhigh := GetByte ;
      endlow    := GetByte ;
      endhigh   := GetByte ;

      { skip executing address }
      msxtype := GetByte ;
      msxtype := GetByte ;

    end ; { Get_screensize }

  procedure Init_PCX ;

    var

      count,
      color_count,
      remap_count : integer ;
      col,
      row : integer ;


    begin { main Init_PCX }

      { write manufacturer }
      PutByte($0A) ;

      { version nr }
      PutByte($05) ;

      { encoding runlength }
      PutByte($01) ;

      { write bits per pixel }
      PutByte(8) ;

      { write window sizes }
      for count := 1 to 4 do               { low      }
        PutByte(0) ;
      PutByte(255) ; { high col }
      PutByte(0) ;
      PutByte(211) ; { high row }
      PutByte(0) ;

      { dummy HDPI and VDPI }
      PutByte(0) ; { high col }
      PutByte(0) ;
      PutByte(0) ; { high row }
      PutByte(0) ;

      for count := 0 to 47 do
        PutByte(0) ;

      PutByte(0) ;  { reserved }
      { write nr of planes }
      PutByte(3) ;

      { write bytes per line }
      PutByte(00) ;
      PutByte(1) ;
      PutByte(1) ;

      for count := 69 to 127 do
        PutByte(0) ;

      { initialise packing }
      current_byte := 0 ;
      previous_byte := 0 ;
      repeat_count := 0 ;

    end ; { Init_PCX }

  procedure dump_repeat ;

    begin

      if repeat_count > 0
        then
          begin
            if (repeat_count = 1) and ((previous_byte and $C0) <> $C0)
              then
                PutByte(previous_byte)
              else
                begin
                  PutByte(repeat_count or $C0) ;
                  PutByte(previous_byte) ;
                end ;
          end ;
      repeat_count := 0 ;

    end ;

  procedure Add_byte(b : byte) ;

    begin

      if b = previous_byte
        then
          begin
            if (repeat_count = 63)
              then
                dump_repeat ;
          end
        else
          dump_repeat ;
      previous_byte := b ;
      inc(repeat_count) ;

    end ; { add_byte }

  procedure GetRGB ;

    { return from current quadruple rgb values
      and fill in R,G,B arrays or display on screen }

    var

      r,g,b : integer ;
      y : array[1..4] of integer ;
      k, j,
      bc  : integer ;
      bk, bj     : boolean ;

    procedure limit (var b : integer) ;

      begin

        if b < 0
          then
            b := 0
        else if b > 31
          then
            b := 31 ;

     end ;


    begin

      for bc := 1 to 4 do
        y[bc] := GetByte ;
      k  := (y[1] and 7) + ((y[2] and 3) shl 3) ;
      j  := (y[3] and 7) + ((y[4] and 3) shl 3) ;
      bk := ( (y[2] and 4) = 4 ) ;
      bj := ( (y[4] and 4) = 4 ) ;

      for bc := 1 to 4 do
        begin
          { make intensity range 0..31 }
          y[bc] := y[bc] shr 3 ;
          b := y[bc] + (y[bc] div 4) ;
          g := y[bc] ;
          r := y[bc] ;
          if bk
            then
              begin
                g := g - (k xor 31) ;
                b := b + ((k xor 31) shr 2) ;
              end
            else
              begin
                g := g + k ;
                b := b - (k shr 2 )
              end ;

           if bj
             then
               begin
                 r := r  - (j xor 31) ;
                 b := b + ((j xor 31) shr 1)
               end
             else
               begin
                 r := r + j ;
                 b := b - (j shr 1)
               end ;
          limit(r) ;
          limit(g) ;
          limit(b) ;
          { now we have rgb 0..31 }
          if view
            then
              { translate to color number 0..63 in greyscale palette }
               MEM[$A000:(word(line_count - 1) * 320 +
                         (row_count* 4 - 5 + bc))]  :=
                         round(0.58 * r + 1.2 * g  + 0.22 * b)
            else
              { add to RGB array }
              begin
                R_plane[row_count* 4 - (4-bc)] := round(r * 255 / 31 ) ;
                G_plane[row_count* 4 - (4-bc)] := round(g * 255 / 31 ) ;
                B_plane[row_count* 4 - (4-bc)] := round(b * 255 / 31 ) ;
              end ;
        end ;

    end ; { GetRGB }


  begin

    OpenFiles ;
    Get_screensize ;
    dc := 0 ;
    if not view
      then
        begin
          Init_PCX ;
          write('...........',chr(13)) ;
        end ;

    if view
      then
        end_line := 200
      else
        end_line := 212 ;
    for line_count := 1 to end_line do
      begin
        inc(dc) ;
        if dc > 20
          then
            begin
              if not view
                then write('x') ;
              if keypressed
                then
                  begin
                    ch := ReadKey;
                    if ch = #0
                      then
                        ch := ReadKey
                      else if ch = chr(27)
                        then
                          begin
                            if view
                              then
                              CloseGraph ;
                            write(chr(13),'Interrupted         ') ;
                            writeln ;
                            halt(1) ;
                          end
                  end ;
              dc := 0
            end ;
        for row_count := 1 to 64 do
          GetRGB ;
        if not view
          then
            begin
              { dump RGB arrays }
              for count := 1 to 256 do
                Add_byte(R_plane[count]) ;
              Dump_repeat ;
              for count := 1 to 256 do
                Add_byte(G_plane[count]) ;
              Dump_repeat ;
              for count := 1 to 256 do
                Add_byte(B_plane[count]) ;
              Dump_repeat ;
            end ;
      end ;

    if view
      then
        wait
      else
        writeln(chr(13),'Geconverteerd') ;
    CloseFiles ;

  end ;  { ConvertPicture }


begin { main MSX12CNV }

  writeln('MSX12CNV V1.0 (c) Hans Otten 1991') ;
  writeln(' (type MSX12CNV HELP for more info)') ;
  CheckParameters ;
  ConvertPicture ;

end.