(* Dit is het begin van het bestand GRAPTST2.PAS. Dit bestand is het
   vervolg op het bestand GRAPTST1.PAS. *)

Overlay procedure Random_lijnen;
{ Tekent random lijnen, als snelheids-demonstratie (zie hiervoor ook
  keuze 13: 'wat leuke vector-graphics', vooral het een-na-laatste
  staaltje!!) }

var i:integer;

Begin
  ScrMode(5); Color(15,0,0);
  Gwrite(100,204,'Random lijnen  256x212');
  For i:=1 to 1000 do
    DrawTo (random(256),random(203), random(256));
  Gwrite(86,204,'En dat waren 1000 lijnen!'); {Jaja, het ging inderdaad snel!}
  killbuffer; toets;
  Gwrite(86,204,'Random kleuren herdefinieren');
  { Voor de liefhebbers nog wat flits-werk... da's nooit weg, nietwaar? }
  For i:=1 to 100 do RandomRedefine;
  DefColor(15,7,7,7); { anders wordt 'Toets>' niet of slecht zichtbaar }
  killbuffer; toets
End;


Overlay procedure GetPut;
{ Tekent een prachtig patroon door middel van GetPic en PutPic, en de
  XOR-logische operatie. Als u deze demo even laat lopen, zal het beeld
  straks ook weer helemaal leeg zijn, waarna het programma overnieuw
  zal beginnen... }

Var plaatje:array[1..225] of byte;
    x,y, dx,dy:integer;

Begin
  ScrMode(5); Color(0,0,0); ClrScr; Logical(0);
  Circle (10,10, 10,4); FillShape (10,10, 8,4);
  GetPic (0,0, 20,20, plaatje); { sla de cirkel op in de variabele PLAATJE }
  x:=0; y:=0; dx:=2; dy:=2;
  While not keyPressed do
   Begin
    Logical(3); PutPic(plaatje, x,y+20);
    x:=x+dx; y:=y+dy;
    If x>234-dx then dx:=-dx;
    If y>192-dy then dy:=-dy;
    If x<-dx then dx:=-dx;
    If y<-dy then dy:=-dy;
    WaitForInt; { voor vloeiendere en langzamere beweging (Pascal is
                  nu eenmaal soms TE snel...) }
   End;
  Toets; TextMode
End;


Overlay procedure KleurKarakter;
{ dit is een prachtig kunstje: het laat de letters in ScrMode(2) GLANZEN!
  Een typisch MSX-2 grapje... }

type TabelType  = array[1..8] of byte;
const TabelConst: TabelType = (3,4,5,6,7,6,5,4);
var i,j         : integer;
    a           : byte;
    kleurtabel  : TabelType;
    c           : char;

Begin
  { stel het scherm in }
  Color(15,0,0);
  { copieer gedeelte v/d set in VRAM (niet alles is nodig): }
  InitCharMode(30, 32,126);
  { maak de karakters vet }
  For i:=264 to 1016 do { alleen ASCII-set van nr. 32 t/m 127 }
    Begin
      a:=ReadVram(i);        { lees beeldlijn }
      a:=a or (a shr 1);     { 'vervet' hem! }
      WriteVram(i     , a);  { in 1e set schrijven }
      WriteVram(i+2048, a);  { in 2e set }
      WriteVram(i+4096, a)   { en in de 3e set! }
    End;
  i:=$2000+264; { kleurtabel, begin bij karakter 33 (8*33=264) }
  While i<$2000+1016 do { eindig bij karakter 127 }
  Begin
    For j:=0 to 7 do
    Begin
      { schrijf in 1e, 2e, 3e kleurenset }
      WriteVram(i+j,16*(j+1)); WriteVram(i+2048+j,16*(j+1));
      WriteVram(i+4096+j,16*(j+1));
    End;
    i:=i+8
  End;
  WriteLn('Deze karakters zijn nogal');
  WriteLn('kleurig, en ze VERANDEREN');
  WriteLn('ook voortdurend van kleur.'); WriteLn; WriteLn;
  WriteLn('Dit komt, doordat er op de-');
  WriteLn('ze MSX-2 steeds kleuren GE-');
  WriteLn('HERDEFINIEERD worden, die');
  WriteLn('van te voren in het Video RAM');
  WriteLn('(kleurtabel) gezet worden.'); WriteLn; WriteLn;
  WriteLn('Druk op een toets');
  { initialiseer de kleur-tabel }
  kleurtabel:=TabelConst;
  KillBuffer;
  { glanzen tot er een toets is ingedrukt }
  While not keyPressed do
    Begin
      { herdefinieer de kleuren opnieuw }
      For i:=1 to 8 do DefColor(i,kleurtabel[i],kleurtabel[i],0);
      { schuif de kleurtabel eentje naar onder, hetgeen het glans-
        effect veroorzaakt }
      a:=kleurtabel[8];
      For i:=7 downto 1 do kleurtabel[i+1]:=kleurtabel[i];
      kleurtabel[1]:=a;
      { beetje vertraging, want Pascal is nu eenmaal snel... }
      For i:=1 to 5 do WaitForInt;
    End;
  Read(kbd,c); { haal gedrukte toets uit buffer (KeyPressed doet dit niet) }
  ScrMode(0)
End;


Overlay procedure zuilen;
{ Een prachtig effect van de oude Griekse zuilen, zoals je die in de tempels
  tegenkomt. Alleen zijn deze een stuk gaver... }

var i,j : integer;
begin
  color(15,1,1); scrmode(7);
  for i := 2 to 7 do
    DefColor(i,i,i,trunc(i/1.1)); { geeft een wat gelig effect }
  for i := 2 to 7 do
    begin
      j:=0;
      while j<=448 do
        begin
          fillbox(4*i+j,0, 4*i+j+3,211, i);
          fillbox(4*(14-i)+j,0, 4*(14-i)+j+3,211, i);
          j:=j+56
        end;
    end;
  toets;
end;


Overlay procedure Vectortjes;
{ Dit zijn een heleboel prachtige lijn-tekeningen (vector-graphics) achter
  elkaar. Let vooral op de een-na-laatste!! (Met dat soort dingen prijzen veel
  fabrikanten hun computers aan...) }

Var i,j,x1,y1,x2,y2:integer;

{ Meerdere soorten graphics in meerdere sub-procedures }
  Procedure Kleedje_haken;

  Const k = 15;

  Var i,j,lus,kleur : integer;
      a : array[0..k,0..1] of integer;

  Begin
    ScrMode(7); Logical(0);
    For i:=0 to k do
      Begin
        a[i,0] := round(cos(i/k*6.28)*255+255);
        a[i,1] := round(sin(i/k*6.28)*90+90)
      End; KillBuffer;
    For lus:=1 to 10 do
      Begin
        ClrScr; kleur:=random(14)+2;
        For i:=0 to k-1 do
          For j:=i+1 to k do
            Draw(a[i,0],a[i,1], a[j,0],a[j,1], kleur);
        For i:=0 to k do
          a[i,0]:=round(a[i,0]*0.875)+32;
        For i:=0 to 10 do WaitForInt; { anders gaat het wel erg snel... }
      End; { for lus }
  end;

  Procedure Lijnenspel;
  Var x,y,a,b : integer;
  Begin
    ScrMode(5);
    X:=random(255); Y:=random(211);
    a:=x;
    while a>8 do
      begin
        b:=trunc(a/x*(y-106)+106);
        draw(0,0,a,b,5); drawto(0,211,5); a:=a-8;
      end;
    a:=x;
    while a<255 do
      begin
        b:=106+(y-106)*(256-a) div (256-x);
        draw(255,0,a,b,13); DrawTo(255,211,13); a:=a+8;
      end;
    a:=y;
    while a>0 do
      begin
        b:=trunc(a/y*(x-128)+128);
        draw(0,0,b,a,2); DrawTo(255,0,2); a:=a-8;
      end;
    a:=y;
    while a<211 do
      begin
        b:=128+(x-128)*(211-a) div (211-y);
        draw(0,211,b,a,8); DrawTo(512,211,8); a:=a+8
      end;
    Box(0,0,255,211,15);
  end;

  Procedure lijn2 (x1,y1,x2,y2,kleur:integer);
  Var i:integer;
  Begin
    i:=x1;
    while i<x2 do
      begin
        draw (x1,y1, i,y2, kleur);
        draw (x1,y2, i,y1, kleur);
        draw (x2,y1, (x1+x2)-i,y2, kleur);
        draw (x2,y2, (x1+x2)-i,y1, kleur);
        i:=i+12
      end;
  end;

  Procedure web (x1,y1,x2,y2,kleur:integer);
  Var i,j,stap:integer;
  Begin
    stap:=(x2-x1) div 7;
    i:=x1;
    while i<x2 do
      begin
        j:=x1;
        while j<x2 do
          begin
            draw(i,y1,j,y2,kleur);
            j:=j+stap
          end;
        i:=i+stap
      end;
  end;

  Procedure Kubus_Zadel;
  { tekent kubus met zadelvlak en laat hem draaien!!
    dit is die 'een na laatste' waarvan u al gelezen
    zult hebben aan het begin van dit programma...
    Vertaald van Basic naar Pascal uit het boek
    '40 grafische programma's in MSX basic' van Aca-
    demic service. Draaiing toegevoegd door MDL-SOFT. }
  Const dataX : array[1..8] of integer = (-60, 60, 60,-60,-60, 60, 60,-60);
        dataY : array[1..8] of integer = (-60,-60, 60, 60,-60,-60, 60, 60);
        dataZ : array[1..8] of integer = (-60,-60,-60,-60, 60, 60, 60, 60);
        zstr  = 'ABBCCDDAAEBFCGDHEFFGGHHE';
        k     = 0.5;
        n     = 15;
        u     = 128;
        v     = 106;
  Var   rd    : real;
        w,c,s : real;
        l,a,m : integer;
        x,y   : array[0..8] of integer;
        pag   : byte;

  Begin
    color(15,1,1); scrmode(6);
    rd:=pi/180; pag:=1; setpage(0,1); clrscr; setpage(1,0);
    a:=0; killbuffer;
    while not keypressed do { laat de kubus draaien }
      begin
        w:=a*rd; c:=k*cos(w); s:=k*sin(w);
        For j:=1 to 8 do
          begin
            x[j] := 2*round(u+dataX[j]+c*dataY[j]);
            y[j] := round(v-s*dataY[j]-dataZ[j]);
          end;
        l := length(zstr);
        m:=1; while m<l do
          begin
            i := ord(copy(zstr,m,1))-64;
            j := ord(copy(zstr,m+1,1))-64;
            draw (x[i],y[i], x[j],y[j], 3);
            m:=m+2
          end;
        For j:=0 to n do
          begin
            x1 := x[2]+j*(x[7]-x[2]) div n;
            y1 := y[2]+j*(y[7]-y[2]) div n;
            x2 := x[5]+j*(x[4]-x[5]) div n;
            y2 := y[5]+j*(y[4]-y[5]) div n;
            draw (x1,y1, x2,y2, 3);
          end;
        draw (x[2],y[2], x[7],y[7], 3);
        draw (x[5],y[5], x[4],y[4], 3);
        { wissel pagina's }
        pag := pag xor 1;
        setpage (pag,pag xor 1); clrscr;
        a:=a+10; if a>350 then a:=0;
      end; { while not keypressed }
    Toets
  end;

  Procedure nog_een_lijnenspel;
  { Deze tekent random lijnen met de SINUS-functie.
    Het programma is zo snel, doordat een sinus-tabel wordt gecreeerd.
    Vertaald van Basic naar Pascal uit MSX-INFO nr. 1-1986
  }
  Var   x, n,o,p,q,r,s,t,u : integer;
        a : real;
        tabel : array[0..80] of byte;
        stop : boolean;
  Begin
    stop:=false;
    scrmode(6); a:=0; x:=0;
    gotoxy(32,12); write('momentje...');
    while a<=6.283 do { maak sinustabel }
      begin
        tabel[x] := trunc(sin(a)*96+96.5);
        x:=x+1; a:=a+(6.283/80)
      end;
    killbuffer;
    while not stop do
      begin
        clrscr;
        n:=random(3)+1; o:=random(3)+1; p:=random(3)+1; q:=random(3)+1;
        for x:=1 to 80 do
          begin
            r:=r+n; if r>80 then r:=r-80;
            s:=s+o; if s>80 then s:=s-80;
            t:=t+p; if t>80 then t:=t-80;
            u:=u+q; if u>80 then u:=u-80;
            draw (2*tabel[r]+80,tabel[s], 2*tabel[t]+80, tabel[u], 3)
          end;
        gotoxy(1,25); write('Toets voor menu');
        for x:=1 to 100 do
          begin
            waitforint;
            if keypressed then begin toets; stop:=true end
          end { for }
      end { while }
  end; { nog_een_lijnenspel }


Begin { hoofdprocedure Vectortjes }
  Color(15,1,1);
  Kleedje_haken; Toets;
  While not keypressed do
    Begin
      Lijnenspel;
      For j:=1 to 30 do WaitForInt
    end;
  Toets; scrmode(7);
  lijn2(0,0,511,211,15); toets;
  clrscr;
  gwrite(350,200,'Druk op een toets!');
  while not keyPressed do
    begin
      x1:=random(256); y1:=random(106);
      x2:=x1+random(256)+10; y2:=y1+random(106)+10;
      fillbox(x1-2,y1-1,x2+2,y2+1,1);
      if random(100)>50 then
         lijn2(x1,y1,x2,y2,random(14)+2)       { teken een lijnenspel }
      else
         web  (x1,y1,x2,y2,random(14)+2);      { of een web! }
      box(x1,y1,x2,y2,15);
      if (x2>348) and (y2>198) then gwrite(350,200,'Druk op een toets!');
        { herstel eventueel tekst, als 'overtekend' }
    end; Toets;
  Kubus_Zadel;
  Nog_een_lijnenspel;
  TextMode; Color(15,1,1)
End; { vectortjes }



(************************************************************)
(****   BEGIN VAN DE HOOFDPROCEDURE VAN GRAPHIC_TEST_2   ****)
(************************************************************)

Begin
  If MSXversion=1 then
    begin
      TextMode;
      WriteLn(#7,'Tja! Hiervoor zult u toch echt een');
      WriteLn('MSX-2 moeten kopen...');
      WriteLn;
      Write('RETURN>'); ReadLn; Exit
    end;
  Randomize; sys_width0:=80; ScrMode(0);
  Stop:=false;
  assign (lst,'PRN');
  { Op MSX computers kan men vanwege een bug zonder dit statement niet
    printen. }

  {*** MENU ***}
  While not stop do   { zolang keuze STOPPEN niet gegeven is }
  Begin
    TextMode; Color(15,1,1);
    WriteLn (^I,  { =Tab }
    'GRAFISCHE TEST Voor alle MSX-2 computers   (C) 1988 MDL-Soft');
    For i:=1 to 80 do Write('-');
    Gotoxy (18, 6); Write ('1. DRIEHOEKEN IN PERSPECTIEF');
    Gotoxy (18, 7); Write ('2. RANDOM SINUSOIDE-FIGUREN');
    Gotoxy (18, 8); Write ('3. RANDOM RUITEN MET 255 KLEUREN');
    Gotoxy (18, 9); Write ('4. TEST MET DE XOR-LOGISCHE OPERATIE');
    Gotoxy (18,10); Write ('5. TEST MET DE MUIS OF JOYSTICK (poort 1)');
    Gotoxy (18,11); Write ('6. TURTLE-GRAFIEK (Logo-routines)');
    Gotoxy (18,12); Write ('7. VIERKANTSPIRAAL (ook Logo)');
    Gotoxy (18,13); Write ('8. STAAF-DIAGRAM');
    Gotoxy (18,14); Write ('9. RANDOM LIJNEN (snelheids-demonstratie...)');
    Gotoxy (17,15); Write ('10. TEST MET GETPIC EN PUTPIC');
    Gotoxy (17,16); Write ('11. "GLANZENDE" KARAKTERS');
    Gotoxy (17,17); Write ('12. EFFECT VAN OUDE GRIEKSE ZUILEN');
    Gotoxy (17,18); Write ('13. WAT LEUKE VECTORGRAPHICS');
    Gotoxy (17,19); Write ('14. STOP HET PROGRAMMA');
    Gotoxy (21,23); Write ('Maak a.u.b. uw keuze: ');
    {$I-} i:=1;
    While i<>0 do  { geen of foute keuze? }
    Begin
      Gotoxy(42,23); ClrEol; Read(keuze);  { <0 of >255: I/O error }
      i:=IoResult;
      If (i=0) and ((keuze<1) or (keuze>14)) then i:=1
    End; {$I+}
    (*** MAAK EEN KEUZE ***)
    Logical(0);  { Alle onderdelen starten zonder logische operatie }
    Case keuze of
      1:  Perspec_Driehoeken;
      2:  RandomTek;
      3:  Ruiten;
      4:  XorTest;
      5:  Mouse_test;
      6:  TurtleGrafiek;
      7:  VierkantSpiraal;
      8:  Staafdiagram;
      9:  Random_lijnen;
     10:  GetPut;
     11:  KleurKarakter;
     12:  Zuilen;
     13:  Vectortjes;
     14:  stop:=true
    end;  { CASE }
  end;  { WHILE }
end; { Graphic_Test_2 }
