PROGRAM STICKTST; {Joystick testprogramma, (C) 1996 Manuel Bilderbeek}

{$I JOYSTICK.INC}
{$I WRTVRAM.INC}
{$I FASTWRIT.INC}
{$I MSXBIOS.LIB}

CONST Stickstatus:ARRAY[0..8] of String[10]=('Center    ','Up        ',
                         'Right up  ','Right     ','Right down','Down      ',
                                    'Left down  ','Left      ','Left up   ');
      Strigstatus:ARRAY[0..1] of String[11]=('Not pressed','Pressed    ');
      Trigger:ARRAY[0..2] of String[9]=('Spacebar','Trigger 1','Trigger 2');

VAR Key:char;
    S1,S2:String[11];
    Oldwidth,Ypos,N:Byte;

PROCEDURE HorLine(X1,X2,Y:integer);
VAR I:integer;

BEGIN
     GotoXY(X1,Y);
     FOR I:=0 TO (X2-X1) DO FastWrite('-');
END;


BEGIN
     MsxBios($0041);
     Write(#27,'x5');
     OldWidth:=Mem[$F3B0];
     Mem[$F3B0]:=40;                                {40 column screen}
     MsxBios($0078);                                    {SETTXT}
     ClrScr;
     GotoXY(3,1);FastWriteLn('Joystick Test, by Allosoft 08-12-1996');
     HorLine(3,39,2);
     HorLine(1,40,3);
     GotoXY(1,4);FastWriteLn('Cursorkeys');
     GotoXY(14,4);FastWriteLn(Trigger[0]);
     HorLine(1,40,7);
     HorLine(1,40,9);
     GotoXY(1,10);FastWriteLn('Joystick A');
     GotoXY(14,10);FastWriteLn(Trigger[1]);
     GotoXY(29,10);FastWriteLn(Trigger[2]);
     HorLine(1,40,13);
     HorLine(1,40,15);
     GotoXY(1,16);FastWriteLn('Joystick B');
     GotoXY(14,16);FastWriteLn(Trigger[1]);
     GotoXY(29,16);FastWriteLn(Trigger[2]);
     HorLine(1,40,19);
     HorLine(10,29,21);
     GotoXY(10,22);FastWriteLn('(Hold [ESC] to exit)');
     HorLine(10,29,23);
     MsxBios($0044);
     Key:=#00;
     Repeat
           IF Keypressed THEN Read(KBD,Key);
           FOR N:=0 TO 2 DO
           BEGIN
                Ypos:=6*N+6;
                IF Strig(N)<>0 THEN S1:=Strigstatus[1] ELSE S1:=Strigstatus[0];
                IF Strig(N+2)<>0 THEN S2:=Strigstatus[1] ELSE S2:=Strigstatus[0];
                GotoXY(1,Ypos); FastWrite(Stickstatus[Stick(N)]);
                GotoXY(14,Ypos);FastWrite(S1);
                IF N<>0 THEN
                BEGIN
                     GotoXY(29,Ypos);
                     FastWrite(S2);
                END;
           END;
     UNTIL Key=#27;
     Mem[$F3B0]:=OldWidth;
     MsxBios($0078);
     ClrScr;
     HorLine(1,27,1);
     GotoXY(1,2);FastWriteLn('Thanks for using Sticktest!');
     FastWriteLn('(C) december 1996, Allosoft');
     HorLine(1,27,4);
END.
