{SET_VIDEO.inc by K.Lammassaari/ACADEMY 1997}
{Controls the superimposing and digitizing of the MSX2 }

{REM NO ERROR CHECKING, Incorect parameter values cause system crash, because
 code drops to the error routine of the BASIC interpreter.
 Define used parameter  values as constants. }

{Syntax:  SET_VIDEO(mode,Ym,CB,sync,voice,videoinput,AVcontrol)

         <mode> = Range is 0-3
                   Sets the superimposing mode.
                   0 => Display screen = Computer, VDP flags S1=0,S0=0,TP=0
                   1 => Display screen = Computer, VDP flags S1=0,S0=1,TP=1
                   2 => Display screen = Superimpose, VDP flags S1=0,S0=1,TP=0
                   3 => Display screen = Television, VDP flags S1=1,S0=0,TP=0
          <Ym>   = Range is 0-1
                   0 = Normal screen brightness
                   1 = The brightness of television is halved.
          <CB)   = Range is 0-1
                   0 = Colour Bus set to output.
                   1 = Colourbus set to input
          <sync> = Range is 0-1
                   0 = VDP internal sync
                   1 = External sync
          <voice>= Range is 0-3
                   0 = No voice mixing
                   1 = Right channel mixed
                   2 = Left channel mixed
                   3 = Both channels mixed

          <videoinput>
                   = Range is 0-1
                   0 = RGB multiconnecor is selected for video input
                   1 = external video signal connector is selected
          <AVcontrol>
                   = Range 0-1
                   0 = output to RGB connector is OFF
                   1 = output to RGB connector is ON
}

{Uses BASIC ROM routines. }
{Descrition :
  - The memory $f55d - $f5ad is saved to heap.
  - The code is moved to $f580 and patched to use MSXDOS ENASLT-routine, which
    operates from page 3 and allows to handle the page 0 .(BIOS ENASLT crashes
    if used to turn page 0.)
  - parameters are pathced to the BASIC line (the parameter part) at &f55d.
  - HL is set to point at $f560, the code is called and the memory is
    restored from stack.
 }

Procedure SET_VIDEO(mode,Ym,CB,sync,voice,videoinput,AVcontrol:Byte);
 Const Code :Array[0..40] Of Byte =
         ($f3,
          $3A,$C1,$FC,$F5,$21,$0,$0,$CD,$24,$0,$F1,$26,$40,$CD,$24,$0,
          $21,$5d,$F5,$CD,$1b,$7c,
          $3A,$41,$F3,$26,$0,$CD,$24,$0,$3A,$42,$F3,$26,$40,$CD,$24,$0,$FB,$c9
         );
        BasicLine :Array[0..20] Of Byte=( $56,$49,$44,$45,$4f,$20,
                                          $32,$2c,$11,$2c,$11,$2c,$11,
                                              $2c,$11,$2c,$11,$2c,$11,$00,$00
                                           );
  Var i  :Byte;
      c  :Array[0..40] of Byte Absolute $f580 ;
      b  :Array[0..20] Of Byte Absolute $f55d;
      store :^byte;
      EnasltAddr :Integer Absolute $0025;
      Patch      :Integer Absolute $f59d;
 Begin
   Inline($f3);
   Getmem(Store,90);
   Move(b,Store^,90);
   Move(code,c,41);
   Patch := EnaSltAddr;
   Move(BasicLine,b,21);
   b[6] := $30 + Mode;
   b[8] := $11 + Ym;
   b[10] := $11 + CB;
   b[12] := $11 + sync;
   b[14] := $11 + voice;
   b[16] := $11 + videoinput;
   b[18] := $11 + AVcontrol;
   Inline ($cd/$80/$f5  );
   Move(Store^,b,90);
   FreeMem(Store,90);
 End;


