PROGRAM  QuickSortDemo; {Sorteer een rij met "quick-sort"}
                        {Door Ayhan Cicek & Manuel Bilderbeek}
                        {MSX versie door Manuel Bilderbeek}

{$I WRTVRAM.INC}
{$I FASTWRIT.INC}

{$A-}

CONST AantalGetallen=480;
      MaxGetal=100;

TYPE RijType=ARRAY[1..AantalGetallen] OF integer;

VAR  Op,Temp:integer;

PROCEDURE MaakRandomGetallen(VAR Rij:RijType);
VAR I:integer;
BEGIN
     Randomize;
     FOR I:=1 TO AantalGetallen DO Rij[I]:=RANDOM(MaxGetal);
END;

PROCEDURE PrintRij(Rij:RijType);
VAR I:integer;

BEGIN
     FOR I:=1 TO AantalGetallen DO Write(Rij[I],' ');
     WriteLn;
END;

PROCEDURE QuickSort(EersteEl,LaatsteEl:integer;VAR Rij:RijType);
VAR Neer:integer;
BEGIN
     FastWrite('*');                                     {optioneel}
     Op:=EersteEl;
     Neer:=LaatsteEl;
     REPEAT
          WHILE (Op<LaatsteEl) AND (Rij[Op]<Rij[EersteEl]) DO Op:=SUCC(Op);
          WHILE (Neer>EersteEl) AND (Rij[Neer]>=Rij[EersteEl]) DO Neer:=PRED(Neer);
          IF Op<Neer THEN
          BEGIN
               Temp := Rij[Op];
               Rij[Op] := Rij[Neer];
               Rij[Neer] := Temp;
          END;
     UNTIL Op>=Neer;
     IF EersteEl<LaatsteEl THEN
     BEGIN
          QuickSort(EersteEl,Neer-1,Rij);
          QuickSort(Neer+1,LaatsteEl,Rij);
     END;
END;

VAR Rij:RijType;
    I:integer;

BEGIN
     ClrScr;
     GotoXY(1,1);
     FastWriteLn('QuickSort demonstration, made on 23-11-1996 by Manuel Bilderbeek (Allosoft)');
     WriteLn;
     Write('Generating ',AantalGetallen,' random numbers between 0 and ',MaxGetal-1,'...');
     MaakRandomGetallen(Rij);
     WriteLn;
     FastWriteLn('Sorting them now... (using the quicksort algorthm)');
     GotoXY(1,7);
     FOR I:=1 TO 2*AantalGetallen-1 DO FastWrite('-');     {optioneel}
     GotoXY(1,7);
     QuickSort(1,AantalGetallen,Rij);
     WriteLn;
     WriteLn;
     FastWriteLn('Ready! Here is the sorted row:');
     WriteLn;
     PrintRij(Rij);
     WriteLn;
     FastWriteLn('Press [Enter] to quit...');
     ReadLn;
END.
