{ pie.inc by Kari Lammassaari 1997}
{Draws a pie diagram }
{Syntax:
 rocedure Pie(x,y,radius:Integer;StartAngle,EndAngle:Real;Color:Byte);
}

{Uses rom routines }
{Description:
 - The memory area at $f580 - $f580 + 43 is saved to heap.
 - The code, which calls BASIC ROM routine at $5bb2, is copied to $f580;
 - The required parameters are calculated and transferred to SYSTEM RAM 
   variables (GXPOS,GYPOS etc.).
 - The calling code is patched to use MSX DOS ENASLT routine at high memory. 
   (MSX BIOS ENASLT crashes, if page 0 is turned off.)
 - ROM routine ends with harmful code POP HL, RET , which is cured by pushing 
   the right return address ($f599) twice onto stack and using JP instead of 
   CALL instruction.
 - The CTRL-STOP is disabled by  setting $fbb1 non zero. (The routine is faster
   and does not drop to MSX BASIC (= crash), if CTRL-STOP is pressed.
 - The routine is called, the memory at $f580 restored from heap and allocated
   heap memory fre'ed. 
}

Procedure Pie(x,y,radius:Integer;StartAngle,EndAngle:Real;Color:Byte);

Const SinPi4 = 0.70710678119;
      Pi4    = 0.78539816340;
      Code :Array[0..42] Of Byte =
         ($f3,$3A,$C1,$FC,$F5,$21,$0,$0,$CD,$24,$0,$F1,$26,$40,$CD,$24,
          $0,$21,$99,$f5,$e5,$e5,$C3,$b2,$5b,
          $3A,$41,$F3,$26,$0,$CD,$24,$0,$3A,$42,$F3,$26,$40,$CD,$24,$0,$FB,$c9
         );
  Var i  :Byte;
      c  :Array[0..42] of Byte Absolute $f580 ;
      store :^byte;
      EnasltAddr :Integer Absolute $0025;
      Patch      :Integer Absolute $f59f;

    GXPOS :Integer Absolute $fcb3;
    GYPOS :Integer Absolute $fcb5;
    GRPACX:Integer Absolute $fcb7;
    GRPACY:Integer Absolute $fcb9;
    CNPNTS:Integer Absolute $f936;
    ATRBYT:Integer Absolute $f3f2;
    CSTCNT:Integer Absolute $f93F;
    CENCNT:Integer Absolute $f933;
    ASPECT:Integer Absolute $f931;
    ASPCT2:Integer Absolute $f40d; {Default aspect ratio}
    CPLOTF:Byte    Absolute $f938;
    CLINEF:Byte    Absolute $f935;
    CSCLXY:Byte    Absolute $f941;
    CRCSUM:Integer Absolute $f93d;

 Begin
   Inline($f3);
   Getmem(Store,43);
   Move(c,Store^,43);
   Move(code,c,43);
   Patch := EnaSltAddr;

   GXPOS :=Radius; GRPACX :=x;
   GYPOS :=0; GRPACY :=y;
   CNPNTS := Trunc(SINPI4 * radius);
   CRCSUM := 0;
   If StartAngle > EndAngle Then
    Begin
      CPLOTF := 1;
      CSTCNT := Trunc(CNPNTS * (EndAngle/PI4));
      CENCNT := Trunc(CNPNTS * (StartAngle/PI4));
    End
   Else
    Begin
      CPLOTF := 0;
      CSTCNT := Trunc(CNPNTS * (StartAngle/PI4));
      CENCNT := Trunc(CNPNTS * (EndAngle/PI4));
    End;
   ASPECT := ASPCT2;
   CLINEF:=129 ;CSCLXY :=0;

   ATRBYT := color;
   Mem[$fbb1] := 255;
   Inline( $cd /$80/$f5/$fb);
   Mem[$fbb1] := 0;
   Move(Store^,c,43);
   FreeMem(Store,43);
End;

