
{MusicMo1.inc by Kari Lammassaari 1996 contains following
 independent and standalone procedures and functions:

 (REMOVE Procedures/Functions You don't need or make them separate inc-files.)

- Procedure WriteAudioRegister(Register,Value:Byte);
  (Stands alone !)

- Function ReadAudioRegister(Register:Byte):Byte;
  (Stands alone !)

- Function MusicModuleExists:Boolean;
  (Needs Write/ReadAudioRegister)

- Procedure WriteAudioRam(StartAddr,SourceAddr,Bytecount:Integer);
  (Stands alone !)

- Procedure ReadAudioRam(StartAddr,DestinationAddr,Bytecount:Integer);
  (Stands alone !)
  (REM StartAddr refers to 4 byte groups, NOT sequential bytes in AUDIO RAM.
   Ie. You can set starting point of write/read in audio ram in 4 byte steps,
   ie. StartAddr = refers byte 0 in audio ram, AudioArrd=1 refers byte 4 ...
   Writing/reading occurs ,of course, to every byte.
   SourceAddr and DestinationAddr refer to data areas in conventional RAM.)

- Function AudioRamSize:Integer;
   (Needs Write/ReadAudioRam.)
   (Returns Audioramsize in Kb 32/265. )

- Procedure Sample(StartAddr,SampleLenght,SampleFrequency:Integer;
                   SwitchOnValue:Byte); (ADPCM)
  (Stands alone !)
  (SwithcOnValue 0..127 = the loudness, which turns sampling on.   
   Test the loudness with PcmSample to find out the right value.)

- Procedure PlaySample(StartAddr,SampleLenght,SampleFrequency:Integer;
                       Volume:Byte);    (ADPCM)
  (Stands alone !)

- Procedure RepeatSample(StartAddr,SampleLenght,SampleFrequency:Integer;
                         Volume:Byte);   (ADPCM)
  (Stands alone !)
  ( REM Max. SampleFrequency is 16000 Hz, Volume = 0..255.
    StartAddr and SampleLenght refer 4-byte groups in AUDIO RAM.)

- Procedure StopSamplePlay;              (ADPCM)
  (Stands alone !)

- Procedure SaveSample(FileName:StringType;AudioAddress:Integer;Bytecount:Real);
  ( Needs MsxDos2.inc )
  ( REM Special value ,ByteCount = 0, means that all the AUDIO RAM
    will be saved. )

- Procedure LoadSample(FileName:StringType;AudioAddress:Integer;Bytecount:Real);
  ( Needs MsxDos2.inc )
  ( REM Special value , ByteCount = 0, means that all the file will be loaded. )
  ( Accessing audio ram during playback stops playback ! )

- Procedure PcmSample(DestinationAddr,SampleLenght,SampleFrequency:Integer;
                      ValueToAdd:Byte);    (PCM)
  (Stands alone !)
  (Samples PCM-data via MSX Audio register $1a directly to DestinationAddr
   in conventional RAM.  Data is in the form of 2's complement.
   SampleLenght = count of sampled bytes.
   ValueToAdd, if not zero, this value is added to sampled data to produce 
   easily required graphic coordinate. If zero adding is ignored )

- Procedure PcmSwitch(SwitchVolume:Byte); (Values 0..127)
  (Stands alone !)                         (PCM)
  (Waits sound loudnes to reach given SwitchVolume level and returns
   doing nothing else.
   Used to switch the PcmSample on.
   )

- Procedure PcmPlay(SourceAddr,SampleLength,SampleFrequency:Integer;
                    Volume:Byte); (REM Volume 0..7) (PCM)
  (Stands alone !)
  (Plays back PCM data from conventional memory.)
  (Occupies totally Z80 !);

- Variable SizeOfAudioRam:Real ;
}

Var SizeOfAudioRam :Real;

Procedure WriteAudioRegister(Register,Value:Byte);

Const RegisterPort = $c0;
      DataPort     = $c1;

 Begin
   Port[RegisterPort]  := Register;
   Port[DataPort] := Value;
 End;

Function ReadAudioRegister(Register:Byte):Byte;

Const RegisterPort = $c0;
      DataPort     = $c1;
 Begin
   Port[RegisterPort]  := Register;
   ReadAudioRegister := Port[DataPort];
 End; 

Function MusicModuleExists:Boolean;

  Begin
     WriteAudioRegister(7,0);
     WriteAudioRegister(7,1);

     WriteAudioRegister($0f,$4b);
     If ReadAudioRegister($0f) = $4b Then MusicModuleExists := True
      Else MusicModuleExists := False;
  End;

Procedure WriteAudioRam(AudioAddr,SourceAddr,Bytecount:Integer);
  Var EndAddr   :Integer;
  Begin
       EndAddr := $FFFF; {AudioAddr+Bytecount;}
       Inline(
        {Write audio ram }
        $F3/$3E/$04/$D3/$C0/$3E/$00/$D3/$C1/$3E/$04/$D3/$C0/

        $3E/$80/$D3/$C1/$3E/$07/$D3/$C0/$3E/$01/$D3/$C1/$3E/$08/$D3/$C0/

        $3E/$00/$D3/$C1/
        $3E/$09/$D3/$C0/$3a/AudioAddr /$D3/$C1/
        $3E/$0A/$D3/$C0/$3a/AudioAddr+1/$D3/$C1/
        $3E/$0B/$D3/$C0/$3a/EndAddr    /$D3/$C1/
        $3E/$0C/$D3/$C0/$3a/EndAddr+1  /$D3/$C1/
        $3E/$10/$D3/$C0/$3E/$F0/$D3/$C1/$3E/$07/$D3/$C0/

        $3E/$60/$D3/$C1/$3E/$04/$D3/$C0/$3E/$60/$D3/$C1/
        $ed/$4b/Bytecount/$2a/SourceAddr/
        $3E/$0F/$D3/$C0/$7E/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$23/$0B/

        $78/$B1/$28/$0A/$DB/$C0/$CB/$7F/$28/$FA/$CB/$67/$28/$E1/$00/$00/

        $3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/

        $3E/$07/$D3/$C0/$3E/$01/$D3/$C1/
        $fb
             );
   End;      {WriteAudioRam}

Procedure ReadAudioRam(AudioAddr,DestinationAddr,Bytecount:Integer);
  Var EndAddr :Integer;
  Begin
       EndAddr := $ffff; {AudioAddr+Bytecount; 	}
       Inline (
        {Read audio ram }
        $F3/$3E/$04/$D3/$C0/$3E/$00/$D3/$C1/
        $3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/
        $3E/$08/$D3/$C0/$3E/$00/$D3/$C1/
        $3E/$09/$D3/$C0/$3a/AudioAddr   /$D3/$C1/
        $3E/$0A/$D3/$C0/$3a/AudioAddr+1 /$D3/$C1/
        $3E/$0B/$D3/$C0/$3a/EndAddr     /$D3/$C1/
        $3E/$0C/$D3/$C0/$3a/EndAddr+1   /$D3/$C1/
        $2a/DestinationAddr/
        $ed/$4b/ByteCount/
        $3E/$0F/$D3/$C0/$18/$00/$DB/$C1/$DB/$C0/$CB/$5F/$28/$FA/$3E/

        $04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$0F/$D3/$C0/$18/$00/$DB/$C1/$DB/

        $C0/$CB/$5F/$28/$FA/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$0F/$D3/

        $C0/$18/$00/$DB/$C1/$77/$23/$0B/$78/$B1/$28/$14/$DB/$C0/$CB/$5F/

        $28/$FA/$CB/$67/$20/$0A/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$18/$DD/

        $3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/
        $3E/$07/$D3/$C0/$3E/$01/$D3/$C1/
        $fb
               );
   End;       {ReadAudioRam}


Function AudioRamSize:Integer;

 Var TestValue  :String[4];
     OrigValue  :String[4];
     a,b        :Real;
 Begin
   a := 256; b:=1024;
   OrigValue :='KL96';TestValue := 'kl96';
   WriteAudioRam($f000,Addr(OrigValue),5);
   ReadAudioRam($f000,Addr(TestValue),5);
   If TestValue = OrigValue Then
     Begin
       AudioRamSize := 256;
       SizeOfAudioRam := a * b;
     End
    Else
     Begin
      AudioRamSize := 32 ;
      a := 32;
      SizeOfAudioRam := a * b;
     End;
 End;   {AudioRamSize}

Procedure Sample(StartAddr,SampleLenght,SampleFrequency:Integer); {ADPCM}

   Var SampleRate :Integer;
       EndAddr	  :Integer;
       Temp      :Integer;
   Begin
       Temp :=Trunc(SampleFrequency/ 1000 );
       SampleRate := Trunc(3600/Temp);
       EndAddr := StartAddr + SampleLenght ;
       Inline (
        {Sample sound}
        $F3/$3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$00/$D3/

        $C1/$3E/$04/$D3/$C0/$3E/$08/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/

        $C1/$3E/$07/$D3/$C0/$3E/$01/$D3/$C1/$3E/$07/$D3/$C0/$3E/$68/$D3/

        $C1/$3E/$08/$D3/$C0/$3E/$00/$D3/$C1/$3E/$09/$D3/$C0/$3a/StartAddr/$D3/

        $C1/$3E/$0A/$D3/$C0/$3a/StartAddr+1/$D3/$C1/
        $3E/$0B/$D3/$C0/$3a/EndAddr/$D3/$C1/

        $3E/$0C/$D3/$C0/$3a/EndAddr+1/$D3/$C1/$3E/$0D/$D3/$C0/$3a/SampleRate/
        $D3/$C1/$3E/$0E/$D3/$C0/$3a/SampleRate+1/$D3/$C1/
        $3E/$07/$D3/$C0/$3E/$E8/$D3/$C1/
        $DB/$C0/$CB/$7F/$28/$FA/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/

        $04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$07/$D3/$C0/$3E/$01/$D3/$C1/
        $FB

             );
   End;  {Sample}

Procedure PlaySample(StartAddr,SampleLenght,SampleFrequency:Integer;
	             Volume:Byte);  {ADPCM}
   Var SampleRate :Integer;
       EndAddr    :Integer;
       Temp       :Integer;
   Begin
       Temp := Trunc(SampleFrequency / 1000);
       SampleRate := 1312 * Temp;
       EndAddr := StartAddr + SampleLenght;
       Inline (
        {Play sample }
        $F3/$3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$08/

        $D3/$C1/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/
{ $3e/$08}
        $D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/$3E/$08/$D3/$C0/$3E/$00/

        $D3/$C1/$3E/$09/$D3/$C0/$3a/StartAddr/$D3/$C1/
        $3E/$0A/$D3/$C0/$3a/StartAddr+1/$D3/$C1/
        $3E/$0B/$D3/$C0/$3a/EndAddr/$D3/$C1/$3E/$0C/$D3/$C0/
        $3a/EndAddr+1/$D3/$C1/$3E/$10/$D3/$C0/$3a/SampleRate/$D3/$C1/
        $3E/$11/$D3/$C0/$3a/SampleRate+1/$D3/$C1/
        $3e/$12/$D3/$C0/$3a/Volume/$D3/$C1/$3E/$07/$D3/$C0/$3E/$A0/

        $D3/$C1/
      {
        $DB/$C0/$CB/$67/$28/$FA/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/

        $3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/

        $3E/$07/$D3/$C0/$3E/$01/$D3/$C1/
      }
        $FB
                );
   End;  {PlaySample}

Procedure RepeatSample(StartAddr,SampleLenght,SampleFrequency:Integer;
                       Volume:Byte);  {ADPCM}
   Var SampleRate :Integer;
       EndAddr    :Integer;
       Temp       :Integer;
   Begin
       Temp := Trunc(SampleFrequency/1000);
       SampleRate := 1312 * Temp;
       EndAddr := StartAddr + SampleLenght;
       Inline (
        {Play sample }
        $F3/$3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$08/

        $D3/$C1/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/
{ $3e/$08}
        $D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/$3E/$08/$D3/$C0/$3E/$00/

        $D3/$C1/$3E/$09/$D3/$C0/$3a/StartAddr/$D3/$C1/
        $3E/$0A/$D3/$C0/$3a/StartAddr+1/$D3/$C1/
        $3E/$0B/$D3/$C0/$3a/EndAddr/$D3/$C1/$3E/$0C/$D3/$C0/
        $3a/EndAddr+1/$D3/$C1/$3E/$10/$D3/$C0/$3a/SampleRate/$D3/$C1/
        $3E/$11/$D3/$C0/$3a/SampleRate+1/$D3/$C1/
        $3e/$12/$D3/$C0/$3a/Volume/$D3/$C1/$3E/$07/$D3/$C0/$3E/$b0/

        $D3/$C1/
      {
        $DB/$C0/$CB/$67/$28/$FA/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/

        $3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/

        $3E/$07/$D3/$C0/$3E/$01/$D3/$C1/
      }
        $FB
                );
   End; {RepeatSample}



Procedure StopSamplePlay;   {ADPCM}

  Begin
    Inline (
        {Stop repeating sample play}
        $3E/$07/$D3/$C0/$3E/$A1/

        $D3/$C1/$3E/$07/$D3/$C0/$3E/$20/$D3/$C1/$3E/$07/$D3/$C0/$3E/$00/

        $D3/$C1
           );
  End;  {StopSamplePlay}

Procedure SaveSample(FileName:StringType;AudioAddress:Integer;Bytecount:Real);
      Const BufSize = 1024;                      {ADPCM}
      Var Buffer    :Array[0..BufSize] Of Byte;	
          BufAddr   :Integer ;
          Counter   :Real;
          Count	    :Integer;
          AudioAddr :Integer;
      Begin
        If ByteCount = 0 Then ByteCount := SizeOfAudioRam;
        Handle := MsxFileCreate(fileName);
        If MsxIOResult <> 0 Then Exit;
        BufAddr := Addr(Buffer[0]);
        If BufSize > Bytecount Then
          Begin
            Count := Trunc(ByteCount);
            ReadAudioRam(AudioAddress,Addr(Buffer[0]),Count);
            MsxFileWrite(Handle,Addr(Buffer[0]),Count);
          End
         Else
           Begin
            Counter := ByteCount;
            Count   := BufSize;
            AudioAddr := AudioAddress;

            While Counter > 0 Do
             Begin
                ReadAudioRam(AudioAddr,Addr(Buffer[0]),Count);
                MsxFileWrite(Handle,Addr(Buffer[0]),Count);
                Counter := Counter - Count;
                AudioAddr := AudioAddr + Count Div 4;
                If Counter < Count then Count := Trunc(Counter);
              End;
          End;  {Else}

        MsxFileClose(Handle);

      End; {SaveSample;}	

Procedure LoadSample(FileName:StringType;AudioAddress:Integer;Bytecount:Real);
      Const BufSize = 1024;                            {ADPCM}
      Var Buffer    :Array[0..BufSize] Of Byte;
          BufAddr   :Integer ;
          Counter   :Real;
          Count	    :Integer;
          AudioAddr :Integer;
      Begin
        If ByteCount = 0 Then Bytecount := GetFileSize(FileName);
        Handle := MsxFileOpen(fileName);
        If MsxIOResult <> 0 Then Exit;
        BufAddr := Addr(Buffer[0]);
        If BufSize > Bytecount Then
          Begin
            Count := Trunc(ByteCount);
            MsxFileRead(Handle,Addr(Buffer[0]),Count);
            WriteAudioRam(AudioAddress,Addr(Buffer[0]),Count);
          End
         Else
           Begin
            Counter := ByteCount;
            Count   := BufSize;
            AudioAddr := AudioAddress;

            While Counter > 0 Do
             Begin
                MsxFileRead(Handle,Addr(Buffer[0]),Count);
                WriteAudioRam(AudioAddr,Addr(Buffer[0]),Count);
                Counter := Counter - Count;
                AudioAddr := AudioAddr + Count Div 4;
                If Counter < Count then Count := Trunc(Counter);
             End;

          End;  {Else}
        MsxFileClose(Handle);

      End; {LoadSample;}

Procedure PcmSwitch(SwitchVolume:Byte); {Values 0..127}       {PCM}
 Begin
   Inline(
          $21/SwitchVolume/
          $F3/
          $3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$00/$D3/$c1/

          $3E/$04/$D3/$C0/$3E/$08/$D3/$C1/$3E/$04/$D3/$C0/

          $3E/$80/$D3/$C1/$3E/$0D/$D3/$C0/$3E/$E1/$D3/$C1/$3E/$0E/$D3/$C0/

          $3E/$00/$D3/$C1/$3E/$08/$D3/$C0/$3E/$08/$D3/$C1/$3E/$1A/$D3/$C0/

          $18/$00/$DB/$C1/$DB/$C0/$CB/$67/$28/$FA/$3E/$1A/$D3/$C0/$18/$00/

          $DB/$C1/$CB/$7F/$28/$03/$3D/$EE/$FF/$BE/$30/$10/$DB/$C0/$CB/$67/

          $28/$FA/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$18/$DE/$3E/$04/$D3/$C0/

          $3E/$78/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$08/$D3/$C0/
          $3E/$00/$D3/$C1/
          $FB
          );
 End; {PcmSwitch}

Procedure PcmSample(DestinationAddr,SampleLength,SampleFrequency:Integer;
                    ValueToAdd:Byte);                          {PCM}

  Var SampleRate :Integer;
      Temp       :Integer;
  Begin
    Temp := Trunc(SampleFrequency /1000);
    SampleRate := Trunc(3600/Temp);
    Inline (
           $F3/
           $3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$00/$D3/$c1/

           $2a/DestinationAddr/$ed/$4b/SampleLength/
           $3E/$04/$D3/$C0/$3E/$08/$D3/$C1/
           $3E/$04/$D3/$C0/$3E/$80/$D3/$C1/
           $3E/$0D/$D3/$C0/$3a/SampleRate  /$D3/$C1/
           $3E/$0E/$D3/$C0/$3a/SampleRate+1/$D3/$C1/
           $3E/$08/$D3/$C0/$3E/$08/$D3/$C1/$3E/$1A/$D3/$C0/

           $18/$00/$DB/$C1/$DB/$C0/$CB/$67/$28/$FA/$3E/$1A/$D3/$C0/$18/$00/

           $DB/$C1/$77/$23/$0B/$78/$B1/$28/$10/$DB/$C0/$CB/$67/$28/$FA/$3E/

           $04/$D3/$C0/$3E/$80/$D3/$C1/$18/$E1/$3E/$04/$D3/$C0/$3E/$78/$D3/

           $C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/$3E/$08/$D3/$C0/$3E/$00/$D3/
           $C1/
           $FB
            );
    If ValueToAdd <> 0 Then Inline ($F3/
                  $ED/$4B/SampleLength/$2A/DestiNationAddr/$3A/ValueToAdd/
                  $5F/$7B/$86/$77/$23/$0B/$79/$B0/$20/$F7/
                  $FB );
  End; {PcmSample}

Procedure PcmPlay(SourceAddr,SampleLength,SampleFrequency:Integer;
                  Volume:Byte); {REM Volume 0..7}
  Var SampleRate :Integer;
      Temp       :Integer;
  Begin
    Temp := Trunc(SampleFrequency/1000);
    SampleRate := Trunc(3600/Temp);

    Inline(
           $F3/
           $3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$08/$D3/$C1/
           $3E/$04/$D3/$C0/$3E/$08/$D3/$C1/$3E/$04/$D3/$C0/$3E/$80/$D3/$C1/
           $3E/$0D/$D3/$C0/$3a/SampleRate  /$D3/$C1/
           $3E/$0E/$D3/$C0/$3a/SampleRate+1/$D3/$C1/
           $3E/$08/$D3/$C0/$3E/$0C/$D3/$C1/
           $3E/$17/$D3/$C0/$3a/Volume     /$D3/$C1/
           $2a/SourceAddr/$ed/$4b/SampleLength/
           $3E/$16/$D3/$C0/$3E/$C0/$D3/$C1/$3E/$15/$D3/$C0/$7E/$D3/$C1/

           $23/$0B/$78/$B1/$28/$10/$DB/$C0/$CB/$67/$28/$FA/$3E/$04/$D3/$C0/

           $3E/$80/$D3/$C1/$18/$E3/$3E/$04/$D3/$C0/$3E/$78/$D3/$C1/$3E/$04/

           $D3/$C0/$3E/$80/$D3/$C1/$3E/$08/$D3/$C0/$3E/$00/$D3/$C1/
           $3E/$18/$D3/$C0/$3E/$FF/$D3/$C1/$3E/$19/$D3/$C0/$3E/$00/$D3/$C1/
           $FB
            );
   End;   { PcmPlay }

