
{This file contains msxdos2 filehandling procedures and functions
 inspired by sdos.incs of Juan Salas.

 Please send bug reports to Kari Lammassaari lammassa@great-mail.great.fi

 - Function LongIntToReal(Long:LongInt):Real;  (LongInt is here an Array[0..3] Of Byte)
 - Procedure FindFirst( Path  : StringType;Attr  : byte;VAR sr: FibType);
 - Procedure FindNext( VAR sr: FibType);
 - Function ExpandFileAttribute( B: byte): StringType; (Juan Salas)
 - Procedure ChDrv(drive: byte); (Juan Salas)
 - Procedure ChDir(DirName:StringType ); (Juan Salas)
 - Function GetCurrentDirectory(Drive:Byte):StringType;
 - Function GetCurrentDrive:StringType;  (Returns drive char with : ie. A: )
 - Function GetRamdiskSize:Byte ; (Returns segment count size = seg * 16 Kb .)
 - Function GetFileSize:Real; (Use only with UNOPENED file.)
 - Function GetDriveCount:Byte ; (Returns the number of drives H: excluded !)
 - Function  GetWholePathString(Path:StringType):StringType;
 - Function MsxFileOpen(FileName:StringType):Byte;
 - Functiom MsxFileCreate(FileName:StringType);Byte;
 - Procedure MsxFileClose(FileHandle:Byte);
 - Procedure MsxFileRead(Handle:Byte; BufAddr:Integer; Var ByteCount:Integer);
 - Procedure MsxFileWrite(Handle:Byte;BufAddr:Integer; Var ByteCount:Integer);
 - Function AsciiZToString(ChArray:FibName):StringType;
 - Procedure ExplainErrorCode(Err:Byte;BuffAddr:Integer);
 }

Const BufferSize = 128;

      {Attribute bits }
      ReadOnly = 1;Hidden = 2;System = 4;
      Volume = 8;Directory = 16;Archive =32;

Type LongInt = Array[0..3] Of Byte;
     FibName = Array[0..12] Of Char;
     FIBType = Record
                 Header        :Byte;
                 FileName      :FibName;
                 FileAttribute :Byte;
                 PackedTime    :Integer;
                 PackedDate    :Integer;
                 FirstCluster  :Integer;
                 FileSize      :LongInt;
                 LogicalDrive  :Byte;
                 InternalData  :Array[0..37] Of Byte;
              End;
    StringType = String[66]; {Can contain path name ie. 'a:\temp\fname.txt' }

    BufferType = Array[0..BufferSize] Of Byte;

Var Fib           :FibType;
    MsxIoResult   :Byte;
    Handle        :Byte;

Function GetRamdiskSize :Byte;
  Var b :Byte;
  Begin
   Inline ( $0E/$68/
            $06/$FF/
            $CD/ 5/ 0/
            $78/
            $32/ B
          );
   GetRamdiskSize := b;
End;



Function GetDriveCount:Byte;
 Var count :Byte;
 Begin
   Inline ( $0e/$19 / {get current drv }
            $cd/5/0/  {drive number in A , A=0, B= 1 etc }
            $5f/      {ld e,a }
            $0e/$0e/  {select drv , the same ofcourse}
            $cd/5/0/
            $32/Count {returns drv count in A (and L)}
          );
    GetDriveCount := Count;
 End;

Function LongIntToReal(Long:LongInt):Real;

 Var mul0,mul1 :Real;
 Begin
   mul0 := 256; mul1 := mul0 * mul0;
   LongIntToReal := Long[0] + Long[1] * mul0 + Long[2] * mul1 +
                    Long[3] *mul1 * mul1;
 End;

Procedure FindFirst( Path  : StringType;
                     Attr  : byte;
                     VAR sr: FibType);
begin
  Path:=Path+chr(0);
  Inline($0E/$40/           {LD C,FINDFIRST}
         $11/Path+1/        {LD DE,SEARCHKEY}
         $3A/Attr/$47/      {LD A,ATTR + LD B,A}
         $DD/$2A/Sr/        {LD IX,(Sr)}
         $CD/$05/0/
         $32/MsxIoResult);
end;

Function GetFileSize(FileName:StringType):Real;
 VAR Fib  :FibType;
 Begin
      FindFirst(FileName,0,Fib);
      GetFileSize := LongIntToReal(Fib.FileSize);
  End ; {GetFileSize}


Procedure FindNext( VAR sr: FibType);
 Begin
  Inline( $0E/$41/
          $DD/$2A/Sr/
          $CD/$05/0/
          $32/MsxIoResult);
 End;


Function ExpandFileAttribute( B: byte): StringType;
var temp: StringType;
begin
temp:='..... ';
 if (b and 4)  > 0 then temp[1]:='s';
 if (b and 2)  > 0 then temp[2]:='h';
 if (b and 1)  > 0 then temp[3]:='r';
 If (b and 18) > 0 Then Temp[4]:='d';
 if (b and 32) > 0 then temp[5]:='a';
 ExpandFileAttribute:=temp
end;

Procedure ChDrv(drive: byte);
begin
   MsxIoResult:= Bdos($0E, drive)
end;


Procedure ChDir(DirName:StringType );
 Var Fn :FibName;
     i  :Byte;
 Begin
  For i := 1 To Length(DirName) Do Fn[i-1] := DirName[i];
  Fn[i] := Chr(0);
  Inline($0E/$5A/$11/ Fn /$CD/$05/0/$32/MsxIoResult);
 End;


Function GetCurrentDirectory(Drive:Byte):StringType;

 Type PathBufferType = Array[0..63] Of Char;
 Var drv    :Byte;
     Buf    :PathBufferType;
     St     :StringType;
     i      :Byte;
 Begin
   drv := Drive;
   Inline( $0E/$59/          {Ld c, getdir}
           $3A/ drv /        {Ld a,drive}
           $47/              {Ld b,a }
           $11/ Buf/         {Ld de,bufferadr}
           $CD/$05/$00/      {call bdos}
           $32/MSXIOResult   {ld (doserror),a}
         );
   i := 0; St :='';
   While Buf[i] <> Chr(0) Do
    Begin
       St := St + Buf[i];
       i := i +1;
    End;
   If MsxIOResult = 0 Then GetCurrentDirectory := St
    Else GetCurrentDirectory := '';
 End;

Function GetCurrentDrive:StringType;
 Var drv :Byte;
 Begin
   Inline ( $0e/$19/
            $cd/$05/$00/
            $32/drv
          );
   GetCurrentDrive := Chr(65+drv)+':';
 End;

Function  GetWholePathString(Path:StringType):StringType;
 Type PathBufferType = Array[0..63] Of Char;
 Var Buf :PathBufferType;
     St  :StringType;
     i   :Byte;
 Begin
  Inline ( $0E/$5e/          {ld a,_wpath}
           $11/ buf /        {ld de, bufaddr}
           $CD/$05/$00/      {call bdos}
           $32/MsxIOResult   {Store possible error}
         );
  i := 0; St :='';
   While Buf[i] <> Chr(0) Do
    Begin
       St := St + Buf[i];
       i := i +1;
    End;
   If MsxIOREsult = 0 Then GetWholePathString := St
    Else GetWholePathString := '';

End;



Function MsxFileOpen( FileName:StringType):Byte; {Returns fileHandle}
 VAR temp :Byte;
     Fib  :FibType;
 Begin
      FillChar(Fib,SizeOf(Fib),0);
      Move(FileName[1],Fib,Length(FileName));
      Inline ( $11/Fib/  {LD DE,FIB}
               $3e/0/    {A:=0}
               $0E/$43/  {LD C,OPEN_FILE_HANDLE}
               $CD/5/0/
               $32/ MsxIoResult/
               $78/      {ld a,b}
               $32/temp  {ld (temp),a}
             );
      MsxFileOpen := Temp;
 End;

Function MsxFileCreate(FileName:StringType):Byte; {Returns fileHandle}
 VAR temp :Byte;
     Fib  :FibType;
 Begin
      FillChar(Fib,SizeOf(Fib),0);
      Move(FileName[1],Fib,Length(FileName));
      Inline ( $11/Fib/  {LD DE,FIB}
               $3e/0/    {A:=0}
 	       $47/	 {ld b,a}
               $0E/$44/  {LD C,OPEN_FILE_HANDLE}
               $CD/5/0/
               $32/ MsxIoResult/
               $78/      {ld a,b}
               $32/temp  {ld (temp),a}
             );
      MsxFileCreate := Temp;
 End;

Procedure MsxFileClose(FileHandle:Byte);

  Begin
     Inline ( $0e/$45/         {Ld c,Close_file_handle}
              $3a/FileHandle/  {ld a,handle_number}
              $47/             {ld b,a}
              $cd/5/0
            );
 End;

Procedure MsxFileRead(Handle:Byte; BufAddr:Integer;Var Bytecount:Integer);

 Var ByteCounter:Integer;
     BufPointer :Integer;
 Begin
      ByteCounter := ByteCount;
      BufPointer := BufAddr;
      Inline ( $0e/$48/
               $3a/Handle/
               $47/
               $Ed/$5b/BufPointer/
               $2a/ByteCounter/
               $cd/5/0/
               $32/MsxIoResult/
               $22/ByteCounter
              );
      ByteCount := ByteCounter;
  End;

Procedure MsxFileWrite(Handle:Byte;BufAddr:Integer;Var ByteCount:Integer);
 Var ByteCounter :Integer;
     BufPointer  :Integer;

 Begin
      ByteCounter := ByteCount;
      BufPointer  := BufAddr;
      Inline ( $0e/$49/
               $3a/Handle/
               $47/
               $Ed/$5b/BufPointer/
               $2a/ByteCounter/
               $cd/5/0/
               $32/MsxIoResult/
               $22/ByteCounter
              );
    ByteCount := ByteCounter;
  End;

Procedure ResetArchiveBit(DirData:FibType);

  Var b:Byte;
  Begin
     b := (DirData.FileAttribute And 223); {Mask off attribute bit}
     Inline ( $0e/$50/        {Ld c,_attr}
              $11/DirData /   {Ld de,DirData}
              $3a/ b  /       {ld a,fileattribute}
              $6f/            {ld l,a}
              $3e/ 1/         {ld a,1 = set fileattr}
              $cd / 5 / 0     {call bdos}
            );
End;

Function AsciiZToString(ChArray:FibName):StringType;
 Var i :Byte;
     St:StringType;

 Begin
   i := 0;St := '';
   While ChArray[i] <> Chr(0) Do
    Begin
     St := St + ChArray[i];
     i := i +1;
    End;
   AsciiZToString := St;
 End;

Procedure ExplainErrorCode(Err:Byte;BuffAddr:Integer);
 {Buffer must be 64 bytes long }
 Var Buf :Integer;
 Begin
    Buf := BuffAddr;
    Inline( $3a/Err/
            $47/
            $0e/$66/
            $ed/$5b/Buf/
            $cd/$05/0
          ); End;
                                                                                             