{
 Mouse.inc (NEW version)
 Mouse routines by K.Lammassaari
 Uses ROM-bios.

 Contains:

  - a global variable MousePort:Byte , which is updated by function
      MouseDetected. Valid only if MouseDetected returns TRUE !

  - a function MouseDetected:Boolean , which searches both joystic ports for
      a mouse. Returns TRUE, if mouse is found and updates the global variable
      MousePort to point to the right joystick port .

  - a Procedure GetMouse(JoyStickPort,Var x,y :Integer;
                                      Var LeftButton,RightButton:Byte);

      Normally called after MouseDetected-function as:
       'GetMouse(MousePort,x,y,TrigA,TrigB);' .
}

Var MousePort :Byte; {This variable will be updated by
                      Function MouseConnected.}

Procedure Getmouse(    JoyStickPort:Byte;
                   Var x,y:Integer;Var LeftTrigger,RightTrigger:Byte);
 Var xx,yy :Integer; {Integer provides possibility to use negative values}
     tt1,tt2  :Byte;
     Joy      :Byte;
 Begin
  xx := 0;
  yy := 0;
  Joy  := (JoyStickPort-1)*4 + 12;
  Inline
    ($F3/
     $3a/Joy /$F5/$FD/$2A/$C0/$FC/$DD/$21/$DB/$00/$CD/$1C/$00/
     $f1/$3c/$f5/$FD/$2A/$C0/$FC/$DD/$21/$DB/$00/$CD/$1C/$00/
     $FE/$80/$26/$00/$38/$02/$26/$ff/$6F/$22/ xx    /
     $f1/$3c/$FD/$2A/$C0/$FC/$DD/$21/$DB/$00/$CD/$1C/$00/
     $FE/$80/$26/$00/$38/$02/$26/$ff/$6F/$22/ yy    /
     $3a/JoyStickPort /$f5/$FD/$2A/$C0/$FC/$DD/$21/$D8/$00/$CD/$1C/$00/
     $32/ tt1   /
     $f1/$3c/$3c/$FD/$2A/$C0/$FC/$DD/$21/$D8/$00/$CD/$1C/$00/
     $32/ tt2   /
     $FB
    );
  x  := xx;
  Y  := yy;
  LeftTrigger  := tt1;
  RightTrigger := tt2;
 End; {Getmouse}

Function MouseDetected :Boolean;  {Updates global variable Mouseport, which is
                                   valid, if MouseConnected = True .
                                   }
  Var MouseFound :Boolean;
      i,p,t1,t2  :Byte;
      x,y        :Integer;

  Begin
     MouseFound := False;
     P := 1;
     While (Not MouseFound) And (p < 3) Do
       Begin
         i := 0;
         While (i < 20) And Not MouseFound Do
           Begin
             GetMouse(p,x,y,t1,t2);
             If (x <> 1) And (Y <> 1) then
                Begin
                  MouseFound := True;
                  MousePort  := p;
                End;
             i := i+1;
           End;
         p := p+1;
       End;
     If MouseFound Then MouseDetected := True
      Else MouseDetected := False;
   End; {MouseDetected}

