Program MusicModule;

{Adjust paths to fit Your system. Inc's available at ftp.funet.fi/pub/msx }

{$I msxdos2.inc}
{$I MusicMo1.inc}

Var Ch :Char;
    AllAudioRam :Integer;

Procedure Samp;
   Var Freq :Integer;
   Begin

     Repeat
      GotoXY(1,20);ClrEol;Write('Give sampling frequency 2000..16000. ');
      Readln(Freq);
     Until (Freq > 1999) And (Freq < 16001);

     GotoXY(1,21);Writeln('Sampling ADPCM to all audio ram. Be LOUD enough ! ');
     PcmSwitch(120);
     GotoXY(1,21);Writeln('Sampling has started.                             ');
     Sample(0,AllAudioRam,Freq);
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;

Procedure Play;
   Var Freq :Integer;
   Begin
     Repeat
      GotoXY(1,20);ClrEol;Write('Give sampling frequency 2000..16000. ');
      Readln(Freq);
     Until (Freq > 1999) And (Freq < 16001);

     GotoXY(1,21);Writeln('Playing all audio ram ... ');
     PlaySample(0,AllAudioRam,Freq,255);
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;

Procedure Repe;
   Var Freq :Integer;
   Begin
     Repeat
      GotoXY(1,20);ClrEol;Write('Give sampling frequency 2000..16000. ');
      Readln(Freq);
     Until (Freq > 1999) And (Freq < 16001);

     GotoXY(1,21);Writeln('Repeating all audio ram ... ');
     RepeatSample(0,AllAudioRam,Freq,255);
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;

Procedure Stop;
   Begin
     GotoXY(1,20);Writeln('Stopping playback/repeating .');
     StopSamplePlay;
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;

Procedure Save;
   Var Fn:StringType;
   Begin
     GotoXY(1,20);Write('Give legal filename for the sample to save. ');
     Readln(Fn);
     GotoXY(1,21);Writeln('Saving all audio ram ... ');
     SaveSample(Fn,0,0);
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;

Procedure Load;
   Var Fn:StringType;
   Begin
     GotoXY(1,20);Write('Give legal filename for the sample to load. ');
     Readln(Fn);
     GotoXY(1,21);Writeln('Loading to audio ram ... ');
     LoadSample(Fn,0,0);
     GotoXY(1,20);ClrEol;
     GotoXY(1,21);ClrEol;
   End;


{*** MAIN ***}

Begin
   ClrScr;
   If MusicModuleExists Then
     Begin
        Writeln;
        Writeln(
'                 MM found !  Audio RAM size = ',AudioRamSize,' Kb.');
        Writeln(
'           Testing ADPCM sampling/playback With musicmo1.inc.');
        Writeln(
'                     Kari Lammassaari/Finland 1996 ');
     End
   Else
    Begin
        Writeln('Music Module not found !');
        Halt;
    End;

   AllAudioRam := (AudioRamSize-1)*256 + 255;

   GotoXY(26,8);  Writeln('1.    Sample ');
   GotoXY(26,9);  Writeln('2.    Playback ');
   GotoXY(26,10); Writeln('3.    Repeat sample ');
   GotoXY(26,11); Writeln('4.    Stop sample ');
   GotoXY(26,12); Writeln('5.    Save sample ');
   GotoXY(26,13); Writeln('6.    Load sample ');
   GotoXY(26,14); Writeln('7.    Exit');
   Repeat
       Read(Kbd,Ch);
       Case Ch Of
         '1': Samp;
         '2': Play;
         '3': Repe;
         '4': Stop;
         '5': Save;
         '6': Load;
       End;
   Until Ch = '7';

   StopSamplePlay;
   ClrScr;
   Writeln(
'Read MUSICMO1.TXT for extra info about the Music Module procedures .');
   Writeln('Kari Lammassaari 1996 ',AllAudioRam );
End.

