{MbPlayer.inc }
{Turbo Pascal moonblaster dos player routines by Kari Lammassaari 1997}

{The source of mbplayer.mpc needed by this source is originally written
 by REMCO SCHRIJVER and later improvements are from Maarten ter Huurne alias
 KRYTEN/MAYHEM .
 The modifications I made, were msxdos2 support, better OPLL search (from
 library of MsxHandbook), mapper support routines and adaptation to operate
 under DOS.}

{ Read MBPLAYER.TXT for more info . }


Const 	StartMusic    = $4000;  {Entries to player code. Used internally }
        StopMusic     = $4003;
        PauseMusic    = $4006;  {Not used, same as StopMusic}
	ContinueMusic = $4009;
	SearchChips   = $400c;
        MbkLoad       = $400f; {Entry for MModule sample kit loader.}
        MbmLoad       = $4012; {Entry for Moonblaster MBM-file loader}
        MusicInt      = $4015; {Entry for music interrupt}
        ClearFIB      = $4018; {Clear internal FileInfoBlock}
	
	MusicFIB      = $4033; {Internal fib for loading MBM and MBK files}
        Chips         = $401b; {0=MsxAudio,1=MsxMusic,2=both}
        MusicPageNum  = $401D; {Contains the music page number}
        DosErrorFlag  = $4073; {Contains recent dos operation result,Not used.}
        MapperJumpTbl = $4074; {This MUST be updated by pascal code. Mapper.inc
			        returns the required address in JumpTablePtr}
					
        IntCode      :Array[0..17] Of Byte = ($f5,$db,$fd,$f5,$3e,0,$d3,$fd,
					      $cd,$15,$40,$f1,$d3,$fd,$f1,
					      $c3,0,0);
 	RedirectCode :Array[0..2] Of Byte = ($c3,$ca,$f6);
                  {Redirect $38 interrupt to $f6ca. }

        Const PlayerName = 'mbplayer.mpc';
              SystemPage = 1;

Var
    PlayerPageID :Integer;                        {The page id of player page}
    MusicPageID  :Integer;                        {The page id of music page }
    NewHook	:Array[0..17] Of Byte Absolute $f6ca ;  {Code to access player}
    z80int      :Array[0..2]  Of Byte Absolute $0038;   {Original $38 interrupt}
    z80orig	:Array[0..20] Of Byte;                  {Storage for $38 int }

Function InitMbmPlayer:Boolean; {True if succeeded ;}

  Var Dummy     :Boolean;
      MusicPage :Byte;
      a		:Byte;
      sr	:FibType;
  Begin

    FindFirst(PlayerName,0,sr);{Is there player code file available ? }
    If MsxIoResult <> 0 Then
      Begin
        Writeln('Cannot find player file ',PlayerName,' ... Exiting ....');
        Halt;
      End;

    If ( Not MapperSupport(MapperCount) ) Or ( MapperTablePtr^.PagesFree < 2 )
      Then
       Begin
	 Writeln('No memory mapper support or free primary pages ! Exiting ...');
	 InitMbmPlayer := False;
         Exit;
       End
    Else
       Begin
         PlayerPageId := LoadMcFile(PlayerName); {Load player code.}

         WriteMapperPage(PlayerPageId,Addr(JumpTablePtr),MapperJumpTbl,2);
	       {Inform player the mapper service jump table location.}

         CallMcPage(PlayerPageId,SearchChips,a,bc,de,hl,ix,iy);  {Search Chips }

         Dummy := AllocateMapperPage(PrimaryMapper,SystemPage,MusicPageId);

   	MusicPage := Hi(MusicPageId);
   	WriteMapperPage(PlayerPageId,Addr(MusicPage),MusicPageNum,1);
	       {Inform player the music page number.}	

        InitMbmPlayer := True;
      End;
 End; {InitMbmPlayer }

Procedure LoadMBKFile(FileName:StringType);
  Var a:Byte;
  Begin
     CallMcPage(PlayerPageId,ClearFIB,a,bc,de,hl,ix,iy); {Clear internal FIB. }

     WriteMapperPage(PlayerPageId,Addr(FileName[1]),MusicFib,Length(FileName));
          {Move filename into internal FIB of player.}

     CallMcPage(PlayerPageId,MbkLoad,a,bc,de,hl,ix,iy);
          {Load sample file into Music Module Audio Ram .}
     {
     ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(ErrorCode),1);
     Writeln('Error Code = ',ErrorCode);
     }
  End;

Procedure LoadMBMFile(FileName:StringType);
  Var a:Byte;
  Begin
     CallMcPage(PlayerPageId,ClearFIB,a,bc,de,hl,ix,iy); {Clear internal FIB. }

     WriteMapperPage(PlayerPageId,Addr(FileName[1]),MusicFib,Length(FileName));
          {Move filename into internal FIB of player.}

     CallMcPage(PlayerPageId,MbmLoad,a,bc,de,hl,ix,iy);
          {Load MBM-music file into mapper page .}
     {
     ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(ErrorCode),1);
     Writeln('Error Code = ',ErrorCode);
     }
  End;

Function GetMusicChips:Byte; {0=MsxAudio,1=MsxMusic,2=Both,255 = PSG}
 Var Temp :Byte;
 Begin
   ReadMapperPage(PlayerPageId,Chips,Addr(Temp),1);{get Chips}
   GetMusicChips := Temp;
 End;

Procedure StartMbmPlay;
  Var a:Byte;
 Begin
   CallMcPage(PlayerPageId,StartMusic,a,bc,de,hl,ix,iy);  {Start routines}
   Move(IntCode,NewHook,SizeOf(IntCode));           {Set player int code }
   NewHook[5] := Hi(PlayerPageId);                  {PageNum of player code}
   NewHook[16] := Mem[$39]; NewHook[17] := Mem[$3a]; {Patch player int code }
   Move(z80int,z80orig,3);                           {Store orig $38 interrupt}
   Inline($f3); Move(RedirectCode,z80Int,3);Inline($fb); {Redirect $38 int }
End;

Procedure StopMbmPlay;
  Var a:Byte;
  Begin
    Inline($f3); Move(z80orig,z80Int,3);Inline($fb);    {Restore $38 interrupt}
    CallMcPage(PlayerPageId,StopMusic,a,bc,de,hl,ix,iy);{Reset chips}
  End;


Procedure ContinueMbmPlay;
  Var a:Byte;
 Begin
  CallMcPage(PlayerPageId,ContinueMusic,a,bc,de,hl,ix,iy);{Continues playing}
  Inline($f3); Move(RedirectCode,z80Int,3);Inline($fb); {Redirect $38 int }
 End;

Function GetErrorCode:Byte; { The codes are normal msxdos2 error codes }
 Var Temp :Byte;
 Begin
   ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(Temp),1);{get error code}
   GetErrorCode := Temp;
 End;

