{Code by Kari Lammassaari , Finland}

{Uses vdpcmd.inc}
{Uses MsxDos2.inc }

{
Type StringType = String[80]; 
Procedure LoadGraphicBlock(FileName :StringType;
                           x,y      :Integer;
                           Page     :Byte;
                           LogOp,Direction :Byte
                         );

- Uses temporarily 512 - 1280 (depending on screen mode) heap bytes as buffers.
  Memory released after operation.
}

{Don't care this. It's only reminder to me !
 Logical  dot move from RAM to Ram.
 The LMMC - command (in VDP) requires specially formatted data. 
 You have extract dot data from screen data bytes created by BASIC's copy
 command. Eg. Screen 6 screen data byte contains 4 dots.

 Prepare source before procedure execution.
 See Inline code in LoadGraphicBlock.
 
 Dot Data    = Screen 5 , 4-bits xxxxbbbb   ; x = don't care
               Screen 6 , 2-bits xxxxxxbb   ; x = don't care
               Screen 7 , 4-bits xxxxbbbb   ; x = don't care
               Screen 8 , 8-bits bbbbbbbb   ; x = don't care

}

Procedure _MoveDotToVram
             (SourceAddress :Integer;
              Destination_x,Destination_y:Integer;DestinationPage:Byte;
              Number_x,Number_y:Integer;
              LogicalOperation,Direction:Byte
             );

Var Address :Integer;

Begin
   Address := SourceAddress+1; {Because the firsbyte is set in CMD array. }

   _cmd:= LMMC + LogicalOperation;
   _dy := DestinationPage * 256 + Destination_y ;
   _arg:= Direction ;
   _dx := Destination_x;
   _nx := Number_x;
   _ny := Number_y;

   _col:= Mem[Address-1];

   Inline ($f3/
          $DD/$2A/Address/
          $3E/$02/$D3/$99/$3E/$8F/$D3/$99/$DB/$99/$CB/$47/

          $20/$F2/$F3/$3E/$20/$D3/$99/$3E/$11/$F6/$80/$D3/$99/$06/$0F/$0E/

          $9B/$21/$62/$F5/$ED/$B3/$3E/$2C/$F6/$80/$D3/$99/$3E/$11/$F6/$80/

          $D3/$99/$3E/$02/$D3/$99/$3E/$8F/$D3/$99/$DB/$99/$CB/$47/$28/$0D/

          $CB/$7F/$28/$EE/$DD/$7E/$00/$DD/$23/$D3/$9B/$18/$E5/$3E/$00/$D3/

          $99/$3E/$8F/$D3/$99/$DB/$99/$fb

          );
End ; {Lmmc}

{Type StringType = String[80]; }
Procedure LoadGraphicBlock(FileName :StringType;
                           x,y      :Integer;
                           Page     :Byte;
                           LogOp,Direction :Byte
                         );

  Var ReadBuf :^Integer;
      Temp    :Integer Absolute ReadBuf;
      DotBuf  :^Integer;
      DotTemp :Integer Absolute DotBuf;
      Counter,yy :Integer;
      Width,Height   :Integer;
      ScrMod  :Byte Absolute $fcaf ;
      BufSize :Integer;
  Begin
     Case ScrMod Of
       0,1,2,3,4 :BufSize := 256 ; {Dummy option}
       5,7       :BufSize := 512 ;
       6         :BufSize := 1024;
       8         :BufSize := 256 ;
      End;
     GetMem(ReadBuf,256);
     GetMem(DotBuf,BufSize);
     Handle := MsxfileOpen(filename);
     Writeln('Open = ',MsxIOResult);
     Counter := 4; {Get Header }
     MsxFileRead(Handle,Temp,Counter);
     Width := ReadBuf^;
     Height := Mem[Temp + 2] + Mem[Temp+3] *256;
     Counter :=Width Div (BufSize Div 256) ;
     yy :=y;
     MsxFileRead(Handle,Temp,counter);
     While Counter > 0 Do
      Begin
       Case ScrMod Of
         5,7 :Inline($f3/
               $2A/Temp/$ED/$5B/DotTemp/$ED/$4B/Counter  /$7E/$F5/$CB/$3F/$CB/

               $3F/$CB/$3F/$CB/$3F/$12/$13/$F1/$E6/$0F/$12/$13/$23/$0B/$78/$B1/

               $20/$E9/$fb
                    ); {Split one 8-byte to two 4-bit bytes}

         6  :Inline ($f3/
              $DD/$2A/Temp /$FD/$2A/DotTemp /$ED/$5B/Counter /$DD/$7E/$00/$06/

              $04/$0E/$00/$17/$CB/$11/$17/$CB/$11/$FD/$71/$00/$FD/$23/$10/$F1/
              $1B/$DD/$23/$7A/$B3/$20/$E5/$fb
                    ); {Split one 8-byte to four 2-bit bytes}

         8   :Inline ($f3/
                      $2a/Temp /$ed/$5b/DotTemp /$ed/$4b /Counter /
                      $ed/$b0/$f3
                     ); {Moves 8-bit data directly from readbuf to Vrambuf.}
       End; {Case}

       _MoveDotToVram(DotTemp, x,yy,Page, Width,1, LogOp,Direction );
       yy :=yy+1;
       MsxFileRead(Handle,Temp,counter);
      End;

     MsxFileClose(Handle);
     FreeMem(ReadBuf,256);
     FreeMem(DotBuf,BufSize);
  End;
