PROGRAM  Opdracht20; {a: Teken de "Koch-kromme"}
                     {Door Ayhan Cicek & Manuel Bilderbeek}

{$I VDPCMD.INC}
{$I SCREEN.INC}
{$I LINE.INC}

{$A-}
{$C-}

CONST UserMaxX=1;
      UserMinX=0;     {Zorg dat UserMin<Usermax!!}
      UserMaxY=0.4;
      UserMinY=0;
      GetMaxY=211;
      GetMaxX=511;

PROCEDURE Convert(UserX,UserY:Real;VAR SchermX,SchermY:integer);
          {Converteer UserCoordinaten naar SchermCoordinaten}
BEGIN
     SchermX:=round( (UserX-UserMinX) * GetMaxX/(UserMaxX-UserMinX) ) ;
     {Converteer X-coordinaat met juiste off-set}
     SchermY:=GetMaxY-round( (UserY-UserMinY) * GetMaxY/(UserMaxY-UserMinY) ) ;
     {Converteer Y-coordinaat met juiste off-set}
END;

PROCEDURE DrawLine(X1,Y1,X2,Y2:Real);
          {Teken een lijn met als input UserCoordinaten}
VAR
  SchermX1,SchermY1,
  SchermX2,SchermY2 : Integer;
BEGIN
     Convert(X1,Y1,SchermX1,SchermY1);
     Convert(X2,Y2,SchermX2,SchermY2);
     LINE (SchermX1,SchermY1,SchermX2,SchermY2,0,15,0);
END;

PROCEDURE Roteer(x2,y2,X4,Y4:real;VAR X3,Y3:real);
BEGIN
     X3:=X2+(x4-x2)/2-(y4-y2)/2*SQRT(3);
     Y3:=Y2+(X4-X2)/2*SQRT(3)+(Y4-Y2)/2;
END;

PROCEDURE Koch(x1,y1,x5,y5:real);
VAR Lengte,X2,Y2,X3,Y3,X4,Y4:real;

BEGIN
     Lengte:=SQRT(SQR(X1-X5)+SQR(Y1-Y5));
     IF Lengte<0.01 THEN DrawLine(X1,Y1,X5,Y5) ELSE
     BEGIN
          X2:=(2*X1+X5)/3;
          Y2:=(2*Y1+Y5)/3;
          X4:=(2*x5+X1)/3;
          Y4:=(2*y5+Y1)/3;
          Roteer(X2,Y2,X4,Y4,X3,Y3);
          Koch(X1,Y1,X2,Y2);
          Koch(X2,Y2,X3,Y3);
          Koch(X3,Y3,X4,Y4);
          Koch(X4,Y4,X5,Y5);
     END;
END;

BEGIN
     Screen(7);
     Koch(0,0,1,0);
     ReadLn;
     Screen(0);
END.

                                              