{JoyStick.inc by Kari Lammassaari }

{Direct code. No ROM BIOS used. }
{Contains following functions:

 - Function Stick(JoyStickNumber:Byte):Byte;

    JoyStickNumber 0 = Keyboard , 1 and 2 are joysticks.
    Returns numbers 1..8 . Zero = Joystick not moved.
    1= UP,2 = UP-Left, 3 = LEFT, 4 = LEFT-down etc.

 - Function Strig(StrigNumber:Byte):Byte;

    Returns 255 if trigger pressed/ Zero = not pressed.
    StrigNumber 0 = Keyboard Space;
                1 = Button A on Joystick 1
                2 = Button A      "      2
                3 = Button B      "      1
                4 = Button B      "      2
}

Function Stick(JoyStickNumber:Byte):Byte;

  Const IC = 0; {Illegal combination. For example Up+Down. Define IC:s with
                nonzero values, if you need them.}

        JoyTable:Array[0..15] Of Byte=(0,1,5,IC,7,8,6,IC,3,2,4,IC,IC,IC,IC,IC);
                                           {Used to parse Psg register 14 .}
                                           {Four low bits are:RGTH,LFT,DWN,UP}

       KeyTable :Array[0..15] Of Byte=(0,7,1,8,5,6,ic,ic,3,ic,2,ic,4,ic,ic,ic);
                                           {Used to parse PPI reg $a9.}
                                           {Four high bits are:RGTH,DWN,UP,LFT}
  Var RawByte :Byte;
  Begin
    If JoyStickNumber <> 0 Then
      Begin
       Inline ($f3/$3a/ JoyStickNumber/$e6/2/ $0f/$0f/$0f/$47/
               $3e/$0f/$d3/$a0/$db/$a2/$e6/191/$b0/$d3/$a1/ {Selects joystick.}
               $3e/$0e/$d3/$a0/$db/$a2/$ee/$ff/$21/JoyTable/
               $16/0/$e6/$0f/$5f/$19/$7e/$32/RawByte/$fb);
      End
     Else
      Begin
       Inline ($f3/$db/$aa/ $e6/240/$f6/8 /$d3/$aa/
               {Keyboard row 8 scan.Bit0=Space}
               $db/$a9/$ee/$ff/$cb/$3f/$cb/$3f/$cb/$3f/$cb/$3f/
               $21/KeyTable/$16/0/$5f/$19/$7e/$32/RawByte/$fb);
      End;
    Stick := RawByte;

  End; {Stick}


Function Strig(StrigNumber:Byte):Byte;

  Var RawByte     :Byte;
      StickNumber :Byte;
  Begin
    If StrigNumber <> 0 Then
      Begin
       If Odd(StrigNumber) Then StickNumber := 1 Else StickNumber := 2;
       Inline ($f3/$3a/ StickNumber/$e6/2/ $0f/$0f/$0f/$47/
               $3e/$0f/$d3/$a0/$db/$a2/$e6/191/$b0/$d3/$a1/ {Selects joystick.}
               $3e/$0e/$d3/$a0/$db/$a2/$ee/$ff/
               $F5/$3A/StrigNumber /$FE/$03/$30/$04/$06/$03/$18/$02/$06/$02/

               $F1/$CB/$07/$10/$FC/$06/$07/$CB/$2F/$10/$FC/$32/RawByte/$fb);

      End
     Else
      Begin
       Inline ($f3/$db/$aa/ $e6/240/$f6/8 /$d3/$aa/   {Keyboard row 8 scan}
               $db/$a9/$ee/$ff/$e6/ 1/$0f/$cb/$2f/$cb/$2f/$cb/$2f/$cb/
               $2f/$cb/$2f/$cb/$2f/$cb/$2f/$cb/$2f/$32/RawByte/$fb);
      End;
    Strig := RawByte;

  End; {Strig}
