
Program Test_interrupts;

{$I ints.inc } { Must be compiled with start addres $3000 }

Var int1,int2,int3       :Byte;    {Store number of interrupt }
    Value1,Value2,Value3 :Integer; 

Procedure  MyInt1;
 Begin
   Value1 := (Value1+1) And $ff;
  End;

Procedure  MyInt2;
 Begin
   Value2 := (Value2+1) And $fff;
  End;

Procedure  MyInt3;
 Begin
   Value3 := (Value3+1) And $ffff;
  End;

Function KeyScan(Row:Byte):Byte;
 Var value :Byte;
 Begin
     Inline( $f3/$db/$aa/ $e6/ $f0/$47
            /$3a/ row /$e6/$0f/ $b0/ $d3/$aa/
             $db/$a9/$32/ Value /
             $fb
           );
     KeyScan := Value;
 End;


Begin
   ClrScr;

   {Now we set three interupt services }

   Int1  := SetInterrupt(Addr(MyInt1));
   Int2  := SetInterrupt(Addr(MyInt2));
   Int3  := SetInterrupt(Addr(MyInt3));

   Writeln('Testing three independent interrupt services. K.L-98');
   Writeln;
   Writeln(' Keys 1,2,3 enable interrupt. Keys 4,5,6 disable interrupt. ESC = Exit');
   Writeln;
   Repeat
     Case KeyScan(0) Of
           253: EnableInterrupt(Int1);
           251: EnableInterrupt(Int2);
           247: EnableInterrupt(Int3);
           239: DisableInterrupt(Int1);
           223: DisableInterrupt(Int2);
           191: DisableInterrupt(Int3);
     End;
   GotoXY(10,10);
   Writeln('Value 1 = ',Value1,' value 2 = ',Value2,' value 3 = ',Value3);
  Until KeyScan(7) <> 255;
  RemoveInterrupts;
End.

