{filename.inc by Kari Lammassaari 1997 }

Type FileNameType  = String[12];
     ExtensionType = String[4];

Procedure PadFileName(Var FName :FileNameType);{ Pads filename with spaces    }
  Var Temp :FileNameType;                      { to format '12345678.123'     }
      Ext  :ExtensionType;                     { for easier/more nice printing} 
      p    :Byte;
  Begin
   P := Pos('.',Fname);
   If P = 0 Then FName := Copy(Fname+'           ',1,12)
   Else
    Begin
      Temp  := Copy(Copy(FName,1,P-1)+'       ',1,8);
      Ext   := Copy(Fname,p,Length(FName)-p+1);
      Ext   := Copy(Ext+'   ',1,4);
      FName := Temp+Ext;
    End;
  End; {PadFileName}

Function RemoveTrailingSpaces(FName:FileNameType):FileNameType;

   Var p :Byte;
   Begin
     p := Pos(' ',FName);
     If p = 0 Then RemoveTrailingSpaces := FName
     Else RemoveTrailingSpaces := Copy(FName,1,p-1);
   End;

Function RestoreFilename(FName:FileNameType):FileNameType;
                                           
   Var name :FileNameType;            {Removes spaces from filenames as   }
       ext  :ExtensionType;           {'kari    .la ' => 'kari.la'        }
       p    :Byte;
   Begin
       P := Pos('.',FName);
       If P = 0 Then RestoreFileName := RemoveTrailingSpaces(FName)
       Else
         Begin
          Name := RemoveTrailingSpaces(Copy(FName,1,p-1));
          ext  := RemoveTrailingSpaces(Copy(FName,p+1,Length(FName)-p));
          RestoreFileName := name+'.'+ext;
         End;
    End;

