PROGRAM Ellips; {Progje dat een ellips tekent}
                {Programmed by Ayhan Cicek & Manuel Bilderbeek (c) 1996}

USES Graph;
VAR GraphDriver, GraphMode, ErrorCode:integer;
CONST UserMaxX=9;
CONST UserMinX=-9;     {Zorg dat UserMin<Usermax!!}
CONST UserMaxY=3;
CONST UserMinY=-3;

PROCEDURE Convert(UserX,UserY:real;VAR SchermX,SchermY:integer);
          {Converteer UserCoordinaten naar SchermCoordinaten}
BEGIN
     SchermX:=round( (UserX-UserMinX) * GetMaxX/(UserMaxX-UserMinX) ) ;
     {Converteer X-coordinaat met juiste off-set}
     SchermY:=GetMaxY-round( (UserY-UserMinY) * GetMaxY/(UserMaxY-UserMinY) ) ;
     {Converteer Y-coordinaat met juiste off-set}
END;

PROCEDURE DrawLine(X1,Y1,X2,Y2:real);
          {Teken een lijn met als input UserCoordinaten}
VAR
  SchermX1,SchermY1,
  SchermX2,SchermY2 : Integer;
BEGIN
     Convert(X1,Y1,SchermX1,SchermY1);
     Convert(X2,Y2,SchermX2,SchermY2);
     LINE (SchermX1,SchermY1,SchermX2,SchermY2);
END;

PROCEDURE Stelsel; {Teken assenstelsel}
BEGIN
     DrawLine (UserMinX,0,UserMaxX,0);
     DrawLine (0,UserMaxY,0,UserMinY);
END;

PROCEDURE DrawEllipse; {Teken de ellips}
VAR Xold,Xnew,Yold,Ynew,t:real;
CONST STEP=500;
CONST A=8;
CONST B=2;
BEGIN
     Xold:=A;                             {Beginpunt}
     Yold:=0;
     t:=0;
     WHILE t<=2*PI+(2*Pi/STEP) DO          {t van 0 tot 2pi+extra stap}
     BEGIN
        Xnew:=A*cos(t);                   {Geparametriseerde kromme}
        Ynew:=B*sin(t);
        Drawline(Xold,Yold,Xnew,Ynew);    {Lijn van oud tot nieuw punt,}
        Xold:=Xnew;                       {om stipjes te voorkomen.}
        Yold:=Ynew;
        t:=t+2*PI/STEP
     END;
END;

BEGIN
     GraphDriver:=Detect;
     InitGraph(GraphDriver,GraphMode,'h:');
     Stelsel;
     DrawEllipse;
     readln;
END.
