  {DosPlay.inc }
{Turbo Pascal moonblaster dos player routines by Kari Lammassaari 1997}

{The source of mbplayer.mpc needed by this source is originally written
 by REMCO SCHRIJVER and later improvements are from Maarten ter Huurne alias
 KRYTEN/MAYHEM .
 The modifications I made, were msxdos2 support, better OPLL search (from
 library of MsxHandbook), mapper support routines and adaptation to operate
 under DOS.}

{ Read MBPLAYER.TXT for more info . }
{ Needs ints.inc !!!!}


Const 	StartMusic    = $4000;  {Entries to player code. Used internally }
        StopMusic     = $4003;
        PauseMusic    = $4006;  {Not used, same as StopMusic} 
	ContinueMusic = $4009; 
	SearchChips   = $400c;
        MbkLoad       = $400f; {Entry for MModule sample kit loader.}
        MbmLoad       = $4012; {Entry for Moonblaster MBM-file loader}
        MusicInt      = $4015; {Entry for music interrupt}
        ClearFIB      = $4018; {Clear internal FileInfoBlock}
	
	MusicFIB      = $4033; {Internal fib for loading MBM and MBK files}
        Chips         = $401b; {0=MsxAudio,1=MsxMusic,2=both}
        MusicPageNum  = $401D; {Contains the music page number}
        DosErrorFlag  = $4073; {Contains recent dos operation result,Not used.}
        MapperJumpTbl = $4074; {This MUST be updated by pascal code. Mapper.inc
			        returns the required address in JumpTablePtr}
	
	SeePageNum	= $50dd; {Contains the SEE data }
        _InitSEE       	= $50b7; 
        _RemoveSEE     	= $50ba;
   	_SetSFX	        = $50bd;
	_StopSFX       	= $50c0;
	_SEEint		= $50c3;
        _SeeLoad       	= $50c6;
	_SeeVolume	= $50e1;
			 
        IntCode      :Array[0..13] Of Byte = ($db,$fd,$f5,$3e,0,$d3,$fd,
					      $cd,$15,$40,$f1,$d3,$fd,
					      $c9);
      
        Const PlayerName = 'dosplay.mpc';

Var     
    PlayerPageID :Integer;                        {The page id of player page}
    MusicPageID  :Integer;                        {The page id of music page }
    SeePageID	:Integer;
    MBHook	:Array[0..17] Of Byte Absolute $2f00 ;  {Code to access player}
    SEEHook	:Array[0..17] Of Byte Absolute $2f20 ; {Code to acces SEE }
    MbIntNbr,SeeIntNbr :Byte ;

Function InitMbmPlayer:Boolean; {True if succeeded ;}

  Var Dummy     :Boolean;
      MusicPage :Byte;
      SeePage    :Byte;
      a		:Byte;
      sr	:FibType;
  Begin

    FindFirst(PlayerName,0,sr);{Is there player code file available ? }
    If MsxIoResult <> 0 Then
      Begin
        Writeln('Cannot find player file ',PlayerName,' ... Exiting ....');
        Halt;
      End;

    If ( Not MapperSupport(MapperCount) ) Or ( MapperTablePtr^.PagesFree < 3 )
      Then
       Begin
	 Writeln('No memory mapper support or free primary pages ! Exiting ...');
	 InitMbmPlayer := False;
         Exit;
       End
    Else
       Begin
         PlayerPageId := LoadMcFile(PlayerName); {Load player code.}

         WriteMapperPage(PlayerPageId,Addr(JumpTablePtr),MapperJumpTbl,2);
	       {Inform player the mapper service jump table location.}
         
         CallMcPage(PlayerPageId,SearchChips,a,bc,de,hl,ix,iy);  {Search Chips }

         Dummy := AllocateMapperPage(PrimaryMapper,SystemPage,MusicPageId);
         Dummy := AllocateMapperPage(PrimaryMapper,SystemPage,SEEPageId);

   	MusicPage := Hi(MusicPageId);
   	SeePage := Hi(SeePageId);

   	WriteMapperPage(PlayerPageId,Addr(MusicPage),MusicPageNum,1);
	       {Inform player the music page number.}	
   	WriteMapperPage(PlayerPageId,Addr(SEEPage),SeePageNum,1);
	       {Inform player the SEE page number.}	


        InitMbmPlayer := True;
      End;
 End; {InitMbmPlayer }

Procedure LoadMBKFile(FileName:StringType);
  Var a:Byte;
  Begin
     CallMcPage(PlayerPageId,ClearFIB,a,bc,de,hl,ix,iy); {Clear internal FIB. }

     WriteMapperPage(PlayerPageId,Addr(FileName[1]),MusicFib,Length(FileName));
          {Move filename into internal FIB of player.}

     CallMcPage(PlayerPageId,MbkLoad,a,bc,de,hl,ix,iy); 
          {Load sample file into Music Module Audio Ram .}
     {
     ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(ErrorCode),1);
     Writeln('Error Code = ',ErrorCode);
     }
  End;

Procedure LoadMBMFile(FileName:StringType);
  Var a:Byte;
  Begin
     CallMcPage(PlayerPageId,ClearFIB,a,bc,de,hl,ix,iy); {Clear internal FIB. }

     WriteMapperPage(PlayerPageId,Addr(FileName[1]),MusicFib,Length(FileName));
          {Move filename into internal FIB of player.}

     CallMcPage(PlayerPageId,MbmLoad,a,bc,de,hl,ix,iy); 
          {Load MBM-music file into mapper page .}
     {
     ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(ErrorCode),1);
     Writeln('Error Code = ',ErrorCode);
     }
  End;

Function GetMusicChips:Byte; {0=MsxAudio,1=MsxMusic,2=Both,255 = PSG}
 Var Temp :Byte;
 Begin
   ReadMapperPage(PlayerPageId,Chips,Addr(Temp),1);{get Chips}
   GetMusicChips := Temp;
 End;

Procedure StartMbmPlay;
  Var a:Byte;
 Begin
   CallMcPage(PlayerPageId,StartMusic,a,bc,de,hl,ix,iy);  {Start routines}
   Move(IntCode,MBHook,SizeOf(IntCode));           {Set player int code }
   MBHook[4] := Hi(PlayerPageId);                  {PageNum of player code}
   MBIntNbr:=SetInterrupt(Addr(MBHook));
End;

Procedure StopMbmPlay;
  Var a:Byte;
  Begin
    DisableInterrupt(MBIntNbr);
    CallMcPage(PlayerPageId,StopMusic,a,bc,de,hl,ix,iy);{Reset chips}
  End;


Procedure ContinueMbmPlay;
  Var a:Byte;
 Begin
  CallMcPage(PlayerPageId,ContinueMusic,a,bc,de,hl,ix,iy);{Continues playing}
  EnableInterrupt(MbIntNbr);
 End; 

Function GetErrorCode:Byte; { The codes are normal msxdos2 error codes }
 Var Temp :Byte;
 Begin
   ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(Temp),1);{get error code}
   GetErrorCode := Temp;
 End;

Procedure LoadSEEFile(FileName:StringType);
  Var a:Byte;
  Begin
     CallMcPage(PlayerPageId,ClearFIB,a,bc,de,hl,ix,iy); {Clear internal FIB. }

     WriteMapperPage(PlayerPageId,Addr(FileName[1]),MusicFib,Length(FileName));
          {Move filename into internal FIB of player.}

     CallMcPage(PlayerPageId,_SeeLoad,a,bc,de,hl,ix,iy); 
          {Load SEE SFX data file into mapper page .}
     {
     ReadMapperPage(PlayerPageId,DosErrorFlag,Addr(ErrorCode),1);
     Writeln('Error Code = ',ErrorCode);
     }
  End;

Procedure InitSeeSFX;
 Var a :Byte;
 Begin
  CallMcPage(PlayerPageId,_InitSee,a,bc,de,hl,ix,iy);{Install SEE SFX}
   Move(IntCode,SEEHook,SizeOf(IntCode));           {Set SEE int code }
   SEEHook[4] := Hi(PlayerPageId);                  {PageNum of SEE code}
   SEEHook[8] := Lo(_SEEint); SEEHook[9] := Hi(_SEEint);
   SeeIntNbr:=SetInterrupt(Addr(SEEHook));

 End; 

Procedure RemoveSeeSFX;
 Var a :Byte;
 Begin
  CallMcPage(PlayerPageId,_RemoveSee,a,bc,de,hl,ix,iy);{Remove SEE SFX}
  DisableInterrupt(SeeIntNbr);
 End; 

Procedure ContinueSeeSFX;
 Begin
  EnableInterrupt(SeeIntNbr);
 End;

Procedure StopSeeSFX;
 Var a :Byte;
 Begin
  CallMcPage(PlayerPageId,_StopSFX,a,bc,de,hl,ix,iy);{Stop SFX sound}

 End; 

Procedure SetSeeSFXSound(Number,Priority:Byte);
 Var a :Byte;
 Begin
  bc :=  Number +  Priority * 256;
  CallMcPage(PlayerPageId,_SetSFX,a,bc,de,hl,ix,iy);{Install SEE SFX}
 End; 

Procedure SetSeeSfxVolume(Volume:Byte);
  Var Vol :Byte;
  Begin
     WriteMapperPage(PlayerPageId,Addr(Vol),_SeeVolume,1);
  End;   

