{
date.inc by Kari Lammassaari
Contains :

Type DateStrType = String[20]; ( yyy-mm-dd-day_of_the_week)

Function GetDate:DateStrType;
   - uses DOS function #2a (_GDATE)
   - reads clock chip
   - returns string in format 'yyyy-mm-dd weekday'
   - use Tutbo Pascal COPY-operation to clip off unneccessary parts of
     the string returned

Procedure SetDate(DateStr:DateStrType);  ( yyyy-mm-dd )
   - uses DOS function #2b
   - writes clock chip
   - requires 'yyyy-mm-dd' type string as inputs
   - NO error checking
}

Type DateStrType = String[20]; { yyy-mm-dd-day_of_the_week}

Function GetDate:DateStrType;

Const WeekDays :Array[0..6]  Of String[11]
         =('Sunday','Monday','Tuesday','Wednesday','Thursday',
           'Friday','Saturday');

Var Year :Integer ;
    Month,Day,DayOfWeek :Byte;
    YearStr :String[4];
    MonthStr:String[2];
    DayStr  :String[2];

Begin
    Inline (
           $0e/$2a/$cd/5/0/    {get date BDOS}
           $32/DayOfWeek/
           $22/Year/
           $7a/                {ld a,d}
           $32/Month/
           $7b/                {ld a,e}
           $32/Day
           );
    Str(Year,YearStr);
    Str(Month,MonthStr);If Length(MonthStr) = 1 Then MonthStr := '0'+MonthStr;
    Str(Day,DayStr);    If Length(DayStr) = 1 Then DayStr := '0'+DayStr;

    GetDate := YearStr + '-' + MonthStr + '-' +
               DayStr + ' ' + WeekDays[DayOfWeek] ;
End;  {GetDate}


Procedure SetDate(DateStr:DateStrType);  { yyyy-mm-dd }


Var Year,Virhe :Integer ;
    Month,Day  :Integer ;

Begin
     Val(Copy(DateStr,1,4),Year,Virhe);
     Val(Copy(DateStr,6,2),Month,Virhe);
     Val(Copy(DateStr,9,2),Day,Virhe);

     Inline (
            $2a/year/         {ld hl,(year)}
            $3a/Month/
            $57/              {ld d,a}
            $3a/day/
            $5f/              {ld e,a}
            $0e/$2b/$cd/5/0   {set date BDOS}
            );
End; {setdate}
