{COPY_SCR.inc by K.Lammassaari/ACADEMY 1997}
{Copies data from color bus to video RAM in screen modes 5 - 8 }

{REM NO ERROR CHECKING, Incorect parameter values cause system crash, because
 code drops to the error routine of the BASIC interpreter.
 Define used parameter  values as constants. }

{Syntax:  COPY_SCREEN(mode)

         <mode> = Range is 0-1
                  0 = one field of signals are digitized and written to
                      the display page
                  1 = two successive fields are written to the display page - 1
                      and the dispaly page. So the dispaly page should be an
                      odd page ,when mode 1 is selected.
}

{Uses BASIC ROM routines. }
{Descrition :
  - The memory $f55d - $f5ad is saved to heap.
  - The code is moved to $f580 and patched to use MSXDOS ENASLT-routine, which
    operates from page 3 and allows to handle the page 0 .(BIOS ENASLT crashes
    if used to turn page 0.)
  - parameters are pathced to the BASIC line (the parameter part) at &f55d.
  - HL is set to point at $f55d, the code is called and the memory is
    restored from stack.
 }

Procedure COPY_SCREEN (mode:Byte);

 Const Code :Array[0..42] Of Byte =
         ($f3,
          $3A,$C1,$FC,$F5,$21,$0,$0,$CD,$24,$0,$F1,$26,$40,$CD,$24,$0,
          $21,$5d,$F5,$7e,$23,$CD,$2f,$7c,
          $3A,$41,$F3,$26,$0,$CD,$24,$0,$3A,$42,$F3,$26,$40,$CD,$24,$0,$FB,$c9
         );
        BasicLine :Array[0..5] Of Byte=( $c5,$20,$11,$00,$00,$00);

  Var i  :Byte;
      c  :Array[0..42] of Byte Absolute $f580 ;
      b  :Array[0..5] Of Byte Absolute $f55d;
      store :^byte;
      EnasltAddr :Integer Absolute $0025;
      Patch      :Integer Absolute $f59f; {$f59d+2; }
 Begin
   Inline($f3);
   Getmem(Store,90);
   Move(b,Store^,90);
   Move(code,c,43);
   Patch := EnaSltAddr;
   Move(BasicLine,b,6);
   b[2] := $11 + Mode;
   Inline ($cd/$80/$f5  );
   Move(Store^,b,90);
   FreeMem(Store,90);
 End;


