{       MSXDOS 2.2 System DOS calls. Juan Salas. Oct 1990
  This is a short version of the file DOS22.LIB. It just contains
  the tools used in the XDOS program.                                   }

const
    Arguments: RunString = '';

type
  FileInfoBlock= array[0..63] of byte;
  Filename     = string[13];
  NameStr      = string[8];
  ExtStr       = string[3];
  DateStr      = string[8];
  TimeStr      = string[6];
  DriveStr     = string[2];
  AttributeStr = string[5];
  EnvNameStr   = string[10];
  PathStr      = string[66];

var
  Yes          : Boolean;
  orgX, orgY,
  WindowMem,
  WindowSav,
  DosError     : Byte;
  EnvProg      : RunString;


Procedure FindFirst( path  : PathStr;
                     attr  : byte;
                     VAR sr: FileInfoBlock);
begin
  Path:=Path+chr(0);
  inline($0E/$40/$11/Path+1/$3A/attr/$47/$DD/$2A/Sr/$CD/$05/0/$32/DosError);
end;


Procedure FindNext( VAR sr: FileInfoBlock);
begin
  inline($0E/$41/$DD/$2A/Sr/$CD/$05/0/$32/DosError);
end;


Function GetFname( sr: FileInfoBlock): FileName;
var I : byte;
    S : Filename;
begin
  S:='             ';
  for i:= 1 to 13 do
    S[i]:= chr(sr[i]);
  GetFname:= s;
end;

Function GetFext( name: Filename): ExtStr;
var p : byte;
    S : ExtStr;
begin
  S:='';
  P:=pos('.',name);
  if P > 0 then s:= name[p+1]+ name[p+2]+ name[p+3];
  GetfExt:= s;
end;

Function ParseName( s: Filename): Filename;
var buffer : Filename;
begin
  buffer:='             ';
  inline($0E/$5C/$11/s+1/$21/buffer+1/$CD/$05/0);
  insert('.',buffer,9);
  Parsename:=buffer
end;

Function GetFsize( sr: FileInfoBlock): real;
var temp: real;
begin
 temp:= (sr[24] * 256.0 + sr[23]) * 65536.0 + sr[22] * 256.0 + sr[21];
 GetFsize:=temp;
end;

Function GetFdate( sr: FileInfoBlock): NameStr;
var dt,mt,an : byte;
    ds,ms,as : string[2];
begin
 dt:= sr[17] and $1F;
 mt:= ((sr[17] and $E0 ) shr 5) + ((sr[18] and 1) shl 3);
 an:= ((sr[18] and $FE ) shr 1) + 80;
 str(dt:2,ds); str(mt:2,ms); str(an:2,as);
 if ds[1]=' ' then ds[1]:='0';
 if ms[1]=' ' then ms[1]:='0';
 if as[1]=' ' then as[1]:='0';
 GetFdate:= as+'/'+ms+'/'+ds;
end;


Function GetFtime(sr : FileInfoBlock): NameStr;
var m,h : integer;
    ms,hs: string[2];
    t: char;
begin
 h:=(sr[16] and $F8) shr 3;
   if h > 11 then begin
     h:= h - 12;
     t:= 'p'
     end
   else t:= 'a';
 m:=((sr[16] and 7) shl 3 ) + ((sr[15] and $E0) shr 5);
 str(h:2,hs); str(m:2,ms);
 if ms[1]=' ' then ms[1]:='0';
 getFtime:= hs+':'+ms+t
end;

Function ExpandFAttr( B: byte): AttributeStr;
var temp: attributeStr;
begin
temp:='.... ';
 if (b and 4)  > 0 then temp[1]:='s';
 if (b and 2)  > 0 then temp[2]:='h';
 if (b and 1)  > 0 then temp[3]:='r';
 if (b and 32) > 0 then temp[4]:='a';
 ExpandFAttr:=temp
end;

Function GetFAttr(sr : FileInfoBlock): Byte;
begin
  GetFAttr:=sr[14];
end;


Procedure ChDrv(drive: byte);
begin
   DosError:= Bdos($0E, drive)
end;


procedure Chdir(s: PathStr );
begin
 s:=s+chr(0);
 inline($0E/$5A/$11/s+1/$CD/$05/0/$32/DosError);
end;


Function GetEnv(envVar: EnvNameStr): RunString;
var temp,buffer: RunString;
    i          : byte;
begin
  temp:='';
  buffer:='';
  envVar:=envVar+chr(0);
  inline($0E/$6B/$21/envVar+1/$11/buffer+1/$06/$FF/$CD/$05/0/$32/DosError);
  if DosError= 0 then begin
    i:=1;
    while buffer[i] <> chr(0) do begin
      temp:=temp + buffer[i];
      i:=succ(i)
      end
    end;
  GetEnv:=temp
end;


Procedure SetEnv (envVar: EnvNameStr; path: RunString);
begin
  envVar:=envVar+chr(0);
  path  :=path  +chr(0);
  inline($0E/$6C/$21/envVar+1/$11/path+1/$CD/$05/$00/$32/DosError)
end;


type TD_Str18 = string[18];                            { Time and Date string }
const TimeStg : TD_Str18 = 'DD.MM.YY  HH:MM:SS';
Function PTime : TD_Str18;
Begin Inline
    ($0E/$2A/$CD/$05/$00/
     $E5/$01/TimeStg+1/$7B/$CD/*+$2B/$03/$7A/$CD/*+$26/$03/$E1/$7D/
     $DE/$6C/$CD/*+$1E/$03/$03/$C5/
     $0E/$2C/$CD/$05/$00/$C1/$7C/$E5/$CD/*+$10/$03/$E1/$7D/
     $CD/*+$0A/$03/$7A/$CD/*+$05/$C3/*+$1D/
     $26/$00/$6F/$DE/$0A/$38/$03/$24/$18/$F8/
     $7C/$FE/$0A/$38/$02/$DE/$0A/$C6/$30/$02/$03/$7D/$C6/$30/$02/$03/
     $C9);
  PTime := TimeStg
end;


Function Printer_Ok: Boolean;
var ready: byte;
Begin Inline
  ($DD/$21/$A8/$00/$CD/_CALROM/$32/ready);
  Printer_Ok := (ready<>0)
end;


Procedure Hardcopy;
Begin
  If Printer_Ok then begin Inline
    ($3A/$17/$F4/$B7/$28/$0F/$21/$00/$00/$22/*+$21/$22/*+$1F/
     $21/$3E/$20/$22/*+$1C/
     $11/$7F/$07/$21/$00/$00/
     $CD/*+$2B/$06/$50/
     $F7/$00/$4A/$00/$FE/$20/$30/$09/$F5/$3E/$01/$CD/*+$22/$F1/$C6/$40/
     $FE/$F1/$38/$02/$3E/$FE/
     $CD/*+$16/$7D/$BB/$20/$04/$7C/$BA/$28/$11/
     $23/$10/$DB/$18/$D4/
     $3E/$0D/$CD/*+$04/$3E/$0A/
     $F7/$00/$A5/$00/$C9/
     $CD/*-$0D)
  end
end;


Procedure DoWindow(nbr: byte);
begin
  case nbr of
    0: window(2,2,79,21);
    1: window(2,23,79,24);
    2: window(24,2,79,21);
    3: window(2,9,21,21);
    4: window(2,2,21,6)
  end;
  WindowMem := nbr
end;


Function WaitKey: char;
var InKey : char;
Begin
  if (WindowMem > 0) then begin
    orgX := WhereX; orgY := WhereY;
    WindowSav := WindowMem;
    DoWindow(4);
    while not KeyPressed do begin GotoXY(2,1); Write(PTime) end;
    DoWindow(WindowSav);
    GotoXY(orgX, orgY)
    end
  else repeat until KeyPressed;
  read(Kbd, InKey);
  if Inkey = #16 then HardCopy;
  WaitKey := InKey
end;


Procedure YesNo;
var c: char;
    yn: boolean;
begin
  yn:= false;
  repeat
    c:= upcase(WaitKey);
    if (c in ['Y','N']) then begin
      yn:= True;
      if (c = 'Y') then Yes:=True else Yes:=false
    end
  until yn
end;


Procedure Wait_Msg;
Begin
  DoWindow(2);GotoXY(3,1);
  HighVideo; Write('  please wait... '); NormVideo; ClrEol;
end;


Procedure ESC_Msg;
Begin
  GotoXY(65,2);
  Write('ESC=Cancel')
end;


Procedure Key_Msg;
Begin
  Gotoxy(62,2);
  Write('Press a key...')
end;


Procedure HiLi_Msg;
Begin
  Write('  Highlighted  Tagged')
end;


Function Ask_HiLi: char;
var InKey: char;
Begin
  HiLi_Msg; ESC_Msg;
  repeat InKey:= UpCase(WaitKey) until (InKey in [#$1B,'H','T']);
  Ask_HiLi:= InKey
end;


Procedure WriteLogo;
Begin
  gotoxy(1,3);
  Write(XversNr);
  write(Logo)
end;


Function UpperCase (Strg: PathStr): PathStr;
var
  i: byte;
Begin
  for i := 1 to Length(Strg) do Strg[i]:= UpCase(Strg[i]);
  UpperCase := Strg
end;
