  {
    Module     : INDMSXDIR.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : operating system dependent procedures MSX-DOS

    Creation   : 29-aug-1989

    Update     : 

    Data       : 


    Procedures : 

                   GetDirectory (directory : fileptr;
                                 disk      : diskptr);
                     returns directory from diskette in
                     linked list pointed at by fileptr,
                     updates disk info in cell pointed at with diskptr

  }


procedure GetDirectory (var directory : fileptr;
                        disk      : diskptr) ;

  {
    returns directory from diskette in
    linked list pointed at by fileptr,
    updates disk info in cell pointed at with diskptr
  }


const

  setDMA      =  26;
  searchFirst =  17;
  searchNext  =  18;

var

  FCB             : array[0..35] of char;
  directorysector : array[0..3,0..31] of char;
  index,
  directorycode   : integer;
  workdirectory,
  workfile        : fileptr;
  linecount,
  filecount,
  total           : integer  ;
  found           : boolean ;
  siz             : real ;

begin

  directory := nil ;
  FCB := ' ???????????                        ';
  for index:=12 to 35 do FCB[index]:=chr(0);
  FCB[0] := chr(1) ;
  bdos(setDMA,addr(directorysector));
  directorycode:=bdos(searchfirst,addr(FCB));
  if directorycode=255
    then
      writeln(ind_msg_nofiles)
    else
      while directorycode < 255 do
        begin
          new(workfile) ;
          with workfile^ do
            begin
              for index := 1 to 3 do
                diskname[index] := disk^.diskname[index] ;
              for index := 1 to 8 do
                filename[index] := chr(ord(directorysector[directorycode,index])
                                       and 127);
              for index := 9 to 11 do
                filetype[index-8] :=
                  chr(ord(directorysector[directorycode,index]) and 127);
              for index := 1 to 14 do
                if (filespec[index] < ' ') or (filespec[index] = chr(127))
                  then
                    filespec[index] := ' ' ;
               { get date bytes }
               date1 := ord(directorysector[directorycode,25]) ;
               date2 := ord(directorysector[directorycode,26]) ;
               
               siz := ( ord(directorysector[directorycode,29]) +
                        ord(directorysector[directorycode,30]) *256.0 +
                        ord(directorysector[directorycode,31]) * 65536.0 +
                        1023.99) / 1024 ;
               size := trunc(siz) ;
            end;
          workfile^.nextfile := nil ;
          if directory = nil  { empty list }
            then
              directory := workfile
            else                { insert at end if not present }
              begin
                found := false ;
                workdirectory := directory ;
                while workdirectory^.nextfile <> nil do
                  begin
                    found := found or
                     (workdirectory^.filespec = workfile^.filespec);
                    workdirectory := workdirectory^.nextfile
                  end ;
                if not found
                  then
                    workdirectory^.nextfile := workfile ;
              end ;
          directorycode:=bdos(searchnext);
        end;
    filecount := 0 ;
    linecount := 0 ;
    total := 0 ;
    workfile := directory ;
    while workfile <> nil do
      begin
        if linecount > 0
          then write(' ',ind_msg_dirsep,' ') ;
        with workfile^ do
          begin
            write(filename,ind_msg_dot,filetype,' ',size:3,ind_msg_kbytes) ;
            total := total + size ;
          end ;
        filecount := filecount + 1 ;
        linecount := linecount + 1 ;
        if (linecount mod MaxFilesLine ) = 0
          then
            begin
              writeln ;
              linecount := 0 ;
            end ;
        workfile := workfile^.nextfile ;
      end ;
    writeln ;
    with disk^ do
      begin
        totalsize := total ;
        count := filecount ;
        writeln ;
        writeln(count,ind_msg_files:3,ind_msg_total,totalsize:3,ind_msg_kbytes)
      end ;

  end ; { GetDirectory }

