   {
    Module     : INDMS.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : operating system dependent procedures/functions VMS

    Creation   :  5-jan-1989

    Update     :  1-feb-1989 Recursive directory search
    Update     : 18-aug-1989 Date included, changed record format
    Update     : 29-aug-1989 Translate_date
    Update     :  7-sep-1989 check io in writing index database

    Data       :


    Procedures :

                   Position(searchstring, targetstring) : integer
                     performs Turbo Pascal POS function


                 Operating system dependent

                   Get_Char ;
                     returns single character from terminal without echo

                   Space : real ;
                      returns free memory space

                   Room : boolean
                     returns true if enough memory available

                   GetDirectory (directory : fileptr;
                                 disk      : diskptr);
                     returns directory from diskette in
                     linked list pointed at by fileptr,
                     updates disk info in cell pointed at with diskptr

                   WriteIndexDirectory
                     show directory of index files

                   ResetDisks
                     resets disk system

                   Open_read(file_ident,filespec,io_result)
                     opens disk file for read, combination
                     of assign and reset.
                     io_result = 0 if success

                   Open_write(file_ident,filespec,io_result)
                     opens disk file for write, combination
                     of assign and reset.
                     io_result = 0 if success

                   Close_file (file_ident) ;
                     closes file, no error reporting

                   Erase(file_ident,filespec,io_result)
                     erases diskfile
                     Expects file to be open.

                   Check_Parameter
                     checks for index file specification in command line

                   Translate_Date (date1,date2: byte;
                            var day,month, year : integer ) ;

                     translates MS-DOS encoded date info in (date2, date1)
                     DD-MMM-YYYY format in day,month,year
                     if day = 0 then no valid date   

  }


{ Turbo Pascal emulation }

{$V-}
function position(searchstring : string80 ;
                  targetstring : string80  ) : integer ;

  {
    performs Turbo Pascal POS function
    searches for first occurrance of search string in targetstring
    and returns position as function result
  }

  begin

    position := pos (searchstring, targetstring) ;

  end ; { position }
{$V+}

{ operating system dependent procedures/functions }

function Get_char : char ;

  {
    Get_Char ;
    returns single character from terminal without echo
  }

  var

    ch : char ;

  begin

    read(kbd,ch) ;
    get_char := ch ; 

  end ; { Get_Char }

{$V-}
procedure Show_line(line : string80) ;

  begin

    write(line) ;

  end ; { Show_line }
{$V+}

procedure Open_read(var file_ident : text ;
                    filespec       : filename ;
                    var io_result  : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    {$I-}
    assign(file_ident,filespec) ;

    io_result := IOresult ;
    if io_result = 0
      then
        begin
          reset(file_ident) ;
          io_result := IOresult ;
        end ;
    {$I+}

  end ; { Open_read }

procedure Open_write(var file_ident   : text ;
                     filespec     : filename ;
                     var io_result : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    {$I-}
    assign(file_ident,filespec) ;

    io_result := IOresult ;
    if io_result = 0
      then
        begin
          rewrite(file_ident) ;
          io_result := IOresult ;
        end ;
    {$I+}

  end ; { Open_write }

procedure Close_file(var file_ident : text ) ;
  {
    closes diskfile,
    no error reporting
  }

  begin

    {$I-}
    close(file_ident) ;
    {$I+}

  end ; { Close_file }

procedure Erase_file(var file_ident : text ;
                     filespec       : filename ) ;
  {
    erases diskfile
    Expects file to be open.
  }

  begin

    {$I-}
    erase(file_ident) ;
    {$I+}

  end ; { Erase_file }

function Space : real ;

  { returns free heap space }
  
  begin

      if memavail < 0
      then
        space := ((65536.0+MemAvail)/64)
      else
        space := (Memavail/64) ;
    
  end ; { Space }

function Room : boolean ;

  {
    returns true if enough memory available 
    to insert new directory information
    For VMS always true
  }

  begin

    room := true ;

 end ; { Room }

procedure ResetDisks ;

  { reset disk system, no function for MS }

  begin

  end ; { ResetDisks }

procedure GetDirectory (var directory : fileptr;
                        disk      : diskptr) ;

  {
    returns directory from diskette in
    linked list pointed at by fileptr,
    updates disk info in cell pointed at with diskptr
  }

  type

    Env_String = string[255];


  var

    dta : dtarec;
    regs : registers;
    find : fstring;
    low_size, high_size : real ;
    workdirectory,
    workfile : fileptr ;

    index,
    directorycode   : integer;
    dot,
    linecount,
    filecount,
    total           : integer  ;

    index_drive : env_string ;

function get_filename (name : fname) : fstring ;

  var

    i : integer;
    out : fstring;

  begin

    out := '';
    i := 1;

    while (i <= 12) and (name [i] <> chr (0)) do
      begin
        out := out + chr(ord(name [i]) and 127 ) ;
        i := i + 1
      end;

    get_filename := out;

  end ; { get_filename }

  procedure find_files (search : fstring);

    var

      dta : dtarec;
      regs : registers;
      find : fstring;
      low_size, high_size : real ;
      fname : fstring ;
      new_search : fstring ;

    procedure add_to_list (dta : dtarec ) ;

      {
        add current file in dta to end of linked list pointed
        at by directory and show at terminal
      }

      begin

        new(workfile) ;
        with workfile^ do
          begin
            for index := 1 to 14 do
                  filespec[index] := ' ' ;
            for index := 1 to 3 do
              diskname[index] := disk^.diskname[index] ;

            dot := pos(ind_msg_dot,dta.name) ;
            index := 1 ;
            while (index <= 8) and ( dta.name[index] <> chr(0))
                               and ( dta.name[index] <> ind_msg_dot) do
              begin
                filename[index] := chr(ord(dta.name[index]) and 127) ;
                if (filename[index] < ' ') or (filename[index] = chr(127))
                  then
                    filename[index] := ' ' ;
                index := index + 1
              end ;
            if (dot > 0) and (dot = index)
              then
                begin
                  index := dot + 1 ;
                  dot := 1 ;
                  while (dot <= 3) and (dta.name[index] <> chr(0)) do
                    begin
                      filetype[dot] := chr(ord(dta.name[index]) and 127) ;
                      if (filetype[dot] < ' ') or (filetype[dot] = chr(127))
                        then
                          filetype[dot] := ' ' ;
                      index := index + 1 ;
                      dot := dot + 1 ;
                    end ;
                end ;

            if dta.size[1] < 0
              then
                low_size := dta.size[1] + 65536.0
              else
                low_size := dta.size[1] ;
            if dta.size[2] < 0
              then
                high_size := dta.size[2] + 65536.0
              else
                high_size := dta.size[2] ;
           date1 := dta.date1 ;
           date2 := dta.date2 ;

            size :=
              trunc((high_size * 64.0) + ((low_size + 1023.9)/ 1024.0)) ;

            total := total + size ;

            if linecount > 0
              then write(' ',ind_msg_dirsep,' ') ;

            write(filename,ind_msg_dot,filetype,' ',size:3,ind_msg_kbytes) ;
            filecount := filecount + 1 ;
            linecount := linecount + 1 ;
            if linecount = MaxFilesLine
              then
                begin
                  writeln ;
                  linecount := 0 ;
                end ;
          end;
        workfile^.nextfile := nil ;
        if directory = nil
          then
            directory := workfile
          else
            begin
              workdirectory := directory ;
              while workdirectory^.nextfile <> nil do
                workdirectory := workdirectory^.nextfile ;
              workdirectory^.nextfile := workfile ;
            end ;

    end ; { add_to_list }

  begin { main find_files }

    regs.ax := $1a00;      { set dta to your dta-record }
    regs.dx := ofs (dta);
    regs.ds := seg (dta);
    msdos (regs);

    find := search + '\*.*' + chr (0);
    regs.ax := $4e00;      { find first }
    regs.cx := $10 ;       { attribute for directory entries and normal files}
    regs.dx := ofs (find [1]);
    regs.ds := seg (find [1]);
    msdos (regs);

    while (regs.flags and $0001) = 0 do
      begin
        fname := get_filename(dta.name) ;
        if fname[1] <> '.'
          then
            begin
              if dta.attr = chr($10)
                then
                  begin
                    writeln ;
                    if linecount > 0
                      then
                        begin
                          writeln ;
                          linecount := 0 ;
                        end ;
                    writeln(fname,'.<dir>') ;
                    writeln ;
                    if fname[1] <> '.'
                      then
                        begin
                          new_search := search + '\' + fname ;
                          find_files(new_search) ;
                          regs.ax := $1a00;      { restore dta address }
                          regs.dx := ofs (dta);
                          regs.ds := seg (dta);
                          msdos(regs) ;
                        end
                  end
                else
                  begin
                    add_to_list(dta) ;
                  end ;
            end ;

        regs.ax := $4f00;  { find next }
        msdos(regs);
      end;

  end ; { find_files }

{ File: GETENV.INC }
{
** The following function will look for an environment variable
** and return it's definition if found.  If the variable is not
** found, then the returned definition variable will be empty.
** Compiled and run with Turbo Pascal v2.0 on an IBM PC/XT running
** PC-DOS v2.1.
**
** This code is entered into the Public Domain for free use by all.
** George B. Smith, March 15, 1985. }

procedure GetEnvParam(name: Env_String ;  { environment variable to search for }
                  var  param : env_String ); { returned definition }


var
    envseg: integer;     { segment address of environment from PSP }
    ei: integer;         { index into environment }
    envname: Env_String;    { current environment string name }
    ch: char;            { current character from environment }
    found: boolean;      { if true then environment name was found }

begin
    ei := 0;      { Initialize environment index value }
    envseg := MemW[CSeg:$2C];        { get address of environment from PSP }
    found := FALSE;
    ch := chr(Mem[envseg:ei]);       { get first char from environment }
    while (ch <> chr(0)) and (not found) do begin
        envname := '';
        while (ch <> '=') AND (Length(EnvName) < 255)
           do begin     { get environment string name }
            envname := envname + ch;
            ei := ei + 1;
            ch := chr(Mem[envseg:ei])
        end;
        ei := ei + 1;                { skip over the EQUALS }
        param := '';
        ch := chr(Mem[envseg:ei]);
        while ch <> chr(0) do begin  { get environment string parameter }
            param := param + ch;
            ei := ei + 1;
            ch := chr(Mem[envseg:ei])
        end;
        if name = envname then       { check for a match }
            found := TRUE;
        ei := ei + 1;
        ch := chr(Mem[envseg:ei])
    end;
    if not found then
        param := ''

end; { Procedure GetEnvParam }



  begin { main GetDirectory }


    directory := nil ;
    filecount := 0 ;
    linecount := 0 ;
    total := 0 ;
    GetEnvParam('INDEX',index_drive) ;
    if length(index_drive) = 0
      then
        find := ind_msg_def
     else
       find := index_drive ;
    find_files (find) ;
    writeln ;
    with disk^ do
      begin
        totalsize := total ;
        count := filecount ;
        writeln ;
        writeln(count,ind_msg_files,ind_msg_total,totalsize:3,ind_msg_kbytes)
      end ;

  end ; { GetDirectory }


procedure WriteIndexDirectory ;

  {
    shows directory of files with specification in name
  }

type

    fstring = string[80] ;


function get_filename (name : fname) : fstring ;

  var


    i : integer;
    out : fstring;

  begin

    out := '';
    i := 1;

    while (i <= 12) and (name [i] <> chr (0)) do
      begin
        out := out + name [i];
        i := i + 1
      end;

    get_filename := out;

  end ; { get_filename }

procedure find_files (search : fstring);

  var

    dta : dtarec;
    regs : registers;
    find : fstring;
    low_size, high_size : real ;

  begin

    regs.ax := $1a00;      { set dta to your dta-record }
    regs.dx := ofs (dta);
    regs.ds := seg (dta);
    msdos (regs);

    find := search + chr (0);
    regs.ax := $4e00;      { find first }
    regs.dx := ofs (find [1]);
    regs.ds := seg (find [1]);
    regs.cx := 0 ;         { only visible files attribute }
    msdos (regs);

    while regs.flags and $0001 = 0 do
      begin
        write(get_filename (dta.name):12 ) ;

        if dta.size[1] < 0
          then
            low_size := dta.size[1] + 65536.0
          else
            low_size := dta.size[1] ;
        if dta.size[2] < 0
          then
            high_size := dta.size[2] + 65536.0
          else
            high_size := dta.size[2] ;
        writeln(' ',((high_size * 64) + (low_size / 1024)):3:0,ind_msg_kbytes) ;

        regs.ax := $4f00;  { find next }
        msdos(regs);
      end;

  end ; { find_file }

  begin { main writeIndexDirectory }

    find_files (ind_msg_defind);

  end ; { WriteIndexDirectory }

procedure Get_commandline(var name : string20) ;

  { looks for commandline, returns in name, empty string if none }

  var

    io_result,
    status  : integer ;

  begin

    if ParamCount > 0
      then
        name := Paramstr(1)
      else
        name := '' ;

  end ; { Get_Commandline }

procedure Translate_Date (date1,date2: byte;
                          var day,month, year : integer ) ;

  { translates MS-DOS encoded date info in (date2, date1)
    (YYYYYYYM, MMMDDDDD)
    DD-MMM-YYYY format in day,month,year
    if day = 0 then no valid date                         }

  begin

    day   := date1 and 31 ;
    year  := (date2 div 2) + 1980 ;
    month := (date1 div 32 ) + 8 * (date2 and 1) 

  end ; { Translate_date }


function write_filerec_fail(filespec    : filespec_type ;
                            size        : integer ;
                            date1,date2 : byte ) : boolean ;
  
   { writes file record to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,filespec,' ',size:1,
            ' ',date1:1,' ',date2:1);
    write_filerec_fail := (IOresult <> 0) ;
    {$I+}

  end ; { write_filerec_fail }


function write_diskrec_fail(diskname   : string3 ;
                            totalsize  : integer ;
                            count      : integer ;
                            diskdescr  : string40 ) : boolean ;

   { writes disk record to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,diskname,' ',totalsize:1,' ',count:1,' ',diskdescr);
    write_diskrec_fail := (IOresult <> 0) ;
    {$I+}

  end ; { write_diskrec_fail }


function write_header_fail(TotalDisks : integer ) : boolean ;

   { writes header records to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,ind_msg_progname,ind_msg_version) ;
    if IOresult <> 0
      then
        write_header_fail := true
      else
        begin
          writeln(indexf,TotalDisks:1) ;
          write_header_fail := (IOresult <> 0) ;
        end ;
    {$I+}

  end ; { write_header_fail }

{ end INDMS.INC }
