  {

    Module     : INDMAIN.INC

    Facility   : INDEX.PAS V2.1

    Author     : H.J.C. Otten

    Purpose    : data initialisation

    Creation   : 5-jan-1989

    Update     : 16-feb-1989

    Data       : n.a

    Modules in INDEX package

                 INDCONST .INC  constants
                 INDMSGxy .INC  messages, language dependent
                 INDTYPE  .INC  type definitions
                 INDTYPzzz.INC  operating system/language type definitions
                 INDVAR   .INC  global variable declarations
                 INDzzz   .INC  operating system dependent  procedures/functions
                 INDMAIN  .INC  initialization code
                 INDEX    .INC  general procedures/functions
                 INDDIR   .INC  disk directory procedures/functions 
                 INDPRNT  .INC  print related procedures/functions
                 INDSRCH  .INC  search procedures/functions
                 INDFILE  .INC  index file procedures/functions
   
                   x = language indicator
                            x = E for english
                            x = D for dutch

                   y = terminal width indicator
                            y = 4 for 40 columns
                            y = 8 for 80 columns

                   zzz = operating system specification
 
                            zzz = VMS for VAX/VMS with VAX Pascal
                            zzz = CPM for CP/M 
                            zzz = MSX for MSX-DOS 
                            zzz = MS  for MS-DOS

    Procedures : 
                 Init_data
                   inits data structures with default values,
                   creates empty link lists

                 Check_parameter 
                   looks for optional index file spec and
                   if found adds to index

                 MainLoop ;
                   displays menu
                   prompts for option
  }

procedure Init_data ;

  { inits data structures with default values,
    creates empty link lists

  }

  var
  
    count : integer ;

  begin

    TotalDisks := 0 ;
    TotalFiles := 0 ;
    mainfile := ' ' ;

    new(rootfile) ;
    new(filesentinel) ;
    for count := 1 to length_filespec  do
      filesentinel^.filespec[count] := chr(255) ;

    rootfile^.nextfile := filesentinel ;
    new(rootdisk);
    new(disksentinel);
    rootdisk^.nextdisk := disksentinel ;
    saved := true ;

  end ; { Init_data }

procedure Check_Parameter ;

  { check if argument passed on command line
    if argument present    
      try to use argument as name of index file 
      add index to database

  }

  var

    count,
    io_result : integer ;
    name      : filename ;

  begin
  
    get_commandline(name) ;
    if length(name) > 0
      then
        begin
          for count := 1 to length(name) do
            name[count] := Upcase(name[count]) ;
          if  position(ind_msg_dot,name) = 0
            then
              name := name + ind_msg_dot + ind_msg_indtype ;
          open_read(indexf,name,io_result) ;
          if io_result = 0
            then
              begin
                mainfile := name ;
                MergeFile ;
                saved := true ;
              end
            else
              open_error ;
          close_file(indexf) ;
          ReturnToMenu
        end ;

  end ; { Check_parameter }


procedure MainLoop ;

  {
    displays menu
    prompts for option
  }

  var

    YesOrNo : char ;

  begin

    ResetDisks ;

    repeat
      MainMenu( choice) ;
      case choice of
        ind_msg_opt_sfile  : SearchFile ;
        ind_msg_opt_sdisk  : Searchdisk ;
        ind_msg_opt_printd : PrintIndex(choice) ;
        ind_msg_opt_printf : PrintIndex(choice) ;
        ind_msg_opt_add    : if not vms 
                               then
                                 AddNewDisk ;
        ind_msg_opt_remove : DeleteDisk ;
        ind_msg_opt_new    : NewIndex   ;
        ind_msg_opt_merge  : MergeIndex ;
        ind_msg_opt_write  : WriteIndex ;
        ind_msg_opt_help   : HelpIndex  ;
        ind_msg_opt_exit   : if not saved
                               then
                                 begin
                                   Prompt_YesOrNo (ind_msg_not_saved,
                                                   YesOrNo) ;
                                   if YesOrNo = ind_msg_NoChar
                                     then
                                       choice := ind_msg_NoChar ;
                                 end ;
      end ;
     until (choice = ind_msg_opt_exit) ;

  end ; { MainLoop }

{ end INDMAIN.INC }
