  {

    Module     : INDEX.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : definition of global variables, general purpose routines

    Creation   :  5-jan-1989

    Update     :  3-feb-1989 saved boolean
    Update     : 24-aug-1989 translate_date

    Data       : n.a.

    Procedures : 
                 InsertFileInList(var fileToInsert : fileptr) ;
                   insert filenode FileToInsert into file linked list
                   alphabetically sorted on name + type + diskname

                 InsertDiskInlist(var DiskToInsert : diskptr; 
                                  var found : boolean) ;) ;
                   insert disknode DiskToInsert into disk linked list
                   alphabetically sorted on diskname
                 
                 DeleteWholeDisk (disk : diskptr; var found : boolean) ;
                   delete all information belonging to disk^.diskname 

                 IndexDiskInDrive ;
                   display message to place index disk in drive
                   and wait for return 

                 Continue (cont_msg : string) ;
                   prompts message to continue
                   and awaits CR 

                 Prompt_Continue (cont_char : char) ;
                   prompts message to continue
                   and awaits either CR or ind_msg_opt_exit

                 ReturnToMenu ;
                   display message to return to menu
                   and wait for return 

                 Prompt_YesOrNo (var YesOrNo : char ) ;
                   reads from terminal keystrokes until
                   ind_msg_YesChar or ind_msg_NoChar entered
                   echoes YesChar or Nochar
  
                 MainMenu
                   show main menu and
                   prompt for valid choice of option
 

  }

procedure Insert_in_List(var f, f1,f2 : fileptr) ;

  begin

    while f1^.filespec < f^.filespec do
      begin
        f2 := f1 ;
        f1 := f2^.nextfile
      end ;
    f^.nextfile := f1 ;
    f2^.nextfile := f ;
    f2 := f ;
    saved := false ;

  end ; { Insert_in_list }

procedure InsertfileInList (FileToInsert : fileptr) ;

  {
    insert filenode FileToInsert into file linked list
    alphabetically sorted on name + type + diskname
    algorithm based upon
    algorithm 4.25 N.Wirth Alg. + Data.=Programs 
 }

  var 

    f1,f2 : fileptr ;

  begin

    f2 := rootfile ;
    f1 := f2^.nextfile ;
    Insert_in_List(FileToInsert,f1,f2) ;

  end ; { InsertFileInlist }


procedure InsertDiskInList (var DiskToInsert : diskptr ; var found : boolean) ;

  { 
    insert disknode DiskToInsert into disk linked list
    alphabetically sorted on diskname
    algorithm based upon
    algorithm 4.25 N.Wirth Alg. + Data.=Programs }

  var 

    d1,d2 : diskptr ;

  begin

    d2 := rootdisk ;
    d1 := d2^.nextdisk ;
    disksentinel^.diskname := DiskToInsert^.diskname ;
    while d1^.diskname < DiskToInsert^.diskname do
      begin
        d2 := d1 ; 
        d1 := d2^.nextdisk ;
      end ;
    found :=  (d1 <> disksentinel) and (d1^.diskname = DiskToInsert^.diskname);
    if (not found) and room
      then
        begin
          DiskToInsert^.nextdisk := d1 ;
          d2^.nextdisk := DiskToInsert ;
        end ;
    saved := false ;

  end ; { InsertDiskInlist }

procedure DeleteWholeDisk (disk : diskptr; var found : boolean) ;

  { 
    delete all information belonging to disk^.diskname 
  }

  var

    f1,f2  : fileptr ;
    d1,d2  : diskptr ;
    result : integer ;

  begin

    { remove from disklist }
    d2 := rootdisk ;
    d1 := d2^.nextdisk ;
    disksentinel^.diskname := disk^.diskname ;
    while d1^.diskname < disk^.diskname do
      begin
        d2 := d1 ; d1 := d2^.nextdisk
      end ;
    found := false ;
    if (d1 <> disksentinel) and (d1^.diskname = disk^.diskname)
      then
        begin
          d2^.nextdisk := d1^.nextdisk ;
          TotalDisks := TotalDisks - 1 ;
          TotalFiles := TotalFiles - d1^.count ;
          dispose(d1);
          found := true ;
        end ;
    { remove all files belonging to this disk from file list }
    if found
      then
        begin
          f2 := rootfile ;
          f1 := f2^.nextfile ;
          while f1 <> filesentinel do
            begin
              if (f1^.diskname = disk^.diskname)
                then
                  begin
                    f2^.nextfile := f1^.nextfile ;
                    dispose(f1) ;
                  end
                else
                  f2 := f1 ;
              f1 := f2^.nextfile ;
            end ;
        end ;
    saved := false ;

  end ; { DeletewholeDisk }


procedure continue (promptstr: string80) ;

  {
    display message promptstr
    and wait for return 

  }

  begin

    writeln ;
    show_line(promptstr) ;
    repeat
      until get_char = chr(CR) ;
    writeln ;

  end ; { continue }

procedure IndexDiskInDrive ;

  { 
    display message to place index disk in drive
    and wait for return 
  }

  begin

    if not vms
      then
        begin
          continue(ind_msg_indexdrive) ;
           ResetDisks 
        end ;

  end ; { IndexDiskIndrive }

procedure Prompt_continue (var cont_ch : char) ;

  { 
    prompts message to continue
    and awaits either CR or ind_msg_opt_exit
    if CR then clear screen
  }

  begin
 
    writeln ;
    Show_line(ind_msg_continue) ;
    repeat
      cont_ch := Get_char ;
      cont_ch := Upcase(cont_ch) ;
    until (cont_ch = chr(CR)) or (cont_ch = ind_msg_opt_exit) ;
    if cont_ch = chr(CR) 
      then
        ClrScr
      else
        begin
          Show_line(cont_ch) ;
          writeln 
        end ;

  end ; { Prompt_continue }


procedure ReturnToMenu ;

  {
    display message returntomenu
    and wait for return 

  }
  
  begin

    continue(ind_msg_returnmenu) 

  end ; { ReturnToMenu }

procedure Prompt_YesOrNo (prompt_str : string80 ;
                          var YesOrNo : char) ;

  {
    Prompt_YesOrNo (var YesOrNo : char ) ;
    reads from terminal keystrokes until
    ind_msg_YesChar or ind_msg_NoChar entered
    echoes YesChar or Nochar
  }

  begin

    writeln ;
    Show_line (prompt_str) ;
    Show_line(ind_msg_YesNo) ;
    repeat
      YesOrNo := Get_char ;
      YesOrNo := Upcase(YesOrNo) ;
      if YesOrNo = chr(CR)
        then 
          YesOrNo := ind_msg_yesChar ;
    until (YesOrNo = ind_msg_YesChar) or (YesOrNo = ind_msg_NoChar) ;
    show_line(YesOrNo) ;
    writeln ;

  end ; { Prompt_YesOrNo }
 

procedure MainMenu ( var choice : char ) ;

  { display main menu on screen }

  begin

    ClrScr ;
    GotoXY (loc_x_progname, loc_y_progname) ;
    writeln(ind_msg_progname,ind_msg_version) ;
    GotoXY(loc_x_copyright,loc_y_copyright);
    writeln(ind_msg_copyright) ;
    GotoXY(loc_x_indexfile,loc_y_indexfile);
    writeln(ind_msg_indexfile,mainfile) ;
    GotoXY(loc_x_disk,loc_y_disk);
    write(ind_msg_disk,TotalDisks:2,' ', ind_msg_files,TotalFiles:4) ;
    if not vms
      then
        begin
          GotoXY(loc_x_free,loc_y_free);
          writeln(ind_msg_opt_free,Space:4:1,ind_msg_kbytes) 
        end
      else
        writeln ;
    GotoXY(loc_x_sfile,loc_y_sfile);
    writeln(ind_msg_opt_sfile,ind_msg_hyphen,ind_msg_sfile) ;
    GotoXY(loc_x_sdisk,loc_y_sdisk);
    writeln(ind_msg_opt_sdisk,ind_msg_hyphen,ind_msg_sdisk) ;
    GotoXY(loc_x_printf,loc_y_printf);
    writeln(ind_msg_opt_printf,ind_msg_hyphen,ind_msg_printf) ;
    GotoXY(loc_x_printd,loc_y_printd);
    writeln(ind_msg_opt_printd,ind_msg_hyphen,ind_msg_printd) ;
    if not vms
      then
        begin
          GotoXY(loc_x_add,loc_y_add);
          writeln(ind_msg_opt_add,ind_msg_hyphen,ind_msg_add) ;
        end ;
    GotoXY(loc_x_remove,loc_y_remove);
    writeln(ind_msg_opt_remove,ind_msg_hyphen,ind_msg_remove) ;
    GotoXY(loc_x_new,loc_y_new);
    writeln(ind_msg_opt_new,ind_msg_hyphen,ind_msg_new) ;
    GotoXY(loc_x_merge,loc_y_merge);
    writeln(ind_msg_opt_merge,ind_msg_hyphen,ind_msg_merge) ;
    GotoXY(loc_x_write,loc_y_write);
    writeln(ind_msg_opt_write,ind_msg_hyphen,ind_msg_write) ;
    GotoXY(loc_x_exit,loc_y_exit);
    writeln(ind_msg_opt_exit,ind_msg_hyphen,ind_msg_exit) ;
    GotoXY(loc_x_help,loc_y_help);
    writeln(ind_msg_opt_help,ind_msg_hyphen,ind_msg_help) ;
    repeat
      GotoXY(loc_x_choice,loc_y_choice);
      writeln ;
      show_line(ind_msg_choice) ;
      choice := Get_char ;
      choice := Upcase(choice) ;
      if choice = chr(ctrlz) 
        then 
          choice := ind_msg_opt_exit ;
    until choice in [ind_msg_opt_sfile,ind_msg_opt_sdisk,
                     ind_msg_opt_printf,ind_msg_opt_printd,
                     ind_msg_opt_add,ind_msg_opt_remove,
                     ind_msg_opt_new,ind_msg_opt_merge,ind_msg_opt_write,
                     ind_msg_opt_help,ind_msg_opt_exit] ;
    Show_line(choice) ;

end ; { MainMenu }

