  {

    Module     : INDDIR.INC

    Facility   : INDEX.PAS V2.1

    Author     : H.J.C. Otten

    Purpose    : floppy directory manipulations

    Creation   : 5-jan-1989

    Update     : 9-jan-1989 V2.0
    Update     : 28-aug-1989 V2.1 alter order of description questions

    Data       : n.a.

    Procedures : 
                 AddNewDisk
                   menu option add new floppy directory to index
                   prompt for diskspec
                   GetDirectory
                   if permitted 
                     prompt for description
                     add to index

                 DeleteDisk
                   menu option delete directory from index
                   prompt for diskspec
                   remove disk info and files belonging to disk from index
  }

procedure  AddNewDisk;

  { 
    menu option add new floppy directory to index
    prompt for diskspec
    prompt for description
    GetDirectory
    if permitted add to index
  }

  var

    helpdisk,
    disk     : diskptr   ;
    YesOrNo  : char      ;
    next,
    workfile : fileptr   ;
    present,
    found    : boolean   ;
    result,
    index    : integer   ;

  begin

  repeat

    ClrScr ;
    writeln(ind_msg_add) ;
    writeln ;
    new(disk);
    with disk^ do
      begin
        repeat
          write(ind_msg_namedisk) ;
          readln(diskname)  ;
        until length(diskname) > 0 ;
        while length(diskname) < length_diskname do
          diskname := diskname + ' ' ;
        for index := 1 to length_diskname do
          diskname[index] := Upcase(diskname[index]);
      end ;

    present := false ;
    InsertDiskInList(disk,found);
    if found
      then
        begin
          Prompt_YesOrNo(ind_msg_diskpresent,YesOrNo) ;
          if YesOrNo = ind_msg_YesChar
            then
              begin
                helpdisk := rootdisk^.nextdisk ;
                while helpdisk^.diskname <> disk^.diskname do
                  helpdisk := helpdisk^.nextdisk ;
                disk^.diskdescr := helpdisk^.diskdescr ;
                DeleteWholeDisk(disk,found) ;
                present := true ;
                InsertDiskInList(disk,found);
              end
            else
              dispose(disk) ;
        end ;
    if (not found) and room
      then
        begin
          continue(ind_msg_prmptdisk) ;
          writeln ;
          ResetDisks ;
          GetDirectory (directory,disk);
          continue(ind_msg_rmdisk) ;
          Prompt_YesOrNo(ind_msg_addindex,YesOrNo) ;
          if YesOrNo = ind_msg_YesChar
            then
              begin
                if present
                  then
                    begin
                      writeln(ind_msg_prmptdescr,disk^.diskdescr) ;
                      Prompt_YesOrNo(ind_msg_otherdescr,YesOrNo) ;
                      present := (YesOrNo = ind_msg_YesChar) ;
                    end ;
                if not present
                  then
                    begin
                      write(ind_msg_prmptdescr) ;
                      readln(disk^.diskdescr)
                    end ;
                workfile := directory ;
                while workfile <> nil do
                  begin
                    next := workfile^.nextfile ;
                    InsertFileInList(workfile) ;
                    workfile := next
                  end ;
                TotalDisks := TotalDisks + 1 ;
                TotalFiles := TotalFiles +  disk^.count ;
              end
            else
              begin
                DeleteWholeDisk(disk,found);
                { this has changed TotalDisks and TotalFiles, correct now }
                TotalDisks := TotalDisks + 1 ;
                TotalFiles := TotalFiles + disk^.count ;
                workfile := directory ;
                while workfile <> nil do
                  begin
                    next := workfile^.nextfile ;
                    dispose(workfile) ;
                    workfile := next
                  end ;
              end ;
        end
      else
        if not room
          then
            begin
              writeln ;
               writeln(ind_msg_noroom) ;
               dispose(disk) ;
             end ;

    Prompt_YesOrNo(ind_msg_addanother,YesOrNo)  ;

  until not (YesOrNo = ind_msg_yeschar)  ;

  end ; { AddNewDisk }

procedure DeleteDisk ;

  {
    menu option delete directory from index
    prompt for diskspec
    remove disk info and files belonging to disk from index
  }

  var

    disk : diskptr     ;
    result,
    index    : integer ;
    found    : boolean ;

  begin

    new(disk);
    ClrScr ;
    writeln(ind_msg_remove) ;
    writeln ;
    write(ind_msg_namedisk) ;
    with disk^ do
      begin
        readln(diskname) ;
        writeln ;
        if length(diskname) > 0
          then
            begin
              while length(diskname) < length_diskname do
                diskname := diskname + ' ' ;
              for index := 1 to length_diskname do
                diskname[index] := Upcase(diskname[index]) ;
              DeletewholeDisk(disk,found);
              if found
                then
                  writeln(ind_msg_deleted)
                else
                  writeln(ind_msg_nodisk) ;
            end
          else
            writeln(ind_msg_notdeleted) ;
        dispose(disk) ;
        ReturnToMenu ;
      end

  end ; { DeleteDisk }

{ end INDDIR.INC }
