  {
    Module     : INDCPM.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : operating system dependent procedures/functions CP/M
                 also applicable to MSX-DOS

    Creation   : 5-jan-1989

    Update     :  2-feb-1989 ( cleanup WriteIndexDirectory )
    Update     : 29-aug-1989 ( add Translate_date, remove GetDirectory)

    Data       : 


    Procedures : 

                   Position(searchstring, targetstring) : integer
                     performs Turbo Pascal POS function


                 Operating system dependent

                   Get_Char ;
                     returns single character from terminal without echo

                   Space : real ;
                      returns free memory space

                   Room : boolean 
                     returns true if enough memory available

                   GetDirectory (directory : fileptr;
                                 disk      : diskptr);
                     returns directory from diskette in
                     linked list pointed at by fileptr,
                     updates disk info in cell pointed at with diskptr

                   WriteIndexDirectory 
                     show directory of index files 

                   ResetDisks
                     resets disk system

                   Open_read(file_ident,filespec,io_result)
                     opens disk file for read, combination
                     of assign and reset. 
                     io_result = 0 if success

                   Open_write(file_ident,filespec,io_result)
                     opens disk file for write, combination
                     of assign and reset. 
                     io_result = 0 if success

                   Close_file (file_ident) ;
                     closes file, no error reporting

                   Erase(file_ident,filespec,io_result)
                     erases diskfile
                     Expects file to be open.

                   Check_Parameter
                     checks for index file specification in command line


                   Translate_Date (date1,date2: byte;
                            var day,month, year : integer ) ;

                     translates MS-DOS encoded date info in (date2, date1)
                     DD-MMM-YYYY format in day,month,year
                     if day = 0 then no valid date   
  }


{ Turbo Pascal emulation }

{$V-}
function position(searchstring : string80 ;
                  targetstring : string80  ) : integer ;

  {
    performs Turbo Pascal POS function
    searches for first occurrance of search string in targetstring
    and returns position as function result
  }

  begin

    position := pos (searchstring, targetstring) ;

  end ; { position }
{$V+}

{ operating system dependent procedures/functions }

function Get_char : char ;

  {
    Get_Char ;
    returns single character from terminal without echo
  }

  var

    ch : char ;

  begin

    read(kbd,ch) ;
    get_char := ch ; 

  end ; { Get_Char }

{$V-}
procedure Show_line(line : string80) ;

  begin

    write(line) ;

  end ; { Show_line }
{$V+}

procedure Open_read(var file_ident : text ;
                    filespec       : filename ;
                    var io_result  : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    {$I-}
    assign(file_ident,filespec) ;

    io_result := IOresult ;
    if io_result = 0
      then
        begin
          reset(file_ident) ;
          io_result := IOresult ;
        end ;
    {$I+}

  end ; { Open_read }

procedure Open_write(var file_ident   : text ;
                     filespec     : filename ;
                     var io_result : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    {$I-}
    assign(file_ident,filespec) ;

    io_result := IOresult ;
    if io_result = 0
      then
        begin
          rewrite(file_ident) ;
          io_result := IOresult ;
        end ;
    {$I+}

  end ; { Open_write }

procedure Close_file(var file_ident : text ) ;
  {
    closes diskfile,
    no error reporting
  }

  begin

    {$I-}
    close(file_ident) ;
    {$I+}

  end ; { Close_file }

procedure Erase_file(var file_ident : text ;
                     filespec       : filename ) ;
  {
    erases diskfile
    Expects file to be open.
  }

  begin

    {$I-}
    erase(file_ident) ;
    {$I+}

  end ; { Erase_file }

function Space : real ;

  { returns free heap space }
  
  begin
  
    if memavail < 0
      then
        space := ((65536.0+MemAvail)/1024)
      else
        space := (Memavail/1024) ;

  end ; { Space }

function Room : boolean ;

  {
    returns true if enough memory available 
    to insert new directory information
  }

  begin

    room := (space > 1);

  end ; { Room }

procedure ResetDisks ;

  { reset disk system }

  const

    ResetDisk = 13 ;

  begin

    Bdos(ResetDisk);

  end ; { ResetDisks }

procedure WriteIndexDirectory ;

  { 
    shows directory of files with specification in name
  }

  const

    extent      =  12;
    setDMA      =  26;
    searchFirst =  17;
    searchNext  =  18;

  var

    FCB                 : array[0..35] of char      ;
    directorysector     : array[0..3,0..31] of char ;
    index,directorycode : integer                   ;
  
  begin

    FCB := ' ????????INX                        ';
    FCB[0]:=chr(1) ;
    for index := 12 to 35 do
      FCB[index] := chr(0);

    bdos(setDMA,addr(directorysector));
    directorycode:=bdos(searchfirst,addr(FCB));
    if directorycode = 255
      then
        writeln(ind_msg_nofiles) 
      else
        while directorycode < 255 do
          begin
            if (directorysector[directorycode,extent]=chr(0)) or
               (directorysector[directorycode,extent]=chr(1))
              then
                begin
                  write(copy(directorysector[directorycode],2,8), ind_msg_dot);
                  for index:=9 to 11 do
                    write(chr(127 and 
                          ord(directorysector[directorycode,index])));
                  writeln ;
                end;
            directorycode:=bdos(searchnext);
          end;

  end ; { WriteIndexDirectory }

procedure Get_commandline(var name : string20) ;

  { looks for commandline, returns in name, empty string if none }

  var

    io_result,
    status  : integer ;

  begin

    if ParamCount > 0
      then
        name := Paramstr(1)
      else
        name := '' ;

  end ; { Get_Commandline }

procedure Translate_Date (date1,date2: byte;
                          var day,month, year : integer ) ;

  { translates MS-DOS encoded date info in (date2, date1)
    (YYYYYYYM, MMMDDDDD)
    DD-MMM-YYYY format in day,month,year
    if day = 0 then no valid date                         }

  begin

    day   := date1 and 31 ;
    year  := (date2 div 2) + 1980 ;
    month := (date1 div 32 ) + 8 * (date2 and 1) 

  end ; { Translate_date }


function write_filerec_fail(filespec    : filespec_type ;
                            size        : integer ;
                            date1,date2 : byte ) : boolean ;
  
   { writes file record to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,filespec,' ',size:1,
            ' ',date1:1,' ',date2:1);
    write_filerec_fail := (IOresult <> 0) ;
    {$I+}

  end ; { write_filerec_fail }


function write_diskrec_fail(diskname   : string3 ;
                            totalsize  : integer ;
                            count      : integer ;
                            diskdescr  : string40 ) : boolean ;

   { writes disk record to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,diskname,' ',totalsize:1,' ',count:1,' ',diskdescr);
    write_diskrec_fail := (IOresult <> 0) ;
    {$I+}

  end ; { write_diskrec_fail }


function write_header_fail(TotalDisks : integer ) : boolean ;

   { writes header records to index database,
     returns true if write failed      }

  begin

    {$I-}
    writeln(indexf,ind_msg_progname,ind_msg_version) ;
    if IOresult <> 0
      then
        write_header_fail := true
      else
        begin
          writeln(indexf,TotalDisks:1) ;
          write_header_fail := (IOresult <> 0) ;
        end ;
    {$I+}

  end ; { write_header_fail }

{ end INDCPM.INC }

