{ boxgraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }

const

  sprite_max_loc = 255 ; { sprite moves between x,y 0 - 255 }


function Get_sprite_size : sprite_size ;

  { returns current sprite size : sprite8 or sprite16 }

  var

    size : byte ;

  begin

    inline (
              $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$8A/$00/         {       LD   IX,GSPSIZ   }
              $CD/$1C/$00/             {       CALL CALSLT      }
              $32/size                 {       LD   (size),A    }
           ) ;
    if size = 8
      then
        get_sprite_size := sprite8
      else
        get_sprite_size := sprite16 ;

  end ; { Get_sprite_size }


procedure Check_sprite_number(sprite_number : integer) ;

  { checks sprite nr depending sprite size
    aborts if illegal }

  begin

    if ( sprite_number < 0 ) or
       ( (sprite_number > 255) and
         (get_sprite_size = sprite8) ) or
       ( (sprite_number > 63) and
         (get_sprite_size = sprite16) )
          then
            begin
              error_handler ;
              writeln('Illegal sprite_number') ;
              halt ;
            end ;

  end ; { Check_sprite_number }


function get_pattern_address(sprite_number : byte) : integer ;

  { returns address in vram of pattern of this sprite }

  var

    address : integer ;

  begin

    inline (  $3A/sprite_number/       {       LD   A,(sprite_nr}
              $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$84/$00/         {       LD   IX,CALPAT   }
              $CD/$1C/$00/             {       CALL CALSLT      }
              $22/address              {       LD   (address),HL}
           ) ;

    get_pattern_address := address ;

  end ; { Get_pattern_address }


function get_attribute_address(transp_number : byte) : integer ;

  { get attribute address of this transparantt in vram }

  var

    address : integer ;

  begin

    inline (  $3A/transp_number/       {       LD   A,(transp_nr}
              $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$87/$00/         {       LD   IX,CALATR   }
              $CD/$1C/$00/             {       CALL CALSLT      }
              $22/address              {       LD   (address),HL}
           ) ;

    Get_attribute_address := address ;

  end ; { Get_attribute_address }


procedure Init_Sprite ( size    : sprite_size ;
                        magnify : sprite_magnify ) ;

  var

    vdp1 : byte ;

  begin

    { clear all sprites }
    inline (
              $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$69/$00/         {       LD   IX,CLRSPR   }
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

    { set vdp register 1 to size and magnify }

    { get system variable RG1SAV with current VDP 1 register }
    vdp1 := Mem[$F3E0] ;

    if size = sprite16
      then
        vdp1 := vdp1 or $02
      else
        vdp1 := vdp1 and $FD ;
    if magnify = double
       then
        vdp1 := vdp1 or $01
      else
        vdp1 := vdp1 and $FE ;

    write_vdp(vdp1,1) ;

  end ; { Init_Sprite }


procedure Define_Sprite8 ( sprite_layout : sprite8_layout ;
                           sprite_number : byte            ) ;


  begin

    { check if size is 8, else exit  }
    if get_sprite_size <> sprite8
      then
        begin
          error_handler ;
          writeln('Size mismatch sprite 8') ;
          halt ;
        end ;

    { check sprite nr }
    Check_sprite_number (sprite_number) ;

    { fill sprite table }
    writeblock_vram(8,
                    addr(sprite_layout),
                    get_pattern_address(sprite_number)) ;

  end ; { Define_Sprite8 }


procedure Define_Sprite16 ( sprite_layout : sprite16_layout ;
                            sprite_number : byte            ) ;

  var

    sprite_size : byte ;

  begin

    { check sprite nr }
    Check_sprite_number (sprite_number) ;

    { check if size is 16, else exit  }
    if get_sprite_size <> sprite16 then
      begin
        error_handler ;
        writeln('Size mismatch sprite 16') ;
        halt ;
      end ;

    { get sprite table address of this sprite and
      fill sprite pattern table }
    writeblock_vram(32,
                    addr(sprite_layout),
                    get_pattern_address(sprite_number) ) ;

  end ; { Define_Sprite16 }


procedure Draw_Sprite ( transp_nr     : byte ;
                        x, y          : integer ;
                        sprite_number : byte ;
                        sprite_color  : colortype ) ;

  { places sprite with sprite_nr on screen in transparant_nr at x,y }

  var

    tr_address  : integer ;
    clock_color : byte ;

  begin

    { check sprite nr }
    Check_sprite_number (sprite_number) ;

    { check transparant nr }
    if (transp_nr <  0) or
       (transp_nr > 31)
       then
         begin
           error_handler ;
           writeln('Illegal transparant number in Draw_sprite') ;
         end ;
         
    { check coordinates }
    clock_color := 0 ;
    if x < 0
      then
        begin
        { if negative location -32 <= x <= -1 use early clock bit }
             if (x >= -32) and (x <= -1)
            then
              begin
                clock_color := $80 ;
                x := x + 32 ;
              end
            else
              { make positive }
              while x < 0 do
                x := x + sprite_max_loc
        end
    else
      while x > sprite_max_loc do
        x := x - sprite_max_loc ;
    while y > sprite_max_loc do
      y := y - sprite_max_loc ;
    while y < 0 do
      y := y + sprite_max_loc ;

    { get attribute address of this sprite in vram }
    tr_address := Get_attribute_address(transp_nr) ;

    write_vram(tr_address    , y) ;
    write_vram(tr_address + 1, x) ;
    write_vram(tr_address + 2, sprite_number) ;

    { combine color with early clock bit }
    clock_color := ord(sprite_color) or clock_color ;
    write_vram(tr_address + 3, clock_color) ;

  end ; { Draw_Sprite }

