program demo_disk ;

{$I graphics.inc }

procedure Read_screen (file_spec   : grstring ;
                       var fresult : integer ) ;

  { reads contents of screen image from disk
    fresult = 0  if no error detected
            > 0  turbo pascal I/O error
            -1   not a code file
            -2   illegal start/end address
  }

  const

    rec_size    = 128 ;
    rec_number  = 2   ;
    buffer_size = 256 ; { = rec_number * rec_size }

  var

    file_buffer : array [1..buffer_size] of byte ;
    scr_file : file ;
    start_address,
    end_address,
    nr_recs,
    nr_bytes       : integer ;

  begin

    { try to open file }
    {$I-}
    assign(scr_file,file_spec) ;
    fresult := IOresult ;
    if fresult = 0
      then
        reset(scr_file) ;
    fresult := IOresult ;
    if fresult <> 0
      then
        exit ;

    { get first block }
    blockread(scr_file,file_buffer,rec_number,nr_recs) ;
    fresult := IOresult ;
    if fresult <> 0
      then
        exit ;

    { check if it is a code file }
    if file_buffer[1] <> $FE
      then
        begin
          fresult := -1 ;
          exit
        end ;

    { get start and end address }
    start_address := file_buffer[3] * 256 + file_buffer[2] ;
    end_address   := file_buffer[5] * 256 + file_buffer[4] ;

    { check sanity }
    if end_address > max_vram
      then
        end_address := max_vram ;
    if start_address >= end_address
      then
        begin
          fresult := -2 ;
          exit
        end ;

    { write rest of first sector to screen }
    nr_bytes := end_address - start_address ;

    { if already end }
        if nr_bytes > (buffer_size - 7)
          then
            nr_bytes := buffer_size - 7 ;

    { write to screen }
    writeblock_vram(nr_bytes,addr(file_buffer[8]),start_address) ;
    start_address := start_address + buffer_size - 7 ;

    { get all the other sectors }
    while start_address < end_address do
      begin
        { read 2 sectors }
        blockread(scr_file,file_buffer,rec_number,nr_recs) ;
        fresult := IOresult ;
        if fresult <> 0
          then
            exit ;

        { write to vram }
        nr_bytes := end_address - start_address ;

        { if last block incomplete }
        if nr_bytes > buffer_size
          then
            nr_bytes := buffer_size ;

        { write to screen }
        writeblock_vram(nr_bytes,addr(file_buffer),start_address) ;
        start_address := start_address + nr_bytes ;

      end ;
    {$I+}
    close(scr_file) ;

  end ; { Read_screen }


procedure Write_screen (file_spec     : grstring ;
                        start_address,
                        end_address   : integer ;
                        var fresult   : integer ) ;

  { writes contents of screen image to disk
    fresult = 0  if no error detected
            > 0  turbo pascal I/O error
            -1   not a code file
            -2   illegal start/end address
  }

  const

    rec_size    = 128 ;
    rec_number  = 2 ;
    buffer_size = 256 ; { = rec_number * rec_size }

  var

    file_buffer : array [1..buffer_size] of byte ;
    scr_file : file ;
    recs,
    nr_recs,
    nr_bytes       : integer ;

  begin

    { try to open file }
    {$I-}
    assign(scr_file,file_spec) ;
    fresult := IOresult ;
    if fresult = 0
      then
        rewrite(scr_file) ;
    fresult := IOresult ;
    if fresult <> 0
      then
        exit ;

    { check sanity }
    if end_address > max_vram
      then
        end_address := max_vram ;
    if((start_address >= end_address) or
       (start_address < 0 ) or
       (end_address   < 0) )
      then
        begin
          fresult := -2 ;
          exit
        end ;

    { enter start and end address }
    file_buffer[1] := $FE ;
    file_buffer[2] := start_address mod 256 ;
    file_buffer[3] := start_address div 256;
    file_buffer[4] := end_address mod 256 ;
    file_buffer[5] := end_address div 256 ;
    file_buffer[6] := 0 ;
    file_buffer[7] := 0 ;


    { read rest of first buffer from screen }
    nr_bytes := end_address - start_address ;

    { if already end }
    if nr_bytes > (buffer_size - 7)
      then
        nr_bytes := buffer_size - 7 ;
    recs := (nr_bytes + 7) div rec_size ;

    { read from screen }
    readblock_vram(nr_bytes,addr(file_buffer[8]),start_address) ;
    start_address := start_address + nr_bytes ;

    { write first block }
    blockwrite(scr_file,file_buffer,recs,nr_recs) ;
    fresult := IOresult ;
    if fresult <> 0
      then
        exit ;

    { get all the other sectors }
    while start_address < end_address do
      begin
        { read from vram }
        nr_bytes := end_address - start_address ;

        { if last block incomplete }
        if nr_bytes > buffer_size
          then
            nr_bytes := buffer_size ;
        recs := nr_bytes div rec_size ;

        readblock_vram(nr_bytes,addr(file_buffer),start_address) ;

        { write  sectors }
        blockwrite(scr_file,file_buffer,recs,recs) ;
        fresult := IOresult ;
        if fresult <> 0
          then
            exit ;

       start_address := start_address + nr_bytes ;

      end ;
    {$I+}
    close(scr_file) ;

  end ; { Write_screen }



var

  result : integer ;

begin

  init_graphics ;
  graphmode ;
  Read_screen('dump.scr', result) ;
  readln;
  if result = 0
    then
      begin
        for result := 1 to 191 do
          draw_point(128,result,white) ;
        Write_screen('new.scr',0,$3fff,result) ;
        readln ;
        if result = 0
          then
            begin
              clear_screen ;
              read_screen('new.scr',result) ;
              readln ;
            end ;
      end ;
  textmode(40) ;
  writeln(result) ;

end.