
{ boxgraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }


procedure Draw_Horizontal_Line (x, y, dx : integer) ;

  { draws horizontal line from pixel x,y with length of dx pixels }

  begin

    inline (
            { position at x,y of start pixel of line }
              $ED/$5B/y/                  {       LD   DE,(y)    }
              $ED/$4B/x/                  {       LD   BC,(x)    }
              $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
              $DD/$21/$11/$01/            {       LD   IX,MAPXYC }
              $CD/$1C/$00/                {       CALL CALSLT    }
            { draw line with length dx }
              $2A/dx/                     {       LD   HL,(dx)   }
              $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
              $DD/$21/$23/$01/            {       LD   IX,NSETCX }
              $CD/$1C/$00                 {       CALL CALSLT    }
           ) ;

  end ;

procedure Draw_Vertical_Line (x, y, dy : integer) ;

  { draws vertical line from pixel x,y with length of dy pixels }

  begin


    inline (
            { position at x,y of start pixel of line }
              $ED/$5B/y/                  {       LD   DE,(y)    }
              $13/                        {       INC  DE        }
              $ED/$4B/x/                  {       LD   BC,(x)    }
              $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
              $DD/$21/$11/$01/            {       LD   IX,MAPXYC }
              $CD/$1C/$00/                {       CALL CALSLT    }
            { for linecounter := 1 to dy }
              $11/$01/$00/                {       LD   DE, 1     }
              $D5/                        { vloop PUSH DE        }
            {   set current pixel to attribute color }
              $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
              $DD/$21/$20/$01/            {       LD   IX,SETC   }
              $CD/$1C/$00/                {       CALL CALSLT    }
            {   position one line down }
              $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
              $DD/$21/$08/$01/            {       LD   IX,DOWNC  }
              $CD/$1C/$00/                {       CALL CALSLT    }
            { check for end of for-loop }
              $D1/                        {       POP  DE        }
              $13/                        {       INC  DE        }
              $2A/dy/                     {       LD   HL,(dy)   }
              $7C/                        {       LD   A,L       }
              $92/                        {       SUB  E         }
              $C2/*-31/                   {       JP   NZ,vloop  }
              $7D/                        {       LD   A,H       }
              $93/                        {       SUB  D         }
              $C2/*-36                    {       JP   NZ,vloop  }
           ) ;

  end ;

procedure Draw_Box(x1,y1,x2,y2 : integer   ;
                   bcolor      : colortype ;
                   bfill       : boolean ) ;

  { draws box between upper rigth (x1,y1) and
    lower left (x2,y2) in bcolor
    valid coordinates:
     (x1 < x2 and y1 < y2)
    or
     (x2 < x1 and y2 < y1)
    if bfill true filled with bcolor }

 var

   dx, dy : integer ;

 begin

  { make sure box fits on screen }
  scale(x1,y1) ;
  scale(x2,y2) ;

  { check for correct coordinates }
  if not ( (x1 < x2) and (y1 < y2) )
    then
      begin
        if (x2 < x1) and (y2 < y1)
          then
            begin
              swap_int(x1,x2) ;
              swap_int(y1,y2) ;
            end
          else
            begin
              error_handler ;
              writeln('Draw_Box illegal coordinates') ;
              halt ;
            end
      end ;

  { determine length of vertical and horizontal lines }
  dy := y2 - y1 + 1 ;
  dx := x2 - x1 + 1 ;

  { set attribute color for setting pixels }
  SetColor(bcolor) ;

  if bfill
     then
       begin
         { draw dy lines of length dx }
         dy := dy + 1 ;
         inline (
                 { position at x1,y1 of start pixel of line }
                   $ED/$5B/y1/                 {       LD   DE,(y1)   }
                   $ED/$4B/x1/                 {       LD   BC,(x1)   }
                   $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
                   $DD/$21/$11/$01/            {       LD   IX,MAPXYC }
                   $CD/$1C/$00/                {       CALL CALSLT    }
                 { for linecounter := 1 to dy }
                   $11/$01/$00/                {       LD   DE, 1     }
                   $D5/                        { yloop PUSH DE        }
                 {   draw line with length dx }
                   $2A/dx/                     {       LD   HL,(dx)   }
                   $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
                   $DD/$21/$23/$01/            {       LD   IX,NSETCX }
                   $CD/$1C/$00/                {       CALL CALSLT    }
                 {   position 1 pixel down at begin of next line }
                   $FD/$2A/$C0/$FC/            {       LD   IY,(EXPT) }
                   $DD/$21/$08/$01/            {       LD   IX,DOWNC  }
                   $CD/$1C/$00/                {       CALL CALSLT    }
                 {   check for end of for-loop }
                   $D1/                        {       POP  DE        }
                   $13/                        {       INC  DE        }
                   $2A/dy/                     {       LD   HL,(dy)   }
                   $7C/                        {       LD   A,L       }
                   $92/                        {       SUB  E         }
                   $C2/*-34/                   {       JP   NZ,yloop  }
                   $7D/                        {       LD   A,H       }
                   $93/                        {       SUB  D         }
                   $C2/*-39                    {       JP   NZ,yloop  }
                ) ;
       end
     else
       begin
         { draw upper line }
         Draw_Horizontal_line(x1,y1,dx) ;

         { draw lower line }
         Draw_Horizontal_line(x1,y2,dx) ;

         { draw left line }
         Draw_Vertical_line(x1,y1,dy) ;

         { draw right line }
         Draw_Vertical_line(x2,y1,dy) ;

       end ;

 end ; { DrawBox }
