(*

   PRTHANDL.PAS

   Een programma om de handleiding van
   MDL-LIB te printen

   Een include-file bij MDLTEST.PAS,
   kan echter makkelijk tot een zelf-
   standig programma worden omge-
   bouwd.

   Behoort bij MDL-LIB versie 2.0
   - COPYRIGHT 1990 BY MDL-SOFT -

*)


(* {$C-} *)
(* Program *)
Overlay procedure Print_de_handleiding;

(*
Type
  {$I MDLLIB.TYP}
*)

Var
  (*
  {$I MDLLIB.VAR}
  {$I VRAM1.VAR}
  *)
  bestand        : text;
  stop           : boolean;
  scherm,breedte : byte;

(*
{$I MDLLIB.LIB}
{$I DISKTOOL.LIB}
{$I VRAM1.LIB}
{$I SYSVARS.LIB}
{$I DATA.LIB}
{$I MISC.LIB}
*)



Procedure Initialisatie;
{ Voert noodzakelijke initalisaties
  uit aan het begin van het pro-
  gramma. }

Begin
  Color(15,1,1);
  { Sla oude schermmode/breedte op }
  scherm:=sys_scrmod;
  breedte:=sys_textwidth;
  { Stel scherm in }
  sys_width0:=40; scrmode(0)
End;


{-------------------------------------}


Procedure Kies_een_bestand
  (var bestand:text;
   var stop:boolean);
{ Deze procedure laat de gebruiker
  een bestand uitkiezen. Bevat ver-
  schillende sub-procedures. }

Type paoc8 =
     packed array[1..8] of char;

     paoc11 =
     packed array[1..11] of char;

Const max_namen = 20;

Var bnamen : array[1..max_namen]
             of paoc8;
    gekozen_naam : paoc8;
    string_naam : string[8];
    drive : byte;
    index,i : integer;
    aantal_namen : integer;


   { Vergelijk-functie:
     wordt gebruikt door SORT
     (zie handleiding, DATA.TXT!!) }

   Function Vgl_naam
     (var naam1,naam2:paoc8):boolean;
   Begin
     Vgl_naam := (naam1>=naam2);
   end;


   { Een sub-procedure }
   Procedure Lees_bestanden;

   Const zoeknaam : paoc11 =
         '????????TXT';

   Var index : integer;
       gelukt : boolean;
       fcb : array[0..37] of byte;
       info : array[0..31] of byte;

   Begin
     { maak FCB leeg }
     FillChar(fcb,sizeof(fcb),chr(0));
     { zet het drivenr. erin }
     fcb[0]:=drive;
     { en de zoeknaam }
     For index:=1 to 11 do
      fcb[index]:=ord(zoeknaam[index]);

     { zet namen in array }
     index:=1;
     gelukt:=SearchFirst(fcb,info);
     while gelukt do
      begin
       for i:=1 to 8 do
        bnamen[index,i]:=chr(info[i]);
        { copieer extensie niet mee,
          deze is toch altijd .TXT }
       gelukt:=SearchNext(info);
       index:=index+1;
       if index>max_namen then
        gelukt:=false { niet teveel namen }
      end;
     aantal_namen := index - 1;

     { sorteer nu de namen nog even }
     sort (bnamen,
           aantal_namen,
           sizeof(paoc8),
           addr(vgl_naam)
          )
  end;

  { Een subprocedure }
  Procedure Schrijf_de_namen;
  Var i:integer;
  Begin
    If aantal_namen>0 then
      Begin
        GoToXY(25,4);
        Write('+------------+');
        For i:=1 to aantal_namen do
          Begin
           GoToXY(25,i+4);
           Write('|   ',bnamen[i],' |')
          End;
      GotoXY(25,aantal_namen+5);
      Write('+------------+');
    End;
    For i:=aantal_namen+6 to 24 do
      Begin { wis evt. oude namen }
        GoToXY(25,i);
        ClrEol
      end;
    If aantal_namen=0 then
      Begin
        GotoXY(25,4);
        Write('Geen .TXT be- ');
        GotoXY(25,5);
        Write('stand aanwezig')
      end;
  end;

  { Een subprocedure }
  Procedure Kies_een_naam
    (var naam : paoc8;
     var stop : boolean);

  Var index      : integer;
      commando   : char;
      einde_kies : boolean;

  { Een sub-sub-procedure }
  Procedure Kies_de_drive;
  Var c:char;
      i:byte;
  Begin
    GotoXY(1,23);
    Write('Welke drive? ');
    Repeat
      Read(kbd,c);
      c:=upcase(c)
    until c in ['A'..'D'];
    write(c);
    drive:=ord(c)-64; {maak drive-nr.}
    GotoXY(1,19);{voor evt.Insert disk}
    Lees_bestanden;
    ClrY(19,24); { wis alles weer }
    Schrijf_de_namen
  end;

  Begin { Kies_een_naam }
    index := 1;
    einde_kies := false;
    Repeat
      GoToXY(27,index+4);
      If aantal_namen>0 then
        Write(#1#87#207); { pijl }
      While not keyPressed do
        { nothing };
      Read(kbd,commando);
      If aantal_namen>0 then
        Write(#127,#127); { wis pijl }
      Case commando of
        'D','d' : Kies_de_drive;
        'Q','q' : stop := true;
        ' ',#13,
        'P','p' : einde_kies := true;
        #30     : index := index - 1;
        #31     : index := index + 1;
      end; { case }
      if index<1 then index:=1;
      if index>aantal_namen then
        index:=aantal_namen;
    until einde_kies or stop;
    If einde_kies and
      (aantal_namen>0) then
        naam := bnamen[index]
      else
        naam := '        ';
  end;

Begin { van Kies_een_bestand }
  drive:=0; { begin met default drive }
  Lees_bestanden;
  ClrScr;
  WriteLn('* PRINT DE HANDLEIDING *');
  WriteLn('(C) 1989 by MDL-soft');
  WriteLn;
  WriteLn('Kies bestand met de');
  WriteLn('cursortoetsen.'); writeln;
  WriteLn('Druk dan op P om te');
  WriteLn('printen.');
  WriteLn;
  WriteLn('Andere keuzes:');
  WriteLn('D = andere drive');
  WriteLn('Q = stoppen');

  { schrijf bestandsnamen op scherm }
  Schrijf_de_namen;

  { kies een bestandsnaam }
  Kies_een_naam(gekozen_naam,stop);

  { filter de spaties uit de naam (dit
    is nodig voor Assign!)
    (byte 0 = lengtebyte) }
  string_naam:=gekozen_naam;
  If pos(' ',string_naam)>0 then
    string_naam[0] :=
      chr(pos(' ',string_naam)-1);

  If aantal_namen>0 then
  begin
   If drive=0 then
     assign(bestand,
       string_naam+'.TXT')
   else
     assign(bestand,chr(64+drive)+':'+
       string_naam+'.TXT');
   clrscr; write(string_naam+'.TXT')
  end
end;


{------------------------------------}


Procedure Print_bestand
  (var bestand : text);
{ Print bestand 'bestand' uit }

Var paginas  : boolean; { indeling in pagina's? }
    regels   : integer; { aantal regels/pagina }
    spaties  : integer; { breedte v/d kantlijn }
    formfeed : boolean; { doorschuiven pagina? }
    wacht    : boolean; { wacht op toets na pag? }
    reg_tel  : integer; { regelteller }
    lst      : text;    { vanwege bug }
    regel    : string[80];
    i        : integer;

  { Een subfunctie }
  Function Ja : boolean;
  Var c:char;
  Begin
    Write(' (J/N) ');
    Repeat
      Read(kbd,c);
      c:=upcase(c)
    until c in ['J','N'];
    WriteLn(c);
    Ja := (c='J')
  End;

  { Een sub-procedure }
  Procedure Print_alles;
  Begin
    Close(lst);
    Rewrite(lst)
  End;

Begin { van Print_bestand }
  WriteLn(' UITPRINTEN');
  WriteLn;
  Write('Verdeel tekst in pagina''s?');
  paginas := Ja;
  If paginas then
    begin
      Write('Aantal regels per pagina:');
      regels:=66; ReadLn(regels);
      Write('Schuif door na iedere pagina?');
      formfeed := Ja;
      Write('Wacht op toets na iedere pagina?');
      wacht := Ja;
    end;
  Write('Aantal spaties voor iedere regel:');
  spaties:=0;
  {$I-} ReadLn(spaties); {$I+}
  WriteLn;
  While not OnLine do
    Begin
      Beep;
      Write('Printer niet klaar!'#13);
      If KeyPressed then
        Begin { toets? naar menu }
          KillBuffer;{keyPressed uit buffer}
          Exit
        end;
      For i:=1 to 10 do WaitForInt;
      ClrEol {zorg voor knippereffect}
    End;

  { Open het bestand }
  {$I-} Reset(bestand); {$I+}
  If IOResult<>0 then
    Begin
      WriteLn
      ('Bestand niet gevonden!');
      Write('RETURN>'); ReadLn;
      Exit
    end;

  { Print nu het bestand }
  Assign(lst,'PRN');
  Rewrite(lst); { open de printer }
  reg_tel:=0;
  While not eof(bestand) do
    Begin
      { lees regel uit file }
      ReadLn(bestand,regel);
      { print evt. kantlijn }
      If spaties>0 then
        For i:=1 to spaties do
          Write(lst,' ');
      { print gelezen regel }
      WriteLn(lst,regel);
      reg_tel:=reg_tel+1;
      { zoek uit of pagina-opschuif }
      if paginas then
        if reg_tel mod regels=0 then
          begin
            { schuif evt. pag. door }
            if formfeed then
              write(lst,#12);
            print_alles;
            if wacht then
              begin
                write('Volgende pagina: druk op RETURN>');
                readln
              end
          end
    end;
  close(lst); { print alles }
end;


{------------------------------------}


Procedure Herstel_het_scherm;
var c:char;
Begin
  if scherm=1 then
    sys_width1:=breedte
  else
    sys_width0:=breedte;
  scrmode(scherm)
end;


{------------------------------------}


Begin { van het hoofdprogramma }
  Initialisatie;
  stop:=false;
  repeat
    Kies_een_bestand(bestand,stop);
    If not stop then
      Print_bestand(bestand)
  until stop;
  Herstel_het_scherm
End;
(* End. *)
