{*************************************************************************}
{*                       Pascal Link-80  version 3.2                     *}
{*                                                                       *}
{*      Program to produce an INLINE-statement from an M80 REL-file      *}
{*                                                                       *}
{*          Programmed in Turbo Pascal by  J.A.C.G. van der Valk         *}
{*              van Langendonckstraat 2 / 3076 SL Rotterdam              *}
{*                           Phone: 010-4320625                          *}
{*                                                                       *}
{*                Copyright 1986 by J.A.C.G. van der Valk                *}
{*                                                                       *}
{*************************************************************************}
{*                                                                       *}
{*  This code is donated to public domain for non-commercial use only!   *}
{*    It is prohibited to sell this code (or any part of it) to third    *}
{*  parties ; to use this code code for any other commercial gain or to  *}
{*  distribute any program (in source or object form) ,developed by use  *}
{*     of the code in this file, on a commercial basis without prior     *}
{*                   written permission by the author.                   *}
{*                                                                       *}
{*************************************************************************}

const
  PrtOn=^P; PrtOff=^N; Bell=^G; LF=^J; CR=^M; UP=^K;

type
  symboltype = string[8];
  fnamtype   = string[20];
  anystring  = string[80];
  hextype    = string[2];
  FileRecord = array [0..127] of byte;
  LoadItem   = record
                 typecode:byte;
                 contents:byte;
               end;

var
  FileBuffer : FileRecord;
  count,                { counter for lay out of .INC file        }
  offset,               { offset for PC-relative code             }
  DataSize,             { size of Data - segment                  }
  ProgSize,             { size of Code - segment                  }
  ErrorCnt,             { number of fatal errors detected         }
  EntryCnt,             { number of entry sumbols defined         }
  Maxloc,               { maximum for LC on the heap              }
  LC,                   { Location Counter                        }
  Pbase,                { Base for LC in Code Segment             }
  Dbase,                { Base for LC in Data Segment             }
  Tsize,                { Total Size of Code + Data               }
  BitCnt,               { Number of bits  read from .REL-file     }
  ByteCnt,              { Current Byte-number in .REL-file        }
  ExtCnt,               { Counter for external symbol storage     }
  i                     { general purpose counter                 }
  :integer;

  STOP   : boolean;     { Flag for terminating .REL-file reading  }
  PrtOut : boolean;     { Flag for shadow-output on printer       }
  symbol : symboltype;  { symbol in special link items            }
  s      : string[5];   { string for LC in inl-file               }
  fnam   : string[15];  { file - name of .REL file                }
  WrkRec : LoadItem;    { variable for storing temporary code     }
  c      : char;        { dummy character                         }

  relfil :file;         { .REL - file from M80 assembler          }
  inlfil,               { file for inline statement               }
  fentry,               { file for table of entry points          }
  f      :text;         { file for listing on LST: or CON:        }
  dsk    :byte;         { current disk number                     }

label
   9999;                { label to EXIT the program               }

{$I PLMOD00.INC}

function getbit:byte;
var mask:byte;
begin
  BitCnt:=(BitCnt+1) mod 8;
  if BitCnt=0
  then ByteCnt:=(ByteCnt+1) mod 128;
  if ByteCnt+BitCnt=0 then
  begin
    BlockRead(RelFil,FileBuffer,1);
  end;
  Mask:=128 shr BitCnt;
  if (FileBuffer[Bytecnt] and mask)=0
  then Getbit:=0 else Getbit:=1;
end;

function RelCode:byte;
begin
  relcode:=(GetBit shl 1) + GetBit;
end;

function CtrlField:integer;
begin
  CtrlField:=(GetBit shl 3) +
  (GetBit shl 2) + (GetBit shl 1) +
  GetBit;
end;

function GetByte:byte;
var i,B:byte;
begin
  B:=0;
  for i:=7 downto 0
  do B:=B+(GetBit shl i);
  Getbyte:=B;
end;

function GetInteger:integer;
begin
  GetInteger:=GetByte + Swap(GetByte);
end;

Procedure GetAfield(var yy,nn:integer);
begin
  yy:=RelCode;
  nn:=GetInteger;
end;

Procedure GetBfield(var symbol:symboltype);
var i,zzz:byte;
begin
  zzz:=GetBit*4+GetBit*2+GetBit;
  if zzz=0 then zzz:=8;
  symbol:='';
  for i:=1 to zzz do symbol:=symbol+chr(GetByte);
end;

Procedure LoadByte;
begin
  WrkRec.typecode:=0;
  WrkRec.contents:=GetByte;
  MemWrite(LC,WrkRec);
  LC:=LC+1;
end;

Procedure LoadProgRel;
var x:integer;
begin
  x:=GetInteger+Pbase;
  WrkRec.typecode:=1;
  WrkRec.contents:=lo(x);
  MemWrite(LC,WrkRec);
  WrkRec.contents:=hi(x);
  MemWrite(LC+1,WrkRec);
  LC:=LC+2;
end;

Procedure LoadDataRel;
var x:integer;
begin
  x:=GetInteger+Dbase;
  WrkRec.typecode:=1;
  WrkRec.contents:=lo(x);
  MemWrite(LC,WrkRec);
  WrkRec.contents:=hi(x);
  MemWrite(LC+1,WrkRec);
  LC:=LC+2;
end;

Procedure LoadCommRel;
var x:integer;
begin
  x:=GetInteger;
  LC:=LC+2;
end;

Procedure SpecialLink;
var x,yy,nn,nextloc,nextcode:integer;
begin
  Case CtrlField of
  0: begin
       GetBfield(symbol);
       writeln('Entry symbol              --> ',symbol);
     end;
  1: begin
       GetBfield(symbol);
       writeln('Select COMMON block       --> ',symbol);
       Error(2);
     end;
  2: begin
       GetBfield(symbol);
       writeln('Program Name              --> ',symbol);
     end;
  3: begin
       GetBfield(symbol);
       writeln('Request library search    --> ',symbol);
       Error(0);
     end;
  4: begin
       GetBfield(symbol);
       writeln('Extention Link item       --> ',symbol);
       Error(0);stop:=true;
     end;
  5: begin
       GetAfield(yy,nn);GetBfield(symbol);
       writeln('Define COMMON size        --> ',symbol);
       writeln('$',Hex(yy),'  $',Hex(hi(nn)),Hex(lo(nn)));
       Error(0);
     end;
  6: begin
       GetAfield(yy,nn);GetBfield(symbol);
       writeln('Chain External            --> ',symbol);
       case yy of
       1: nn:=nn+Pbase;
       2: nn:=nn+Dbase;
       3: begin
            nn:=nn+Tsize;
            Error(2);
          end;
       end;{ of case }
       MemRead(nn,WrkRec);
       writeln('loc = $',Hex(hi(nn)),Hex(lo(nn)));
       nextloc:=nn;nextcode:=yy;
       if nn+yy=0 then
       writeln('WARNING: Chain is empty, inspect source code!');
       while nextcode+nextloc>0 do
       begin
         nextloc:=WrkRec.contents;
         nextcode:=WrkRec.typecode;
         WrkRec.contents:=lo(ExtCnt);
         WrkRec.typecode:=2;
         MemWrite(nn,WrkRec);
         MemRead(nn+1,WrkRec);
         nextloc:=nextloc+swap(WrkRec.contents);
         if nextcode+nextloc>0 then
         writeln('loc = $',hex(hi(nextloc)),hex(lo(nextloc)));
         WrkRec.typecode:=2;WrkRec.contents:=hi(ExtCnt);
         MemWrite(nn+1,WrkRec);
         nn:=nextloc;MemRead(nn,WrkRec);
       end;
       StoreExtrnl(symbol);
     end;

  7: begin
       GetAfield(yy,nn);GetBfield(symbol);
       writeln('Define Entry point        --> ',symbol);
       writeln('$',Hex(yy),'  $',Hex(hi(nn)),Hex(lo(nn)));
       case yy of
       1:nn:=nn+Pbase;
       2:nn:=nn+dbase;
       3:begin
           ErrorCnt:=ErrorCnt+1;
           writeln('Error: entry in common block');
         end;
       end;{ of case }
       if EntryCnt=0 then
       begin
         assign(fentry,fnam+'.ENT');rewrite(fentry);
         writeln(fentry,'Table of Entry symbols ');
         writeln(fentry,'corresponding to ',fnam,'.INL');
         writeln(fentry);
       end;
       write(fentry,symbol);
       for x:=1 to 8-length(symbol) do write(fentry,' ');
       writeln(fentry,' =  $',hex(hi(nn)),Hex(lo(nn)));
       EntryCnt:=EntryCnt+1;
     end;
  8: begin
       getAfield(yy,nn);
       write('External - offset         --> ');
       writeln('$',Hex(yy),'  $',Hex(hi(nn)),Hex(lo(nn)));
       Error(0);
     end;
  9: begin
       getAfield(yy,nn);
       write('External + offset         --> ');
       writeln('$',Hex(yy),'  $',Hex(hi(nn)),Hex(lo(nn)));
       Error(0);
     end;
  10:begin
       getAfield(yy,nn);
       write('Define Size of DATA area  --> ');
       writeln('$',Hex(hi(nn)),Hex(lo(nn)));
       DataSize:=nn;
     end;
  11:begin
       GetAfield(yy,nn);
       write('Set Loading LC to ');
       case yy of
       1: write('CSEG');
       2: write('DSEG');
       3: write('COMM');
       end;{ of case }
       writeln('    --> $',Hex(hi(nn)),Hex(lo(nn)));
       case yy of
       1: LC:=Pbase+nn;
       2: LC:=Dbase+nn;
       3: LC:=Tsize+nn;
       end;{ of case }
     end;
  12:begin
       getAfield(yy,nn);
       write('Chain Address             --> ');
       writeln('$',Hex(yy),'  $',Hex(hi(nn)),Hex(lo(nn)));
       nextloc:=nn;nextcode:=yy;
       while nextcode+nextloc>0 do
       begin
         nextloc:=WrkRec.contents;WrkRec.contents:=LC;
         nextcode:=WrkRec.typecode;
         MemWrite(nn,WrkRec);MemRead(nn+1,WrkRec);
         nextloc:=nextloc+swap(WrkRec.contents);
         writeln('loc = $',hex(hi(nextloc)),hex(lo(nextloc)));
         WrkRec.contents:=LC;
         MemWrite(nn+1,WrkRec);
         nn:=nextloc;MemRead(nn,WrkRec);
       end;
     end;
  13:begin
       getAfield(yy,ProgSize);
       writeln('Define PROGRAM Size       --> $',
       Hex(hi(ProgSize)),Hex(lo(ProgSize)));
       Dbase:=ProgSize+3;{ create space for JP ENDofDSEG }
       Tsize:=ProgSize+DataSize;
       if datasize>0 then tsize:=tsize+3;
       if Tsize>Maxloc then Error(1)
       else begin
         WrkRec.typecode:=0; WrkRec.contents:=0;
         for x:=0 to Tsize-1 do MemWrite(x,WrkRec);
         { Block-Data space (DS) initialized to null-bytes }
       end;
     end;
  14:begin
       getAfield(yy,nn);
       writeln('END of PROGRAM');
       Bitcnt:=-1; { forces to next byte boundary }
     end;
  15:begin
       Stop:=true;
       writeln('END of FILE');
     end;
  end;{ of case }
end;


begin
  init;
  While not STOP do
  begin
    if Getbit=0 then loadbyte
    else begin
      case relcode of
      0:SpecialLink;
      1:LoadProgRel;
      2:LoadDataRel;
      3:LoadCommRel;
      end;{ of case }
    end;
  end;

  writeln(LF,LF,'diagnostics for linkage of file ',fnam,'.REL',LF);
  writeln('Free workspace available : ',Maxloc:5,' bytes');
  if Tsize<Maxloc then
  writeln('Total workspace used     : ',(Tsize+ExtCnt*9):5,' bytes')
  else writeln('Code size exeeds work space');
  writeln('Total code size          : ',Tsize:5,' bytes');
  writeln('Code segment size        : ',Progsize:5,' bytes');
  writeln('Data segment size        : ',Datasize:5,' bytes');
  if Tsize<Maxloc then
  begin
    if ExtCnt>0 then
    writeln('number of externals      : ',ExtCnt:5)
    else writeln('no externals used');
    if EntryCnt>0 then
    writeln('number of entry-points   : ',EntryCnt:5)
    else writeln('no entry points defined');
  end;

  LC:=0;
  if EntryCnt>0 then close(fentry);
  if ErrorCnt>0 then
  begin
    writeln(f);
    writeln(ErrorCnt:3,' fatal error(s) detected',LF);
    write('make inline-file anyway (Y/N)? ');read(kbd,c);
    if Upcase(c)<>'Y' then
    begin
      writeln('N');
      if EntryCnt>0 then erase(fentry);
      goto 9999;
    end else writeln('Y');
  end else writeln('no fatal errors detected');

  writeln(PrtOff);
  writeln('creating ',fnam,'.INL...');
  write('Bytes written : ',#27,'.0');
  assign(inlfil,fnam+'.INL');rewrite(inlfil);
  write(inlfil,' INLINE({00000} ');

  while LC < Tsize do
  begin
    MemRead(LC,WrkRec);
    case WrkRec.typecode of
    0: begin
         write(inlfil,'$',Hex(WrkRec.contents));
         LC:=LC+1;
       end;
    1: begin
         offset:=WrkRec.contents;
         MemRead(LC+1,WrkRec);
         offset:=offset+swap(WrkRec.contents)-LC;
         if offset>0 then write(inlfil,'*+',offset)
                     else write(inlfil,'*',offset);
         LC:=LC+2;
       end;
    2: begin
         ExtCnt:=WrkRec.contents;
         MemRead(LC+1,WrkRec);
         ExtCnt:=ExtCnt+swap(WrkRec.contents);
         GetExtrnl(ExtCnt,symbol);
         write(inlfil,symbol);
         LC:=LC+2;
       end;
    else
       begin
         write('Internal error, program aborted');
         close(inlfil);erase(inlfil);
         goto 9999;
       end;
    end;{ of case }

    if LC < Tsize
    then write(inlfil,'/') else writeln(inlfil,');');
    if (LC=ProgSize) and (Datasize>0) then
    begin
      writeln(inlfil,'$C3/*+',Tsize-LC-1,'/');
      LC:=LC+3;
      writeln(inlfil,'        { start of DATA segment }');
      Str(LC,s);for i:=length(s) to 4 do s:='0'+s;
      write(inlfil,'        {',s,'} ');
      count:=0;
    end;
    count:=(count+1) mod 10;
    if count=0 then
    begin
      writeln(inlfil);
      Str(LC,s);for i:=length(s) to 4 do s:='0'+s;
      write(inlfil,'        {',s,'} ');
    end;
    write(LC:5,^H,^H,^H,^H,^H);
  end;
  close(inlfil);
9999:
  writeln(#27,'.2');
  close(relfil);
end.
