{Include-file MAILSYS.INC}
overlay procedure mailsys;

const
  maxlength = 24;
  maxlenstr = '24';
  maxmess = 75;
type
  messages = record
  number:  integer;
  sender:  integer;
  recver:  integer;
  subject: name;
  date:    name;
  private: boolean;
  section: byte;
  repto:   integer;
  reply:   integer;
  recved:  boolean;
  end;
  messtext = array[1..maxlength] of line;
var
  messagefile: file of messages;
  count: integer;
  messtable: array[1..maxmess] of messages;
  preformat: boolean;
  choice: char;

function namemess(number: integer): name;
  var
    filename: name;
  begin
    str((10000 + number):6, filename);
    namemess:=messdrive+'MESS'+copy(filename,3,4)+'.TXT';
  end;

procedure kill(x:integer);
  var
    victim: text;
  begin
    assign(victim,namemess(x));
{$I-}
    erase(victim);
{$I+}
    if IOresult<>0 then lineout('Bericht staat niet op de disk.')
  end;

function secure(tabloc:byte): boolean;
  begin
  with messtable[tabloc] do
  secure := ((usernum <> sender)
  and (usernum <> recver)
  and (access < sysop))
  or (usernum = 0);
  end;

procedure initmess;
  begin
    if cts and messnew then lineout(cr+lf);
    count := 0;
    nextmess := 1;
    assign(messagefile, 'MESSAGES.BBS');
    {$I-} reset(messagefile) {$I+};
    if IOresult = 0 then begin
      while (count < maxmess) and not eof(messagefile) do begin
        count := count + 1;
        read(messagefile, messtable[count]);
      end;
      close(messagefile);
      if count > 0 then nextmess := messtable[count].number + 1;
    end;
    messopen:=true;
    str(count,templ);
    lineout('Er zijn ......... : '+templ+' berichten.');
    str(nextmess, templ);
    lineout('Volgende bericht  : '+templ);
  end;

function findmessage(x: integer): byte;
  var
    loop:byte;
  begin
    loop:=0;
    findmessage:=0;
    if count>0 then begin
    repeat
    loop:=loop+1;
    until (loop>=count) or (messtable[loop].number >= x);
    if messtable[loop].number = x
    then findmessage := loop
    else findmessage := 0;
    end;
  end;


procedure header(tabloc: byte);
  begin
    if not cancelled then
    if cts then with messtable[tabloc] do begin
      str(number:4, templ);
      lineout(cr+lf);
      if private then lineout('Prive bericht... ');
      lineout('Bericht #'+templ);
      templ := getname(sender);
      lineout('Afzender.....: '+templ);
      if recver > 0 then templ:=getname(recver) else templ := 'IEDEREEN';
      if recved then templ:=templ+' (Ontv)';
      lineout('Verzonden aan: ' + templ);
      lineout('Onderwerp....: ' + subject);
      lineout('Tijd/datum...: ' + date);
      if sectsin then lineout('Sectie.......: ' + sect[section]);
      lineout(space);
    end;
  end;

procedure destroy(tabloc: byte);
  var
    loop: byte;
  begin
    if tabloc > 0 then begin
    kill(messtable[tabloc].number);
    for loop := tabloc+1 to count do
    messtable[loop-1]:=messtable[loop];
    if tabloc=count then nextmess:=nextmess-1;
    count:=count-1;
    lineout('Bericht gewist.');
    end;
  end;

procedure readfile(tabloc: byte);
  begin
  if cts then begin
  outfile(namemess(messtable[tabloc].number));
  lineout(space);
  if (messtable[tabloc].recver = usernum) and (usernum > 0)
  then messtable[tabloc].recved := true;
  if cts and (tabloc > 1) and not secure(tabloc) then begin
  if getcap('Wissen (j/N)? ') in ['Y','J'] then destroy(tabloc);
  end;
  end;
  end;

procedure readmess(number: integer);
  var tabloc: byte;
  begin
    tabloc := findmessage(number);
    if tabloc = 0 then lineout('Bericht niet gevonden.')
    else if (secure(tabloc) and messtable[tabloc].private)
    then lineout('Prive bericht.')
    else begin
    header(tabloc);
    readfile(tabloc);
    end;
  end;

procedure delmessage(x: integer);
  var
    tabloc: byte;
  begin;
    tabloc := findmessage(x);
    if cts then begin
    if tabloc > 0 then begin
    if not secure(tabloc) then begin
    header(tabloc);
    if getcap('Weet U het zeker (J/N)? ') in ['Y','J']
    then destroy(tabloc);
    end
    else lineout('U kunt dat bericht niet verwijderen!');
    end
    else lineout('Bericht niet gevonden.');
    end;
  end;


procedure deletex;
  begin
    if cts then delmessage(getint(nextmess - 1, 0, 'Wissen, welk nummer: '));
  end;

procedure quickscan;
  var
    loop: byte;
    first: integer;
  begin
    if cts then begin
    first := getint(nextmess - 1, lastmess + 1,'Start scan bij welk nummer (*= nieuw): ');
    if first > 0 then begin
    clearsc;
    curof;
    lineout(space);
    for loop := 1 to count do
    if (messtable[loop].number >= first)
    and not (secure(loop) and messtable[loop].private)
    and cts and not cancelled
    then header(loop);
    end;
    end;
  end;

function findfirst(startmess: integer): byte;
  var loop : byte;
  begin
    loop := 0;
    if count > 0 then repeat
      loop := loop + 1;
    until (messtable[loop].number >= startmess) or (loop = count);
    findfirst := loop;
  end;

function getfirst: byte;
  var
    startmess : integer;
  begin
    repeat
    startmess := getint(nextmess - 1, lastmess + 1, 'Start bij welk bericht (?= status, *= nieuw): ');
    if startmess = -1 then status;
    until (startmess <> -1) or not cts;
    if startmess = 0 then getfirst := 1
    else getfirst := findfirst(startmess);
  end;

procedure messagesearch(first:byte; fromnum, tonum:integer; sectnum:byte);
  var
    loop: byte;
    inch: char;
    oldnum: integer;
    matched: boolean;
  begin
    matched := false;
    inch := null;
    loop := first;
    while cts and (loop <= count) and (inch <> 'Q') and (count <> 0) do begin
    oldnum := messtable[loop].number;
    if ((fromnum = 0) or (fromnum = messtable[loop].sender))
    and ((tonum = 0) or (tonum = messtable[loop].recver))
    and ((sectnum = 0) or (sectnum = messtable[loop].section))
    and not (secure(loop) and messtable[loop].private)
    then begin
    matched := true;
    cancelled := false;
    header(loop);
    inch := getcap('Lezen (j/N/quit)? ');
    if inch in ['Y','J'] then readfile(loop);
    end;
    if messtable[loop].number = oldnum then loop := loop + 1;
    end;
    if cts and not matched then lineout('Geen berichten gevonden.');
  end;


procedure receive;
  var
    uchar: char;
procedure readind;
  var
   messnum: integer;
   tabloc : byte;
  begin
    repeat
    messnum := getint(nextmess - 1, 0, 'Welk nummer (geef 0 om te stoppen): ');
    if messnum > 0 then readmess(messnum);
    until (messnum <= 0) or not cts;
  end;

procedure readfrom;
  var
    fromnum: integer;
    first: byte;
  begin
    if cts then begin
    fromnum := getid('Geef naam van de afzender: ');
    if fromnum < 1
    then stringout('Naam fout!')
    else begin
    first := getfirst;
    if first > 0 then messagesearch(first, fromnum, 0, 0);
    end;
    end;
  end;

procedure readto;
  var
    tonum: integer;
    first: byte;
  begin
    if cts then begin
    tonum := getid('Geef naam van geaddresseerde: ');
    if tonum < 1 then stringout('Geen User!')
    else begin
    first := getfirst;
    if first > 0 then messagesearch(first, 0, tonum, 0);
    end;
    end;
  end;

procedure readsect;
  var
    first: byte;
    inch: integer;
  begin
    if cts then repeat
    if sectsin then
    inch := getint(numsects, 0, 'Geef sectie (0 voor allemaal, ? voor lijst): ')
    else inch := 1;
    if inch=-1 then listsections
    else if inch in [0..numsects] then begin
    first := getfirst;
    if first > 0 then messagesearch(first, 0, 0, inch);
    end;
    until (inch <> -1) or not cts;
  end;

  begin
    if cts then begin
      clearsc;
      if not expert then outfile(readmenu);
      repeat
      uchar := getcap('Lees mode: (A,I,F,T,S, of ? voor menu): ');
      if uchar = '?' then outfile(readmenu);
      until (uchar in ['A','I','F','T','S',cr]) or not cts;
      if uchar = 'I' then readind;
      if cts and (uchar <> 'I') then begin
      case uchar of
      'A': messagesearch(getfirst,0,0,0);
      'F': readfrom;
      'T': readto;
      'S': readsect;
      end;
      end;
    end;
  end;

procedure closemess;
  var
    loop: byte;
  begin
    rewrite(messagefile);
    for loop := 1 to count do
    write(messagefile, messtable[loop]);
    close(messagefile);
    messopen := false;
  end;

procedure enter;
  var
    tabloc: byte;
    messbuff: messtext;
    linenum: byte;
    inch: char;

  procedure compose(var block: messtext; var linenum: byte);
    var
      temp: name;
    begin
    CUROF;
    lineout(space);
    lineout('Voer tekst in: ' + maxlenstr + ' regels van 80 karakters max.');
    lineout('Een lege regel eindigt bericht. " " aan begin van regel geeft nieuwe regel.');
    lineout(space);
    CURON;
    if linenum < maxlength then repeat
    linenum := linenum + 1;
    str(linenum:2, temp);
    stringout(temp + ': ');
    block[linenum] := inputstring(echo);
    until (linenum = maxlength) or (block[linenum] = '') or not cts;
    if block[linenum] = '' then linenum := linenum - 1;
    end;

  procedure list(var block: messtext; first, last: byte);
    var
      loop: byte;
      temp: name;
    begin
      if (first > 0) and (last > 0) and cts then begin
      loop := first;
      while (loop <= last) and (not cancelled) and cts do begin
      str(loop:2, temp);
      stringout(temp + ': ');
      lineout(block[loop]);
      loop := loop + 1;
      end;
      lineout(space);
      end;
    end;

  procedure delline(var block: messtext; linenum: byte; var maxline: byte);
    var temp: char;
        loop: byte;
    begin
      list(block, linenum, linenum);
      if cts and (linenum > 0) then begin
      temp := getcap('Wissen: zeker weten (j/N)? ');
      if temp in ['Y','J'] then begin
      for loop := linenum+1 to maxline do block[loop-1] := block[loop];
      block[maxline] := '';
      maxline := pred(maxline);
      lineout('Regel gewist!');
      end;
      end;
    end;

  procedure edit(var block: messtext; linenum: byte);
    var
      newstring: line;
      posn     : integer;
    begin
      if (linenum > 0) and cts then begin
      list(block, linenum, linenum);
      templ := getinput('Te vervangen tekst : ', 80, echo);
      newstring := getinput('Vervangen door: ', 80, echo);
      posn := pos(templ, block[linenum]);
      if posn <> 0 then begin
      delete(block[linenum], posn, length(templ));
      insert(newstring, block[linenum], posn);
      list(block, linenum, linenum);
      end
      else lineout('Oude tekst niet gevonden.');
      lineout(space);
      end;
    end;

  procedure replace(var block: messtext; linenum: byte);
    begin
      if (linenum > 0) and cts then begin
      lineout('Oude regel:');
      list(block, linenum, linenum);
      lineout('Nieuwe regel:');
      stringout('? ');
      block[linenum] := inputstring(echo);
      end;
    end;

  function whichline(linenum: byte): byte;
    var
      temp: name;
      x   : integer;
    begin
      str(linenum:2, temp);
      x := getint(linenum, 0, ' Welke regel (1 - ' + temp + '): ');
      if (x <= 0) or not cts then whichline := 0 else whichline := x;
    end;

  procedure newheader(var entry: messages);
    var
      temp, tonum: integer;
    begin
      if cts then begin
        entry.sender := usernum;
        tonum := getid('Aan wie, <RETURN> voor IEDEREEN: ');
        if tonum = 0 then lineout('Bericht voor: IEDEREEN');
        entry.recver := tonum;
        entry.subject := getinput('Onderwerp (15 karakters max.)? ', 15, echo);
        clock(date, month, hour, min, sec);
        entry.date := time(date, month, hour, min, sec);
        if sectsin then repeat
        temp := getint(numsects, 0, 'Geef sectie ("?" voor lijst): ');
        if temp = -1 then listsections;
        if temp in [1..numsects] then entry.section := temp;
        until (temp in  [1..numsects]) or not cts
        else entry.section := 1;
        if tonum > 0 then entry.private := getcap('Prive bericht (J/N)? ') in ['Y','J']
        else entry.private := false;
        entry.reply := 0;
        entry.repto := 0;
        entry.number := nextmess;
        entry.recved := false;
      end;
    end;

  procedure storemess(var block: messtext; tabloc, lastline: byte);
    var
      outfile: text;
      linenum: byte;
    begin
      if cts then begin
        lineout('Bericht wordt opgeslagen...');
        assign(outfile, namemess(nextmess));
        rewrite(outfile);
        linenum := 1;
        while linenum <= lastline do begin
        if (copy(block[linenum],1,1) = ' ') or preformat then begin
        writeln(outfile);
        if not preformat then
        block[linenum]:=copy(block[linenum],2,length(block[linenum])-1);
        end
        else write(outfile,' ');
        write(outfile, block[linenum]);
        linenum:=linenum+1;
        end;
        writeln(outfile);
        close(outfile);
        nextmess:=nextmess+1;
        count:=count+1;
      end;
    end;

  begin
    preformat := false;
    if cts then begin
      clearsc;
      if access < reg then lineout('U kunt nog geen berichten versturen: Gebruik [A]anvragen commando.')
      else begin
      tabloc := count + 1;
      if tabloc > maxmess then lineout('Geen ruimte voor een nieuw bericht!')
      else begin
      repeat
      newheader(messtable[tabloc]);
      header(tabloc);
      inch := getcap('Is dit OK (J/N of Quit)? ');
      until (inch <> 'N') or not cts;
      if inch <> 'Q' then begin
      linenum := 0;
      compose(messbuff, linenum);
      if not expert then outfile(editmenu);
      repeat
      inch := getcap('Edit commando: A,W,E,L,N,Q,S,V of ? voor menu ');
      case inch of
      'A': compose(messbuff, linenum);
      'W': delline(messbuff, whichline(linenum), linenum);
      'E': edit(messbuff, whichline(linenum));
      'L': list(messbuff, whichline(linenum), linenum);
      'S': begin preformat := true; storemess(messbuff, tabloc, linenum); end;
      'V': replace(messbuff, whichline(linenum));
      'N': storemess(messbuff, tabloc, linenum);
      '?': outfile(editmenu);
       end;
       until (inch = 'Q')
       or (inch = 'S')
       or (inch = 'N')
       or not cts;
       end;
       end;  {2nd else}
      end;  {1st else}
    end; {if cts}
  end; {enter}

procedure readmine;
  begin
    if cts and (usernum>0) then begin
      lineout('Even kijken of er post voor U is...');
      messagesearch(1,0,usernum,0);
    end;
  end;

begin
  if cts then initmess;
  if not messnew then readmine;
  if messnew then
  begin
  if not expert then outfile(postmenu);
    repeat
    clock(nudate,numonth,nuhour,numin,nusec);
    timenu:=time(nudate,numonth,nuhour,numin,nusec);
    templ:='<'+timenu+'> POST-MENU (?= menu): ';
    gotoXY(1,24);
    choice := getcap(templ);
    case choice of
      'E' : enter;
      'K' : deletex;
      'N' : messagesearch(findfirst(lastmess + 1), 0, 0, 0);
      '?' : outfile(postmenu);
      'R' : receive;
      'S' : quickscan;
      'G' : disconnect;
    end; {case}
    until (choice = 'M') or not cts;
    if cts then begin clearsc;lineout('Terug naar het Hoofdmenu...');end;
  end;   {if messnew}
  messnew := true;
  if messopen then closemess;
 end;
