unit ssixelcr ;

 interface

 {
   Module  : SSXIXELCR

   Author  : Hans Otten

   Version : 1.3  11-feb-1991

   Facility: Sixel/PCX/MSX routines

   Purpose : output pixels to
               - sixel file




  }
   uses

     CNV ;


  procedure Init_output_sixel(display_info : display_infotype ;
                        parse_info : parse_infotype ;
                        colormap : colormap_type) ;

  procedure Close_output_sixel ;

  procedure Add_pixel_sixel(x,y,color : integer ) ;


implementation

  uses

    SOUTBUF ;

  const

    mask : array[1..6] of integer = ($01,$02,$04,$08,$10,$20) ;

  type

    scanline_type = array[1..max_pixel_col] of byte ;

  var

    scanline : scanline_type ;
    sixel_buffer : array[1..6] of scanline_type ;
    msx_bytes,
    dumped_lines,                         { nr of pixel lines written }
    bottom_line : integer ;
    cdisplay_info : display_infotype ;
    remap : array[0..max_color] of byte ;
    scanline_count,
    previous_row,
    max_col  : integer ;
    back_color,
    white_color : integer ;
    sixel_mono : boolean ;

  procedure CRLF ;

    begin

      pixel_write(13) ;
      pixel_write(10) ;

    end ; { CRLF }

  procedure Init_output_sixel(display_info : display_infotype ;
                              parse_info : parse_infotype ;
                              colormap : colormap_type) ;

    var

      line,
      remap_count,
      count : integer ;

    procedure write_sixel_header ;


      var

        stri : string ;
        color_count : color_values ;
        count       : integer ;

      procedure write_color_spec(count : integer) ;

        var

          color : integer ;
          color_count : color_values ;

        begin

          pixel_write(ord('#')) ;
          str(remap_count:1,stri) ;
          pixel_write_string(stri) ;
          pixel_write(ord(';')) ;
          pixel_write(ord('2')) ;
          for color_count := c_red to c_blue do
            begin
              pixel_write(ord(';')) ;
              color := round((colormap[count].colors[color_count]*100)/255) ;
              if (cdisplay_info.sdevice = slj250) and
                 (color > 0)
                 then
                   color := color + 3 + (100 - color) div 5 ;
                   if color > 100
                     then color := 100 ;
              str(color:1, stri) ;
              pixel_write_string(stri) ;
            end ;
          CRLF ;

        end ; { write_color_spec }

    procedure specify_colors ;

      var

        stri : string ;
        color_count : color_values ;
        count       : integer ;

      begin

        remap_count := 0 ;
        white_color := -1 ;
        { write color information }
        for count := 0 to max_color do
          begin
            if colormap[count].used
              then
                begin
                  remap[count] := remap_count ;
                  { check if this is white }
                  if (colormap[count].colors[c_red] = colormax) and
                     (colormap[count].colors[c_blue] = colormax) and
                     (colormap[count].colors[c_green] = colormax)
                    then
                      white_color := remap_count ;
                  write_color_spec(count) ;
                  inc(remap_count) ;
                end ;
          end ;
        { if white not found, then add a color number as white }
        if (white_color < 0)
          then
            begin
              if parse_info.used_colors = max_color
                then
                  white_color := 0
                else
                  begin
                    white_color := max_color ;
                    for color_count := c_red to c_blue do
                      colormap[max_color].colors[color_count] := colormax ;
                    remap[white_color] := max_color ;
                    write_color_spec(max_color) ;
                  end ;
            end ;
        end ; { specify colors }

      begin

        { write sixel header }
        pixel_write(27) ;
        pixel_write(ord('P')) ;

        for count := 1 to 2 do
          begin
             pixel_write(ord('0')) ;
             pixel_write(ord(';')) ;
          end ;
        pixel_write(ord('9')) ;
        pixel_write(ord('q')) ;
        pixel_write(ord('"')) ;
{
        if parse_info.raster_valid
          then
            begin
              str(parse_info.r_attributes[1]:1,stri) ;
              pixel_write_string(stri) ;
              pixel_write(ord(';')) ;
              str(parse_info.r_attributes[2]:1,stri) ;
              pixel_write_string(stri) ;
              pixel_write(ord(';')) ;
            end
}
              { default values for LJ250 }
              pixel_write(ord('1')) ;
              pixel_write(ord(';')) ;
              pixel_write(ord('1')) ;
              pixel_write(ord(';')) ;
              with cdisplay_info do
                begin
                   str(((end_view_col - start_view_col + 1) * enlarge_h):1,stri) ;
                   pixel_write_string(stri) ;
                   pixel_write(ord(';')) ;
                   str(((end_view_row - start_view_row + 1) * enlarge_v):1,stri) ;
                   pixel_write_string(stri) ;
                end ;
        CRLF ;

        back_color := -1 ;
        sixel_mono := false ;
        if (cdisplay_info.sdevice = slj250) or
           (cdisplay_info.sdevice = snodevice)
          then
            specify_colors
          else
            begin
              { suppress background }
              if (colormap[0].colors[c_red] +
                  colormap[0].colors[c_green] +
                  colormap[0].colors[c_blue]) >
                 (colormap[1].colors[c_red] +
                  colormap[1].colors[c_green] +
                  colormap[1].colors[c_blue])
                then
                  back_color := 1
                else
                  back_color := 0 ;

              remap[0] := 0 ;
              remap[1] := 1 ;
              sixel_mono := true ;
              white_color := back_color ;

            end ;

      end ; { write_sixel_header }


    begin { main Init_output }

      cdisplay_info := display_info ;

      with cdisplay_info do
          max_col := (end_view_col - start_view_col + 1) * enlarge_h ;
      bottom_line := 1 ;
      scanline_count := 1 ;
      previous_row := 1 ;
      for line := 1 to 6 do
        for count := 1 to max_col do
          sixel_buffer[line][count] := white_color ;
       write_sixel_header ;

    end ; { Init_output }


  procedure dump_sixelline ;

    var

      color_inuse : array[0..max_color] of boolean ;
      color_nr : integer ;
      sixel_count, col_count : integer ;
      pixel_save : array[1..max_pixel_col] of byte ;

    function combine_sixel (col, color : integer) : integer ;

      {
        combines the six pixels in current sixelline
        in this column with this color
      }

      var

        newpixel,
        count      : integer ;

      begin

        newpixel := 0 ;
        for count := 1 to 6 do
            if sixel_buffer[count][col] = color
              then
                newpixel := newpixel or mask[count] ;
        combine_sixel := newpixel + $3F ;

      end ; { combine_sixel }

    procedure dump_pixel_save ;

      {
        array pixel_save is filled on entry with pixel char's
        for this color
        this array is dumped to the sixel file with the repeat
        facility of sixel
      }

      var

        maxrow,
        pixel_repeat,
        count      : integer ;
        prev_sixel : byte ;
        stri : string ;

      procedure dump_sixel ;

        { write out current sixel (repeated) }

        var

          stri : string ;

        begin

          pixel_repeat := pixel_repeat ;
          if pixel_repeat > 1
            then
              begin
                pixel_write(ord('!')) ;
                str(pixel_repeat:1,stri) ;
                pixel_write_string(stri) ;
                pixel_write(prev_sixel)
              end
            else
              pixel_write(prev_sixel) ;

        end ; { dump_sixel }

      begin { main dump_pixel_save }

        { specify the color }
        if not sixel_mono
          then
            begin
              pixel_write(ord('#')) ;
              str(color_nr:1,stri) ;
              pixel_write_string(stri) ;
            end ;
        pixel_repeat := 0 ;
        prev_sixel := $3F ;

        for count := 1 to max_col do
          begin
            if pixel_save[count] = prev_sixel
              then
                pixel_repeat := pixel_repeat + 1
              else { new pixel value }
                begin
                  { check if anything to dump }
                  if pixel_repeat > 0
                    then
                      dump_sixel ;
                  pixel_repeat := 1 ;
                  prev_sixel := pixel_save[count]
                end ;
          end ;

        if (pixel_repeat > 0)
          then
            dump_sixel ;
        pixel_write(ord('$')) ;
        CRLF ;

      end ; { dump_pixel_save }

    begin  { main dump_sixel_line }

      { determine colors in use in this line }
      for color_nr := 0 to max_color do
        color_inuse[color_nr] := false ;

      for col_count := 1 to max_col do
        for sixel_count := 1 to 6 do
          color_inuse[sixel_buffer[sixel_count][col_count]] := true ;

      { for every color in use in this sixel line do }
      for color_nr := 0 to max_color do
        begin
          if (color_inuse[color_nr]) and (color_nr <> back_color)
            then
              begin
                { for every column do }
                for col_count := 1 to max_col do
                  { if any pixel in this column has this color_nr }
                  pixel_save[col_count] :=
                      combine_sixel(col_count, color_nr) ;
                dump_pixel_save ;
              end ;
           end ; { for all colors }
        pixel_write(ord('-')) ;
        CRLF ;
      end ;


  procedure Flush_Buffer ;

    { flush output buffer contents to device }
    { buffer can be 1 to 6 lines             }

    var

      line,
      count : integer ;

    begin

      with cdisplay_info do
        begin
          { dump sixel line to output }
          dump_sixelline ;
          { make buffer available for next 6 lines }
          bottom_line := bottom_line + 6 ;
          { default buffer to color 0 }
          for line := 1 to 6 do
            for count := 1 to max_pixel_col do
              sixel_buffer[line][count] := white_color ;
        end ;

    end ; { Flush_buffer }


  procedure add_scanline ;

    begin

      if scanline_count > bottom_line + 5
        then
          Flush_buffer ;
      { add to buffer }
      { transform to buffer coordinates }
      sixel_buffer[scanline_count - bottom_line + 1] := scanline ;
      inc(scanline_count) ;

    end ; { add_scanline }


  procedure Add_pixel_sixel(x,y,color : integer) ;


    {
     add current pixel to scan line enlarged
    }

    var

      count : integer ;

    begin

      if y > previous_row
        then
          begin
            previous_row := y ;
            for count := 1 to cdisplay_info.enlarge_v do
              add_scanline ;
            for count := 1 to max_col do
              scanline[count] := white_color ;
          end ;
      for count := 1 to cdisplay_info.enlarge_h do
        scanline[(x - 1) * cdisplay_info.enlarge_h + count] := remap[color] ;


    end ;  { add_pixel_sixel }


  procedure Close_output_sixel ;

    var

      count : integer ;

    begin

      for count := 1 to cdisplay_info.enlarge_v do
        add_scanline ;
      Flush_buffer ;
      pixel_write(27) ;
      pixel_write(ord('\')) ;

    end ; { Close_output }


end. { unit ssixelcr }
