unit spcxcr ;

 interface

 {
   Module  : SPCXCR

   Author  : Hans Otten

   Version : 1.3  9-feb-1991

   Facility: Sixel/PCX/MSX routines

   Purpose : output pixels to
               - PCX file 1 plane 1 bit per pixel
               - PCX file 1 plane 8 bit per pixel
 }

 uses

  CNV ;


  procedure Init_output_PCX(display_info : display_infotype ;
                            parse_info : parse_infotype ;
                            colormap : colormap_type) ;

  procedure Close_output_PCX(colormap : colormap_type) ;

  procedure Add_pixel_PCX(x,y,color : integer );


implementation

  uses

    SOUTBUF ;


  var

    cdisplay_info : display_infotype ;

    bits : integer ;                 { nr of bits per plane  }
    nr_of_planes   : integer ;       { number of planes      }
    bytes_per_line : integer ;       { bytes per line needed }
    remap : array[0..max_color] of byte ;

    repeat_count,
    current_byte,
    previous_row,
    previous_byte,
    inbit_count,
    bit_count,
    nr_of_bits : integer ;

  procedure Init_output_PCX(display_info : display_infotype ;
                            parse_info : parse_infotype ;
                            colormap : colormap_type) ;

    var

      count,
      color_count,
      remap_count : integer ;
      col,
      row : integer ;


    begin { main Init_output_PCX }

      cdisplay_info := display_info ;
      with cdisplay_info do
        begin
          row := end_view_row - start_view_row + 1 ;
          col := end_view_col - start_view_col + 1 ;
        end ;
      with parse_info do
        begin
          if used_colors <= 2        { monochrome }
            then
              begin
                nr_of_planes :=  1 ;
                bits := 1 ;
              end
          else                                  { VGA palette }
            begin
              nr_of_planes := 1 ;
              bits := 8 ;
            end ;

          if bits = 1
            then
              begin
                bytes_per_line := col div 8 ;
                if (col mod 8) > 0
                  then
                    inc(bytes_per_line)
              end
          else { bits = 8}
            bytes_per_line := col ;

          { write manufacturer }
          pixel_write($0A) ;

          { version nr }
          pixel_write($05) ;

          { encoding runlength }
          pixel_write($01) ;

          { write bits per pixel }
          pixel_write(bits) ;

          { write window sizes }
          for count := 1 to 4 do               { low      }
            pixel_write(0) ;
          pixel_write((col - 1) mod 256) ; { high col }
          pixel_write((col - 1) div 256) ;
          pixel_write((row - 1) mod 256) ; { high row }
          pixel_write((row - 1) div 256) ;

          { dummy HDPI and VDPI }
          pixel_write(col mod 256) ; { high col }
          pixel_write(col div 256) ;
          pixel_write(row mod 256) ; { high row }
          pixel_write(row div 256) ;

          { determine remap for EGA colormap }
          remap_count := 0 ;
          for count := 0 to max_color do
            if colormap[count].used
              then
                begin
                  remap[count] := remap_count ;
                  inc(remap_count) ;
                end  ;

          { write colormap EGA }
          if used_colors <= 2
            then
              begin
                for color_count := 0 to 1 do
                  begin
                    pixel_write(colormap[remap[color_count]].colors[c_red]) ;
                    pixel_write(colormap[remap[color_count]].colors[c_green]) ;
                    pixel_write(colormap[remap[color_count]].colors[c_blue]) ;
                  end ;
                for count := 0 to 41 do
                  pixel_write(0) ;
              end
            else  { fill with zero's }
              for count := 0 to 47 do
                pixel_write(0) ;


          { write nr of planes }
          pixel_write(0) ;  { reserved }
          pixel_write(nr_of_planes) ;

          { write bytes per line }
          pixel_write(bytes_per_line mod 256) ;
          pixel_write(bytes_per_line div 256) ;

          for count := 68 to 127 do
          pixel_write(0) ;

          { initialise packing }
          bit_count := 0 ;
          inbit_count := 0 ;
          current_byte := 0 ;
          previous_byte := 0 ;
          repeat_count := 0 ;
          previous_row := 1 ;
          nr_of_bits := bytes_per_line * 8 ;
        end ;


    end ;

  procedure dump_repeat ;

    begin

      if repeat_count > 0
        then
          begin
            if (repeat_count = 1) and ((previous_byte and $C0) <> $C0)
              then
                pixel_write(previous_byte)
              else
                begin
                  pixel_write(repeat_count or $C0) ;
                  pixel_write(previous_byte) ;
                end ;
          end ;
      repeat_count := 0 ;

    end ;

  procedure Add_byte(b : byte) ;

    begin

      if b = previous_byte
        then
          begin
            if (repeat_count = 63)
              then
                dump_repeat ;
          end
        else
          dump_repeat ;
      previous_byte := b ;
      inc(repeat_count) ;

    end ; { add_byte }

  procedure add_bit(b : byte) ;

    { add bit (b is 0 or 1) to current_byte }

    begin

      b := remap[b] ;
      inc(bit_count) ;
      if inbit_count = 8
        then
          begin
            add_byte(current_byte) ;
            current_byte := 0 ;
            inbit_count := 0 ;
          end ;
      inc(inbit_count) ;
      current_byte := (current_byte shl 1) or b ;

    end ; { add_bit }

  procedure Flush_Buffer ;

    var

      count : integer ;

    begin

      { see if we promised more bits then delivered }
      if bits = 1
        then
          begin
            for count := (bit_count) to nr_of_bits do
              add_bit(0) ;
            bit_count := 0 ;
            inbit_count := 0 ;
            current_byte := 0 ;
          end ;
      dump_repeat ;

    end ; { Flush_buffer }


  procedure Close_output_PCX(colormap : colormap_type) ;

    var

      count : integer ;

    begin

      flush_buffer ;
      { write colormap if VGA map needed }
      if bits = 8
        then
          pixel_write(12) ;
          for count := 0 to max_color do
            begin
              pixel_write(colormap[count].colors[c_red]) ;
              pixel_write(colormap[count].colors[c_green]) ;
              pixel_write(colormap[count].colors[c_blue]) ;
            end ;

    end ; { Close_output_PCX }

  procedure Add_pixel_PCX(x,y,color : integer) ;


    {
     add current pixel to PCX file
    }


      begin

        { check if new scan line entered }
        if y > previous_row
          then
            begin
              Flush_buffer ;
              inc(previous_row) ;
            end ;
        { add pixel value to output buffer, PCX screen dependent }
        if bits = 8
          then
            add_byte(color)
          else
            add_bit(color) ;

      end ; { Add_PCX_pixel }

  end. { unit SPCXCR }