unit spct ;
{

   Module  : SPCT

   Author  : Hans Otten

   Version : 1.3  15-feb-1991

   Facility: Sixel/PCX/MSX routines

   Purpose : display/convert PCT (Dynamic Publisher pictures) files


   Routines:

              SCAN_PCT

              Display_PCT

}


interface

  uses

    CNV ;


procedure Scan_PCT (var parse_info : parse_infotype;
                    display_info : display_infotype ;
                    var colormap : colormap_type) ;

procedure Display_PCT(parse_info : parse_infotype ;
                      display_info : display_infotype ;
                      colormap : colormap_type ) ;


implementation

  uses

    CRT,
    SBUFFER, SGRAPH, SCREATE ;

  const

    max_PCT_row = 704 ;
    max_PCT_col_bytes = 64 ;
    max_PCT_col = 512 ;


  procedure Read_PCT_pixels(parse_info : parse_infotype ;
                            display_info: display_infotype ;
                            var colormap : colormap_type) ;

    { Read/scan PCT file }

  var

    count,
    row_count,
    col_byte_count,
    col_count,
    rep_count : integer ;
    pixel_line : array[1..max_pixel_col] of byte ;
    b : byte ;

    procedure Add_pixel_nibble(nibble : byte) ;

    {
      unpack pixels in nibble to add to pixel_line buffer
    }

    var

      count : integer ;

    begin

      for count := 1 to 4 do
        begin
          if ((nibble and 8) = 8)
            then
              pixel_line[col_count] := 1
            else
              pixel_line[col_count] := 0 ;
          inc(col_count) ;
          nibble := nibble shl 1 ;
        end ;

    end ; { Add_packed_nibble }


  begin

    { reset to first position of picture bytes }
    Reset_MSX_picture ;
    for count := 0 to $17F do
      b := ord(GetNextByte) ;

    for count := 1 to max_PCT_col do
      pixel_line[count] := 0 ;
    for row_count := 1 to max_PCT_row do
      begin
        if display_info.display <> video
          then
            write('Bezig met rij: ',row_count:1) ;
        col_byte_count := 0 ;
        col_count := 1 ;
        repeat
          { Get repeat count }
          b := ord(GetNextByte) ;
          if ((b and $80) = $80)
            then
              begin
                rep_count := (b and $7F) ;
                { Get databyte }
                b := ord(GetNextByte) ;
                for count := 0 to rep_count do
                  begin
                    add_pixel_nibble(b and $0F) ;
                    add_pixel_nibble(b shr 4) ;
                    inc(col_byte_count) ;
                  end ;
              end
            else
              begin
                rep_count := b ;
                for count := 0 to rep_count do
                  begin
                    b := ord(GetNextByte) ;
                    add_pixel_nibble(b and $0F) ;
                    add_pixel_nibble(b shr 4) ;
                    inc(col_byte_count) ;
                  end ;
              end ;

        until col_byte_count >= max_PCT_col_bytes ;

        for col_count := 1 to max_PCT_col do
          Add_pixel(col_count,row_count,pixel_line[col_count]) ;
        if keypressed
          then
            begin
              if display_info.display = video
                then
                  Close_graph ;
              exit
            end ;
        if display_info.display <> video
          then
            write(chr(13)) ;
      end ;
    if display_info.display = video
      then
        begin
          write(chr(7)) ;
          repeat until keypressed ;
        end
      else
        begin
          writeln ;
          writeln('Gereed') ;
        end ;

  end ; { Read_PCT_pixels }


procedure Scan_PCT (var parse_info : parse_infotype;
                    display_info : display_infotype ;
                    var colormap : colormap_type) ;

  var
    b  : byte ;
    count : integer ;
    publisher_string : string ;

  begin

    { read info from PCT header }
    count := 0 ;
    publisher_string := '' ;
    repeat
      publisher_string := publisher_string + GetNextByte ;
      count := count + 1 ;
    until count = 24 ;

    if (publisher_string <> 'DYNAMIC PUBLISHER SCREEN') and
       (publisher_string <> 'E U R O PUBLISHER SCREEN')
      then
        begin
          writeln ;
          writeln('x',publisher_string,'x') ;
          writeln('x','DYNAMIC PUBLISHER SCREEN','x') ;
        report_error(not_PCT,fatal,display_info.display) ;
        end ;

   { Dynamic Publisher screen is fixed width }
    parse_info.max_parse_col := 512 ;
    parse_info.max_parse_row := 704 ;

    { position at first data byte }
    for count := 24 to $17F do
      b := ord(GetNextByte) ;

    parse_info.mono := true ;
    colormap[1].defined := true ;
    colormap[1].used    := true ;
    colormap[1].colors[c_red] := 0 ;
    colormap[1].colors[c_green] := 0 ;
    colormap[1].colors[c_blue] := 0 ;
    colormap[0].defined := true ;
    colormap[0].used    := true ;
    colormap[0].colors[c_red]   := colormax ;
    colormap[0].colors[c_green] := colormax ;
    colormap[0].colors[c_blue]  := colormax ;
    for count := 2 to max_color do
      begin
        colormap[count].used := false  ;
        colormap[count].defined := false ;
      end ;

  end ; { Scan_PCT }


procedure Display_PCT(parse_info : parse_infotype;
                      display_info : display_infotype ;
                      colormap : colormap_type) ;


  begin

   Read_PCT_pixels(parse_info,display_info,colormap) ;

  end ; { Display_PCX }

end. { unit spct }
