unit smsx ;
{

   Module  : SMSX

   Author  : Hans Otten

   Version : 2.1  21-oct-1991

   Facility: MSX/Sixel/PCX convert/display routines

   Purpose : display/convert MSX files


}


interface

  uses

    CNV ;

procedure Scan_MSX(var parse_info : parse_infotype;
                   var colormap : colormap_type ;
                   display_info : display_infotype) ;


procedure Display_MSX(parse_info : parse_infotype;
                      colormap : colormap_type ;
                      display_info : display_infotype) ;


implementation

  uses

    CRT, SBUFFER, SGRAPH, SCREATE ;

  const

    BSAVE_ID = $FE ;  { MSX screen dumps start with BSAVE_ID byte }

    def57_palette : array[0..15,0..2] of byte =
                        ( (  0,  0,  0),    {  0 }
                          (  0,  0,  0),    {  1 }
                          ( 36,219, 36),    {  2 }
                          (109,255,109),    {  3 }
                          ( 36, 36,255),    {  4 }
                          ( 73,109,255),    {  5 }
                          (182, 36, 36),    {  6 }
                          ( 73,219,255),    {  7 }
                          (255, 36, 36),    {  8 }
                          (255,109,109),    {  9 }
                          (219,219, 36),    { 10 }
                          (219,219, 57),    { 11 }
                          ( 36,146, 36),    { 12 }
                          (219, 73,182),    { 13 }
                          (182,182,182),    { 14 }
                          (255,255,255)) ;  { 15 }

  var

    scr12_rgb : array[1..4] of byte ;

procedure Read_MSX_screen_pixels(parse_info : parse_infotype ;
                          var colormap : colormap_type ;
                          display_info : display_infotype) ;

  { read/parse MSX screen file }

  var

    nr_of_bytes,
    row_count, col_count : integer ;
    b : byte ;

  procedure Add57_byte(b : byte) ;

    { byte contains two pixels, first in high nibble }

    begin

      if display_info.display <> parse
        then
          begin
            Add_pixel((col_count*2 + 1 ), row_count, (b and $0F)) ;
            Add_pixel((col_count*2     ), row_count, (b shr 4)  ) ;
          end
        else
          begin
            colormap[(b and $0F)].used := true ;
            colormap[(b shr 4)  ].used := true ;
          end
    end ;

  procedure Add6_byte(b : byte) ;

    begin

      if display_info.display <> parse
        then
          begin
            Add_pixel((col_count * 4) - 3, row_count, ((b shr 6) and $03)) ;
            Add_pixel((col_count * 4) - 2, row_count, ((b shr 4) and $03)) ;
            Add_pixel((col_count * 4) - 1, row_count, ((b shr 2) and $03)) ;
            Add_pixel((col_count * 4)    , row_count, ((b      ) and $03)) ;
          end
        else
          begin
            colormap[((b      ) and $03)].used := true ;
            colormap[((b shr 2) and $03)].used := true ;
            colormap[((b shr 4) and $03)].used := true ;
            colormap[((b shr 6) and $03)].used := true ;
          end

    end ;

  procedure Add12_pixel(col, row : integer; by: byte) ;

    { 4 bytes together determine 4 pixels }

    var
      r,g,b : integer ;
      y : array[1..4] of integer ;
      k, l,
      byte_count : integer ;
      bk, bl     : boolean ;

    begin

if display_info.display <> parse
  then
    begin
      { store byte for further processing }
      byte_count := col_count mod 4 ;
      if byte_count > 0
        then
          scr12_rgb[byte_count] := by ;
      { if four bytes entered }
      if byte_count = 0
        then
          begin

            scr12_rgb[4] := by ;
            y[1] := scr12_rgb[1] shr 3 ;
            y[2] := scr12_rgb[2] shr 3 ;
            y[3] := scr12_rgb[3] shr 3 ;
            y[4] := scr12_rgb[4] shr 3 ;
            k  := (scr12_rgb[1] and 7) + ((scr12_rgb[2] and 3) * 8) ;
            l  := (scr12_rgb[3] and 7) + ((scr12_rgb[4] and 3) * 8) ;
            bk := ( (scr12_rgb[2] and 4) = 4 ) ;
            bl := ( (scr12_rgb[4] and 4) = 4 ) ;
            for byte_count := 1 to 4 do
              begin
                b := 0 ;
                if bk
                  then
                    begin
                      { no green component }
                      g := 0 ;
                      b := b + ((k xor 31) shr 4) ;
                    end
                  else
                    g := k + y[byte_count] ;
                if  bl
                  then
                    begin
                      { no red component }
                      r := 0 ;
                      b := b + ( (k xor 31) shr 2) ;
                    end
                  else
                    r := l + y[byte_count] ;

                b := b + round(y[byte_count] * 1.25) ;
                if b > 31
                  then
                    b := 31 ;
                { now we have rgb 0..31 ,
                  translate to color number in fixed palette }
                scr12_rgb[byte_count] := round( r * 5.0/ 31.0) * 6 +
                                         round( g * 5.0/ 31.0) * 36 +
                                         round( b * 5.0/ 31.0)  ;
              end ;
            if display_info.display <> parse
              then
                begin
                  add_pixel((col_count -3),row_count, scr12_rgb[1]) ;
                  add_pixel((col_count -2),row_count, scr12_rgb[2]) ;
                  add_pixel((col_count -1),row_count, scr12_rgb[3]) ;
                  add_pixel((col_count   ),row_count, scr12_rgb[4]) ;
                end ;
          end ;
    end ;
    end ;

  begin

    with parse_info do
      begin
        if (parse_msx_screen = scr5) or (parse_msx_screen = scr7)
          then
            begin
              nr_of_bytes := max_parse_col div 2 ;
              if odd(max_parse_col)
                then
                  inc(nr_of_bytes)
            end
        else if (parse_msx_screen = scr6) or (parse_msx_screen = stp6)
          then
            begin
              nr_of_bytes := max_parse_col div 4 ;
              if odd(max_parse_col)
                then
                  inc(nr_of_bytes)
            end
        else if (parse_msx_screen = scr8) or (parse_msx_screen = scr12)
          then
            nr_of_bytes := max_parse_col ;
        for row_count := 1 to max_parse_row do
          begin
            if display_info.display <> video
              then
                write('Rij ',row_count:1) ;
            for col_count := 1 to nr_of_bytes do
              begin
                b := ord(GetNextByte) ;
                if (parse_msx_screen = scr5) or (parse_msx_screen = scr7)
                  then
                    Add57_byte(b)
                else if (parse_msx_screen = scr6) or (parse_msx_screen = stp6)
                  then
                    Add6_byte(b)
                else if parse_msx_screen = scr8
                  then
                    begin
                      if display_info.display <> parse
                        then
                          Add_pixel(col_count,row_count,b)
                        else
                          colormap[b].used := true ;
                    end
                else if parse_msx_screen = scr12
                  then
                    Add12_pixel(col_count,row_count,b)
              end ;
          if display_info.display <> video
            then
              write(chr(13)) ;
          if keypressed
            then
              begin
                if display_info.display = video
                  then
                    Close_Graph ;
                writeln ;
                exit ;
              end ;
        end ;
      end ;
    if display_info.display <> video
      then
        begin
          writeln ;
          writeln('Klaar')
        end
      else
        begin
          writeln(chr(7)) ;
          repeat
          until keypressed ;
        end ;

  end ; { Read_MSX_screen_pixels }

procedure Read_MSX_Copy_pixels(var parse_info : parse_infotype ;
                          var colormap : colormap_type ;
                          display_info : display_infotype) ;

  { read/parse MSX screen or copy file }

  var

    row_count,
    col_count : integer ;
    b : byte ;

  procedure Next_col ;

    begin

      with parse_info do
        begin
          inc(col_count) ;
          if col_count > parse_info.max_parse_col
            then
              begin
                col_count := 1 ;
                inc(row_count) ;
                if display_info.display <> video
                  then
                    write('Rij ',row_count:1,chr(13)) ;
                if keypressed
                  then
                    begin
                      if display_info.display = video
                        then
                          Close_graph ;
                      row_count := parse_info.max_parse_row + 1
                    end ;
               end
          end ;

    end ; { Next_col }

  procedure Add57_byte(b : byte) ;

    { byte contains two pixels, first in high nibble }

    begin

      if display_info.display <> parse
        then
          begin
            Add_pixel((col_count ), row_count, (b shr 4)  ) ;
            Next_col ;
            Add_pixel((col_count ), row_count, (b and $0F)) ;
            Next_col ;
          end
        else
          begin
            colormap[(b and $0F)].used := true ;
            Next_col ;
            colormap[(b shr 4)  ].used := true ;
            Next_col ;
          end
    end ;

  procedure Add6_byte(b : byte) ;

    begin

      if display_info.display <> parse
        then
          begin
            Add_pixel((col_count), row_count, ((b shr 6) and $03)) ;
            Next_col ;
            Add_pixel((col_count), row_count, ((b shr 4) and $03)) ;
            Next_col ;
            Add_pixel((col_count), row_count, ((b shr 2) and $03)) ;
            Next_col ;
            Add_pixel((col_count), row_count, ((b      ) and $03)) ;
            Next_col ;
          end
        else
          begin
            colormap[((b      ) and $03)].used := true ;
            Next_col ;
            colormap[((b shr 2) and $03)].used := true ;
            Next_col ;
            colormap[((b shr 4) and $03)].used := true ;
            Next_col ;
            colormap[((b shr 6) and $03)].used := true ;
            Next_col ;
          end

    end ;

  begin

    with parse_info do
      begin
        row_count := 1 ;
        col_count := 1 ;
        if display_info.display <> video
          then
            write('Rij ',row_count:1,chr(13)) ;
        while row_count <= max_parse_row do
          begin
            b := ord(GetNextByte) ;
            if parse_msx_screen = scr8
              then
                begin
                  if display_info.display <> parse
                    then
                      Add_pixel(col_count,row_count,b)
                    else
                      colormap[b].used := true ;
                   Next_col ;
                end
            else if (parse_msx_screen = scr5) or (parse_msx_screen = scr7)
              then
                Add57_byte(b)
            else if (parse_msx_screen = scr6) or (parse_msx_screen = stp6)
              then
                Add6_byte(b)
           end ;
      end ;
    if display_info.display <> video
      then
        begin
          writeln ;
          writeln('Klaar')
        end
      else
        begin
          writeln(chr(7)) ;
          repeat
          until keypressed ;
        end ;

  end ; { Read_MSX_pixels }


procedure Scan_MSX   (var parse_info : parse_infotype;
                      var colormap : colormap_type ;
                      display_info : display_infotype) ;

  var

    next_char : char ;
    color_nr : integer ;

  procedure Parse_MSX_screenheader ;

    var

      yesno : string ;
      is_msx : boolean ;
      start_address,
      end_address  : word ;
      count : integer ;
      next_char : char ;

    begin

      with parse_info do
        begin
          if (parse_msx_screen = scr5) or
             (parse_msx_screen = scr8) or
             (parse_msx_screen = scr12)
            then
              max_parse_col := 256
            else
              max_parse_col := 512 ;

          is_msx := true ;
          { read header with ID byte, begin, end, and start address }
          next_char := GetNextByte ;
          is_msx :=  (ord(next_char) =  BSAVE_ID) ;

          { read start address }
          start_address := ord(GetNextByte) ;
          start_address := ord(GetNextByte) * 256 + start_address ;
          end_address := ord(GetNextByte) ;
          end_address := ord(GetNextByte) * 256 + end_address  ;

          if not is_msx
            then
              begin
                write('Is dit wel een MSX-plaatje [J/n] ') ;
                Get_string(yesno) ;
                if yesno[1] = 'N'
                  then
                    begin
                      report_error(not_msx_screen,
                                   fatal,
                                   display_info.display) ;
                      exit ;
                    end
                  else
                    begin
                      start_address := 0 ;
                      end_address := $d3FF ;
                    end ;
              end ;

          if (parse_msx_screen = scr5) or
             (parse_msx_screen = scr7)
               then
                 max_parse_row := 2 * ((end_address - start_address + 1)
                                       div max_parse_col)
          else if (parse_msx_screen = scr6) or
                  (parse_msx_screen = stp6)
            then
              max_parse_row := 4 * ((end_address - start_address + 1)
                                   div max_parse_col )
          else if (parse_msx_screen = scr8) or
                  (parse_msx_screen = scr12)
            then
              max_parse_row := ((end_address - start_address + 1)
                               div max_parse_col ) ;

          if max_parse_row < 1
            then
              begin
                report_error(not_msx_screen,fatal,display_info.display) ;
                exit ;
              end ;
          { skip execution address }
          next_char := GetNextByte ;
          next_char := GetNextByte ;
        end ;

    end ; { Parse_MSX_screenheader }

  procedure Parse_MSX_copyheader ;

    var

      x, y : integer ;

    begin

      { read start address }
      x := ord(GetNextByte) ;
      x := ord(GetNextByte) * 256 + x ;
      y := ord(GetNextByte) ;
      y := ord(GetNextByte) * 256 + y  ;

      parse_info.max_parse_row := y ;
      parse_info.max_parse_col := x ;

    end ;  { Parse_MSX_copyheader }

  procedure fill_colormap8  ;

    {
        colormap for screen 8 is fixed
        color specification for all possible colors for MSX screen 8
        databyte = 7 6 5 4 3 2 1 0   R = 0 - 7
                   G G G R R R B B   G = 0 - 7
                                 B = 0 - 3  (lsb not stored)
      }


      var

        r, g, b,
        vr, vg, vb  : integer ;
        color_nr : integer ;

      begin

        color_nr := 0 ;
        for g := 0 to 7 do
          begin
            vg := round(g * (255.0 / 7.0)) ;
            for r := 0 to 7 do
              begin
                vr := round(r * (255.0 / 7.0)) ;
                for b := 0 to 3 do
                  begin
                    vb := round(b * (255.0 / 3.0)) ;
                    colormap[color_nr].colors[c_red] := vr ;
                    colormap[color_nr].colors[c_green] := vg ;
                    colormap[color_nr].colors[c_blue] := vb ;
                    colormap[color_nr].defined := true ;
                    inc(color_nr) ;
                  end ;
              end ;
          end ;

      end ; { fill_colormap_8 }

  procedure fill_fixed_colormap12  ;

    {
        colormap for screen 12 fixed
    }


      var

        r, g, b,
        vr, vg, vb  : integer ;
        color_nr : integer ;

      begin

        color_nr := 0 ;
        for g := 0 to 5 do
          begin
            vg := round(g*(255.0 /5.0)) ;
            for r := 0 to 5 do
              begin
                vr := round(r * (255.0 / 5.0)) ;
                for b := 0 to 5 do
                  begin
                    vb := round(b * (255.0 / 5.0)) ;
                    colormap[color_nr].colors[c_red] := vr ;
                    colormap[color_nr].colors[c_green] := vg ;
                    colormap[color_nr].colors[c_blue] := vb ;
                    colormap[color_nr].defined := true ;
                    colormap[color_nr].used := true ;
                    inc(color_nr) ;
                  end ;
              end ;
          end ;
      end ; { fill_fixed_colormap12 }

    procedure fill_colormap57 ;

      {
        fill colormap either with palettefile info
        or with default palette
      }

      const

        msx57_palettecolors = 16 ;
        palettesize = 7 + msx57_palettecolors * 2 ;

      var

        no_palette  : boolean ;
        palettename : string ;
        palettefile : file ;
        palettebuffer : array[1..palettesize] of byte ;
        color_nr,
        bytes_read : integer ;


        procedure get_palette_name ;

          var

            ch : char ;
            default_name : string ;

          begin

            with parse_info do
              begin
                default_name := 'PL' ;
                if parse_msx_screen = scr5
                  then
                    default_name := 'PL5'
                else if parse_msx_screen = scr6
                  then
                    default_name := 'PL6'
                else if parse_msx_screen = scr7
                  then
                    default_name := 'PL7'
                else if parse_msx_screen = scr8
                  then
                    default_name := 'PL8' ;
              end ;

            default_name := parse_info.filename + '.' + default_name ;
            repeat
              palettename := '' ;
              write('Naam palette file (ESCAPE voor geen) [',
                     default_name,']? ') ;
              repeat
		ch := readkey ;
                ch := Upcase(ch) ;
		if ch in ['A'..'Z','0'..'9','&','%','-','_','!','(',')','.',':']
                  then
                    begin
                      write(ch) ;
                      palettename := palettename + ch ;
                    end ;
              until (ch = chr(13)) or (ch = chr(27)) ;
              no_palette := (ch = chr(27)) ;
              writeln ;
              if length(palettename) = 0
                then
                  palettename := default_name ;
              assign(palettefile,palettename) ;
              {$I-}
              reset(palettefile,1) ;
              {$I+}
            until (IOResult = 0) or no_palette ;

          end ; { get_palette_name }


      begin

        get_palette_name ;
        if not no_palette
          then
            begin
              blockread(palettefile,palettebuffer,
                        palettesize,bytes_read) ;
              if bytes_read <> palettesize
                then
                  begin
                    report_error(nopalette,warning,display_info.display) ;
                    no_palette := true ;
                  end
                else
                  begin
                    { check header }
                    if (palettebuffer[1] = $FE) and
                       (palettebuffer[2] = $80) and
                       (palettebuffer[4] = $9F)
                      then
                        begin
                          bytes_read := 8 ;
                          for color_nr := 0 to msx57_palettecolors - 1 do
                            begin
                              colormap[color_nr].defined := true ;
                              colormap[color_nr].colors[c_red] :=
                                round((palettebuffer[bytes_read] shr 4) * colormax / 7) ;
                              colormap[color_nr].colors[c_green] :=
                                round((palettebuffer[bytes_read + 1]) * colormax / 7) ;
                              colormap[color_nr].colors[c_blue] :=
                                round((palettebuffer[bytes_read] and $0F) * colormax / 7) ;
                              bytes_read := bytes_read + 2 ;
                            end ;
                        end
                      else
                        no_palette := true ;
                  end ;
            end ;

        { if no palette or invalid palettefile fill with default }
        if no_palette
          then
            begin
              for color_nr := 0 to 15 do
                begin
                  colormap[color_nr].defined := true ;
                  colormap[color_nr].colors[c_red  ] := def57_palette[color_nr,0] ;
                  colormap[color_nr].colors[c_green] := def57_palette[color_nr,1] ;
                  colormap[color_nr].colors[c_blue ] := def57_palette[color_nr,2] ;
                end ;
            end ;

      end ; { fill_colormap57 }


    procedure fill_colormap6 ;

      begin

        colormap[0].defined  := true ;
        colormap[0].colors[c_red]   :=    0 ;
        colormap[0].colors[c_green] :=    0 ;
        colormap[0].colors[c_blue]  :=    0 ;
        colormap[1].defined  := true ;
        colormap[1].colors[c_red]   :=    0 ;
        colormap[1].colors[c_green] :=    0 ;
        colormap[1].colors[c_blue]  :=    0 ;
        colormap[2].defined  := true ;
        colormap[2].colors[c_red]   :=   36 ;
        colormap[2].colors[c_green] :=  219 ;
        colormap[2].colors[c_blue]  :=   36 ;
        colormap[3].defined  := true ;
        colormap[3].colors[c_red]   :=  109 ;
        colormap[3].colors[c_green] :=  219 ;
        colormap[3].colors[c_blue]  :=  109 ;

      end ;


    procedure fill_colormap_stp6 ;

      begin

        colormap[0].defined  := true ;
        colormap[0].colors[c_red]   := colormax ;
        colormap[0].colors[c_green] := colormax ;
        colormap[0].colors[c_blue]  := colormax ;
        colormap[1].defined  := true ;
        colormap[1].colors[c_red]   :=    0 ;
        colormap[1].colors[c_green] :=    0 ;
        colormap[1].colors[c_blue]  :=    0 ;
        colormap[2].defined  := true ;
        colormap[2].colors[c_red]   :=  109 ;
        colormap[2].colors[c_green] :=  colormax ;
        colormap[2].colors[c_blue]  :=  109 ;
        colormap[3].defined  := true ;
        colormap[3].colors[c_red]   :=   73 ;
        colormap[3].colors[c_green] :=  109 ;
        colormap[3].colors[c_blue]  :=  colormax ;

      end ;

  procedure fill_colormap12 ;

    begin

      writeln('Voor scherm 12 wordt een vast palette gebruikt') ;
      fill_fixed_colormap12 ;

    end ; { fill_colormap12 }

  begin  { main Scan_MSX }

    with parse_info do
      begin
        if parse_msx_type = mscreen
          then
            Parse_MSX_screenheader
          else
            Parse_MSX_copyheader ;
        if (parse_msx_screen = scr6)
          then
            fill_colormap6
        else if parse_msx_screen = scr8
          then
            fill_colormap8
        else if parse_msx_screen = scr12
          then
            fill_colormap12
        else if (parse_msx_screen = scr5) or
                (parse_msx_screen = scr7)
          then
            fill_colormap57
        else if (parse_msx_screen = stp6)
          then
            fill_colormap_stp6
      end ;

    if parse_info.parse_msx_type = mcopy
      then
        Read_MSX_copy_pixels(parse_info, colormap, display_info)
      else
        Read_MSX_screen_pixels(parse_info, colormap, display_info) ;

  end ; { Scan_MSX }


procedure Display_MSX(parse_info : parse_infotype;
                        colormap : colormap_type ;
                        display_info : display_infotype) ;

  var

    skip_bytes,
    count : integer ;
    next_char : char ;

  begin

    Reset_MSX_picture ;

    { skip header }
    if parse_info.parse_msx_type = mcopy
      then
        skip_bytes := 4
      else
        skip_bytes := 7 ;
    for count := 1 to skip_bytes do
      next_char := GetNextByte ;


    if parse_info.parse_msx_type = mcopy
      then
        Read_MSX_copy_pixels(parse_info, colormap, display_info)
      else
        Read_MSX_screen_pixels(parse_info, colormap, display_info) ;

  end ; { Display_MSX }


{ end SMSX.INC }

end. { unit smsx }