{

   Module  : SDISPLAY.INC

   Author  : Hans Otten

   Version : 1.1  23-dec-1990

   Facility: Sixel routines

   Purpose : display/convert sixelfile


   Routines:

             CheckParameters

              takes as input name of sixelfile otherwise
              gives help

             AskDisplayInfo

               Inquire user about: output device (video display, sixel or MSX)
                                   viewport for display/convert

             Scan_sixelfile

              first pass through sixel file to
              determine colors used, heigth, width
              and parameters

             Display_sixelfile : display/convert sixelfile
}


Procedure CheckParameters ;

  {

    command line syntax:

      SIXCNV picture-file qualifiers


    To work upon a picture-file we need to know the following:

      - name of picture-file
      - source type
          o MSX-5,6,7,8 screen
          o MSX 5,6,7,8 copy
          o sixel
      - destination type
          o MSX-5,6,7,8 screen
          o MSX 5,6,7,8 copy
          o sixel
          o video
      - window to show or convert
        if video
          preferred display-mode
            VGA       320x200 in 256 colors
            EGA/VGA   640x350 in 16  colors
            Automatic (dependent colors/resolution)

      Checkparameters asks for name and inputfile

  }

  var

    count : integer ;

  procedure ShowHelp ;

    {
      show of argument is help a screen full of information
    }

    begin

      writeln('') ;
      writeln('V1.2 Hans Otten 1990') ;
      writeln('') ;
      writeln('Command line syntax:') ;
      writeln('') ;
      writeln('  CNVSIX picture-file picture-type output-type') ;
      writeln('') ;
      writeln('where') ;
      writeln('') ;
      writeln('    picture-file is file to show or convert') ;
      writeln('') ;
      writeln('    picture-type is: sixel, MSX*C, MSX*S') ;
      writeln('') ;
      writeln('    output-type is: video, sixel, MSX*C, MSX*S') ;
      writeln('') ;
      writeln('      and * is: 5,6,7,8') ;
      writeln('') ;
      writeln('CNVSIX help : shows this help screen') ;
      writeln('') ;

    end ; { ShowHelp }


  begin

    { say hello }
    writeln('CNVSIX display and convert sixel and MSX pictures') ;
    writeln('V1.1 jan 1991 Hans Otten') ;
    writeln(' (type CNVSIX HELP for more information)') ;
    writeln ;

    picture_name[0]   := chr(0) ;

    { see if help wanted }
    if (paramcount = 1) and
       ( (paramstr(1) = 'help') or (paramstr(1) = 'HELP'))
      then
        begin
          ShowHelp ;
          halt ;
        end ;

    if paramcount >= 1
      then
        picture_name := paramstr(1)
    else
      begin
        write('Name of picture-file? ');
        readln(picture_name) ;
        if length(picture_name) = 0
          then
            halt(0) ;
      end ;
    if paramcount >= 2
      then
        picture_type := paramstr(2)
      else
        begin
          repeat
            write('Type of picture-file? ') ;
            readln(picture_type) ;
            if length(picture_type) = 0
              then
                halt(0) ;
            for count := 1 to length(picture_type)
              do
               picture_type[count] := Upcase(picture_type[count]) ;
          until (picture_type = MSX5S) or
                (picture_type = MSX6S) or
                (picture_type = MSX7S) or
                (picture_type = MSX8S) or
                (picture_type = MSX5C) or
                (picture_type = MSX6C) or
                (picture_type = MSX7C) or
                (picture_type = MSX8C) or
                (picture_type = SIXEL)
        end ;
    if paramcount >= 3
      then
        output_type := paramstr(3) ;

  end ; { CheckParameters }


function Getvalue(default_value : integer) : integer ;

  var

    s : string[30]  ;
    value, pos : integer;
    default : boolean ;

  begin

    default := true ;
    readln(s) ;
    value := 0 ;
    pos := 1 ;
    while s[pos] = ' ' do
      pos := pos + 1 ;
    while (s[pos] in ['0'..'9']) and (pos <= length(s)) do
      begin
        default := false ;
        value := value * 10 + ord(s[pos]) - ord('0') ;
        pos := pos + 1 ;
      end ;
    if default
      then
        Getvalue := default_value
      else
        Getvalue := value ;

  end ; { Getvalue }

procedure AskDisplayInfo (parse_info : parse_infotype) ;

  {
    Inquire user about: - output device (video display, sixel or MSX)
                        - viewport for display/convert
  }

  var

    count : integer ;
    valid_window : boolean ;

  begin

    with display_info do
    begin
    repeat
      write('Destination (screen, exit, sixel, MSX*C, MSX*S) ? ') ;
      readln(output_type) ;
      if length(output_type) = 0
        then
          output_type := exit ;
       for count := 1 to length(output_type)
         do
           output_type[count] := Upcase(output_type[count]) ;
    until (output_type = MSX5S)  or
          (output_type = MSX6S)  or
          (output_type = MSX7S)  or
          (output_type = MSX8S)  or
          (output_type = MSX5C)  or
          (output_type = MSX6C)  or
          (output_type = MSX7C)  or
          (output_type = MSX8C)  or
          (output_type = SIXEL)  or
          (output_type = SCREEN) or
          (output_type = EXIT) ;
    if output_type = sixel
      then
        display := sixelfile
    else if output_type[1] = 'M'
      then
        display := msx
    else if output_type = screen
      then
        display := video
    else if output_type = exit
      then
        display := quit ;

    if display <> quit
      then
        repeat
         start_view_col := 1 ;
         write('Enter start column [',start_view_col:1,'] :' ) ;
         start_view_col:= getvalue(start_view_col) ;
         end_view_col := parse_info.max_parse_col ;
         write('Enter end column [',end_view_col:1,'] :' ) ;
         end_view_col := getvalue(end_view_col) ;
         start_view_row := 1 ;
         write('Enter start row [',start_view_row:1,'] :') ;
         start_view_row := getvalue(start_view_row) ;
         end_view_row := parse_info.max_parse_row ;
         write('Enter end row [',end_view_row:1,']: ') ;
         end_view_row := getvalue(end_view_row) ;

         valid_window := true ;
         if (start_view_col < 1) or
            (end_view_col   < 1) or
            (start_view_row < 1) or
            (end_view_row   < 1) or
            (start_view_col >= end_view_col) or
            (start_view_row >= end_view_row)
           then
             begin
               valid_window := false ;
               writeln('Invalid display boundaries, try again')  ;
             end
        until valid_window ;
    end ;

  end ; { AskDisplayInfo }

procedure Scan_picture_file(var parse_info : parse_infotype ;
                            var colormap : colormap_type) ;

  {
    Scan_picture_file    : first pass through picture file to
                   determine colors used, heigth, width
                   and parameters
  }

  begin

   display_info.display := parse ;
   OpenFiles(picture_name) ;
   Init_parse(parse_info, colormap) ;
   if picture_type = sixel
     then
       begin
         reset_error ;
         parse_DCS(parse_info, display_info) ;
         parse_raster_attributes(parse_info,display_info) ;
         parse_picture_data(parse_info, colormap, display_info) ;
       end
     else if picture_type = MSX8S
       then
         begin
           scan_msx8s(parse_info, colormap)
         end
     else if picture_type = MSX6C
       then
         begin
           scan_msx6C(parse_info, colormap)
         end ;
   CloseFiles ;
   Display_Parse_info (parse_info, colormap) ;

  end ; { Scan_picturefile }


procedure Display_picture_file (parse_info : parse_infotype ;
                                colormap : colormap_type) ;

  {
    display/convert picture file to selected display
  }

  procedure sixel_init ;

    {
      initialize sixel output
    }

    var

      sixel_name : string[255] ;
      color_count : color_values ;
      count,
      stat : integer ;


    begin

      { open sixel file }
      repeat
        write('Name of sixel file? ') ;
        readln(sixel_name) ;
        assign(outputfile, sixel_name) ;
        {$I-}
        rewrite(outputfile) ;
        {$I+}
        stat := IOresult ;
        if stat <> 0
          then
            writeln('Unable to open sixel file for output') ;
      until stat = 0 ;

      { write sixel header }
      write(outputfile,chr(27),'P') ;
      for count := 1 to 3 do
        write(outputfile,parse_info.ps[count], ';') ;
      write(outputfile,'q') ;
      writeln(outputfile,'"', parse_info.r_attributes[1]:1, ';',
                              parse_info.r_attributes[2]:1,
                         ';',
                         parse_info.max_parse_col:1,';',
                         parse_info.max_parse_col:1) ;


      { write color information }
      for count := 0 to max_color do
        begin
          if colormap[count].used
            then
              begin
                write(outputfile, '#', count:1, ';2') ;
                for color_count := c_red to c_blue do
                  write(outputfile, ';',
                   round((colormap[count].colors[color_count]*100)/colormax):1) ;
                writeln(outputfile) ;
              end ;
        end ;

    end ; { sixel_init }

  procedure msx_init ;

    {
      initialize msx screen format output
    }

    var

      msx_name : string[255] ;
      stat     : integer ;
    begin

      { open msx screen file }

      { open sixel file }
      repeat
        write('Name of MSX screen file? ') ;
        readln(msx_name) ;
        assign(outputfile, msx_name) ;
        {$I-}
        rewrite(outputfile) ;
        {$I+}
        stat := IOresult ;
        if stat <> 0
          then
            writeln('Unable to open MSX screen file for output') ;
      until stat = 0 ;

      { write screen header }

    end ; { msx_init }

  procedure Graph_Init ;

    {
      determine high or low resolution
      for VGA low resolution = 320x200 in 256 colors
              high           = 640x450 in 16 colors
    }

    begin

      if vdisplay = auto
        then
          begin
            if ( ((display_info.end_view_row - display_info.start_view_row + 1) <= 200) and
                 ((display_info.end_view_col - display_info.start_view_col + 1) <= 320)    ) or
               (parse_info.used_colors > 16)
              then
                VGraphInit(vlow, parse_info.used_colors, colormap)
              else
                VgraphInit(vhigh, parse_info.used_colors, colormap)
          end
      else if vdisplay = high
        then
          VgraphInit(vhigh, parse_info.used_colors, colormap)
      else
        VgraphInit(vlow, parse_info.used_colors, colormap) ;

    end ;

  procedure sixel_close ;

    {
      close sixel output
    }

    begin

      { write sixel trailer }
      { close sixel file }
      close(outputfile) ;

    end ; { sixel_close }

  begin  { main display_picturefile }

    with display_info do
    begin
    repeat

      vdisplay := auto ;
      AskDisplayInfo(parse_info) ;
      if display <> quit
        then
          begin
            OpenFiles(picture_name) ;
            if display = video
              then
                Graph_Init
            else if display = sixelfile
              then
                sixel_init
            else if display = msx
              then
                msx_init ;

            { read input one pixel at a time and send it to Add_Pixel }
            if picture_type = sixel
              then
                begin
                  reset_error ;
                  parse_DCS(parse_info, display_info) ;
                  parse_raster_attributes(parse_info,display_info) ;
                  parse_picture_data(parse_info, colormap, display_info) ;
                end
            else if picture_type = MSX8S
              then
                begin
                  display_MSX8S(parse_info,colormap)
                end
            else if picture_type = MSX6C
              then
                begin
                  display_MSX6C(parse_info, colormap)
                end ;
            CloseFiles ;
            if display = video
              then
                CloseGraph
            else if display = sixelfile
              then
                sixel_close
            else if display = msx
              then
                close(outputfile) ;
          end ;
    until display = quit ;
    end ;

  end ; { Display_picturefile }


