/****************************************************************
 * GE5 Viewer													*
 * (c) 2001  Arjan Bakker										*
 ****************************************************************/


//include standard files
#include <windows.h>


//include own headers
#include "resource.h"
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

//classname/title window
TCHAR szClassName[] = TEXT("GE5 Viewer");


HWND hWnd;					//handle of main window
HACCEL hAccel;				//handle of accelerator keys

HBITMAP hBitmap;
HINSTANCE g_hInstance;

OPENFILENAME opn;			//structure for opening/saving file's using common dialogs
char szStrFile[256];		//path+file name
char szStrFilet[256];		//filename
char szStrFilter[] = ".GE5 files\0*.ge5\0\0";	//filter

int bFile = FALSE;


//change title of main window
void SetWindowTitle()
{
char szTitle[300];	//this should be long enough :)

	strcpy(szTitle, szClassName);	//copy classname into title

	if (bFile == TRUE)				//check for file edited
	{
		strcat(szTitle, " - [");
		strcat(szTitle, szStrFile);		//copy filename after it
		strcat(szTitle, "]");			//close it
	}

	SetWindowText(hWnd, szTitle);	//change window title
}


//load a .GE5-file into a bitmap and make it 2 times as big
HBITMAP LoadAgeImageBig(char* szFileName)
{
unsigned char* lpcFileData;		//pointer to data read from file
PALETTEENTRY Palette[16];		//palette-entries
int iHandle;					//file handle
int iOffset;					//offset in data read from file
unsigned char cColorTable[] = {0,47,79,111,143,175,207,255};		//Color conversion table
unsigned char cColor1, cColor2, cColor3, cColor4, cColor5, cColor6;	//color data read from .GE5-file
unsigned char cBits[525 * 6];	//array with pixeldata

	HDC hdcTemp = GetDC(hWnd);	//get device from current window
	HDC hDC = CreateCompatibleDC(hdcTemp);	//create a compatible device
	HBITMAP hBitmap = CreateCompatibleBitmap(hdcTemp, 256 * 2, 212 * 2);	//create a bitmap

	SelectObject(hDC, hBitmap);		//select bitmap into hDC

	BITMAPINFOHEADER bmih;			//create a structure with info about the bitmap
	bmih.biBitCount = 24;			//bits per pixel
	bmih.biClrImportant = 0;		//all colors should be used
	bmih.biClrUsed = 65536;			//maximum of 256 colors
	bmih.biCompression = BI_RGB;	//no compression
	bmih.biHeight =212 * 2;	//height in pixels of bitmap
	bmih.biPlanes = 1;				//one plane
	bmih.biSize = sizeof(bmih);		//size of structure
	bmih.biSizeImage = 0;			//zero for BI_RGB bitmaps
	bmih.biWidth = 256 * 2;			//width in pixels of bitmap

	//horizontal resolution in pixels per meter
	bmih.biXPelsPerMeter = GetDeviceCaps(hDC, HORZRES) / GetDeviceCaps(hDC, HORZSIZE);
	
	//vertical resolution in pixels per meter
	bmih.biYPelsPerMeter = GetDeviceCaps(hDC, VERTRES) / GetDeviceCaps(hDC, VERTSIZE);

	BITMAPINFO bmi;			//structure with bitmap info
	bmi.bmiHeader = bmih;	//select bitmapinfoheader bmih

	iHandle = _open(szFileName, _O_BINARY | _O_RDONLY);	//open file
	lpcFileData = new unsigned char[_filelength(iHandle)];		//create enough space to load entire file
	_read(iHandle, lpcFileData, _filelength(iHandle));	//read entire file
	_close(iHandle);									//close file

	//create palette-data
	for (int c = 0; c < 16; c++)	//loop through palette-data
	{
		Palette[c].peRed = cColorTable[(lpcFileData[30343 + c * 2] >> 4)];	//fill in red component
		Palette[c].peBlue = cColorTable[(lpcFileData[30343 + c * 2] % 16)];	//fill in blue component
		Palette[c].peGreen = cColorTable[(lpcFileData[30344 + c * 2])];		//fill in green component
	}

	iOffset = 7;	//colordata starts at this offset

	for (int y = 0; y < 212; y++)	//vertical resolution of image is 212 pixels
	{
		for (int x = 0; x < 128; x++)			//4 bits per pixel, 2 colors per byte
		{
			cColor1 = lpcFileData[iOffset] / 16;	//get left pixel from byte
			cColor2 = lpcFileData[iOffset] % 16;	//get right pixel from byte
			
			if (x != 127)
				cColor3 = lpcFileData[iOffset + 1] / 16;
			else
				cColor3 = cColor2;

			cBits[x * 12 + 0] = Palette[cColor1].peBlue;	//set blue component left pixel
			cBits[x * 12 + 1] = Palette[cColor1].peGreen;	//set green component left pixel
			cBits[x * 12 + 2] = Palette[cColor1].peRed;		//set red component left pixel

			//interpolated pixel
			cBits[x * 12 + 3] = (Palette[cColor1].peBlue + Palette[cColor2].peBlue) / 2;	//set blue component left pixel
			cBits[x * 12 + 4] = (Palette[cColor1].peGreen + Palette[cColor2].peGreen) / 2;	//set green component left pixel
			cBits[x * 12 + 5] = (Palette[cColor1].peRed + Palette[cColor2].peRed) /2;		//set red component left pixel

			cBits[x * 12 + 6] = Palette[cColor2].peBlue;	//set blue component right pixel
			cBits[x * 12 + 7] = Palette[cColor2].peGreen;	//set green component right pixel
			cBits[x * 12 + 8] = Palette[cColor2].peRed;		//set red component right pixel

			//interpolated pixel
			cBits[x * 12 + 9]  = (Palette[cColor2].peBlue + Palette[cColor3].peBlue) / 2;	//set blue component right pixel
			cBits[x * 12 + 10] = (Palette[cColor2].peGreen + Palette[cColor3].peGreen) / 2;	//set green component right pixel
			cBits[x * 12 + 11] = (Palette[cColor2].peRed + Palette[cColor3].peRed) / 2;		//set red component right pixel

			iOffset++;	//go to next address
		}

		//copy line to bitmap
		SetDIBits(hDC, hBitmap, (212 * 2) - (2 * y) - 1, 1, (void*)cBits, &bmi, DIB_RGB_COLORS);

		iOffset-=128;

		//completely interpolated line
		for (x = 0; x < 128; x++)			//4 bits per pixel, 2 colors per byte
		{
			cColor1 = lpcFileData[iOffset] / 16;	//get left pixel from byte
			cColor2 = lpcFileData[iOffset] % 16;	//get right pixel from byte
			
			if (x != 127)
				cColor3 = lpcFileData[iOffset + 1] / 16;
			else
				cColor3 = cColor2;

			if (y < (212 - 1))
			{
				cColor4 = lpcFileData[iOffset + 128] / 16;
				cColor5 = lpcFileData[iOffset + 128] % 16;

				if (x != 127)
					cColor6 = lpcFileData[iOffset + 129] / 16;
				else
					cColor6 = cColor5;
			}
			else
			{
				cColor4 = cColor1;
				cColor5 = cColor2;

				if (x != 127)
					cColor6 = cColor3;
				else
					cColor6 = cColor5;
			}

			cBits[x * 12 + 0] = (Palette[cColor1].peBlue + Palette[cColor4].peBlue) / 2;	//set blue component left pixel
			cBits[x * 12 + 1] = (Palette[cColor1].peGreen + Palette[cColor4].peGreen) / 2;	//set green component left pixel
			cBits[x * 12 + 2] = (Palette[cColor1].peRed + Palette[cColor4].peRed) / 2 ;		//set red component left pixel

			//interpolated pixel
			cBits[x * 12 + 3] = (Palette[cColor1].peBlue + Palette[cColor2].peBlue  + 
								 Palette[cColor4].peBlue + Palette[cColor5].peBlue) / 4;	//set blue component left pixel
			cBits[x * 12 + 4]=  (Palette[cColor1].peGreen + Palette[cColor2].peGreen + 
								 Palette[cColor4].peGreen + Palette[cColor5].peGreen) / 4;	//set green component left pixel
			cBits[x * 12 + 5]=  (Palette[cColor1].peRed + Palette[cColor2].peRed +	//set red component left pixel
								 Palette[cColor4].peRed + Palette[cColor5].peRed) / 4;

			cBits[x * 12 + 6] = (Palette[cColor2].peBlue + Palette[cColor5].peBlue) / 2;	//set blue component right pixel
			cBits[x * 12 + 7] = (Palette[cColor2].peGreen + Palette[cColor5].peGreen) / 2;	//set green component right pixel
			cBits[x * 12 + 8] = (Palette[cColor2].peRed + Palette[cColor5].peRed) / 2;		//set red component right pixel

			//interpolated pixel
			cBits[x * 12 + 9] = (Palette[cColor2].peBlue + Palette[cColor3].peBlue  + 
								 Palette[cColor5].peBlue + Palette[cColor6].peBlue) / 4;	//set blue component left pixel
			cBits[x * 12 + 10]= (Palette[cColor2].peGreen + Palette[cColor3].peGreen + 
								 Palette[cColor5].peGreen + Palette[cColor6].peGreen) / 4;	//set green component left pixel
			cBits[x * 12 + 11]= (Palette[cColor2].peRed + Palette[cColor3].peRed +	//set red component left pixel
								 Palette[cColor5].peRed + Palette[cColor6].peRed) / 4;

			iOffset++;	//go to next address
		}

		SetDIBits(hDC, hBitmap, (212 * 2) - (2 * y) - 2, 1, (void*)cBits, &bmi, DIB_RGB_COLORS);
	}

	delete [] lpcFileData;	//remove array with file data

	DeleteDC(hDC);
	ReleaseDC(hWnd, hdcTemp);

	return hBitmap;	//operation successfull
}


//open a file
LRESULT FileLoad()
{
	szStrFile[0] = '\0';						//empty string
	
	opn.lStructSize = sizeof(OPENFILENAME);
	opn.hwndOwner = hWnd;						//owner window
	opn.hInstance = g_hInstance;				//hinstance
	opn.lpstrFilter = szStrFilter;				//use this filter
	opn.lpstrCustomFilter = NULL;				//no custom filter
	opn.nFilterIndex = 0;						//use first option of filter
	opn.lpstrFile = szStrFile;					//string to store filename+path 
	opn.nMaxFile = 255;
	opn.lpstrFileTitle = szStrFilet;			//string to store filename
	opn.nMaxFileTitle = 255;
	opn.lpstrInitialDir = NULL;					//standard init-dir
	opn.lpstrTitle = "Load leveldata";			//title
	opn.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_PATHMUSTEXIST;	//flags
	opn.lpstrDefExt = ".ge5";					//default extension
	
	if (GetOpenFileName(&opn))					//call Open File DialogBox
	{
		hBitmap = LoadAgeImageBig(szStrFile);
		bFile = TRUE;
		InvalidateRect(hWnd,NULL,FALSE);
		SetWindowTitle();
	}

	return TRUE;
}

		
//repaint main window
LRESULT WmPaint(HWND hWnd)
{
HDC hDC, hdcBitmap;
PAINTSTRUCT ps;

	hDC = BeginPaint(hWnd, &ps);

	if (bFile == TRUE)
	{
		hdcBitmap = CreateCompatibleDC(hDC);

		SelectObject(hdcBitmap, hBitmap);

		BitBlt(hDC,0,0,512,424,hdcBitmap,0,0,SRCCOPY);

		DeleteDC(hdcBitmap);
	}

	EndPaint(hWnd, &ps);

	return TRUE;
}


//Windows Procedure
LRESULT CALLBACK WindowProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
int wmID, wmEvent;

	switch(Msg)	//handle messages
	{
	case WM_COMMAND:	//vang commando's af
		wmID = LOWORD(wParam);
		wmEvent = HIWORD(wParam);

		switch (wmID)
		{
		case ID_MFILE_OPEN:
			return FileLoad();
		case ID_MFILE_EXIT:
			PostQuitMessage(0);
			break;
		default:
			break;
		}
		break;
	case WM_MOVE:
	case WM_SETFOCUS:
	case WM_SIZE:
	case WM_PAINT:			//paint message
		return WmPaint(hWnd);
	case WM_CLOSE:		//exit program
	case WM_DESTROY:	//Destroy Window
		PostQuitMessage(0);
		break;
	default:			//use default message processing
		return DefWindowProc(hWnd, Msg, wParam, lParam);
	}

	return 0;
}



//register class
void InitClass(HINSTANCE hInstance)
{
WNDCLASSEX wc;	//Windows Class

	wc.cbSize = sizeof(wc);
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH)COLOR_WINDOW;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hIcon = NULL;
	wc.hIconSm = NULL;
	wc.hInstance = hInstance;
	wc.lpfnWndProc = (WNDPROC) WindowProc;
	wc.lpszClassName = szClassName;
	wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU1);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	
	RegisterClassEx(&wc);	//register class
}


//startup procedure
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
MSG message;	//message struct for handling messages

	InitClass(hInstance);	//register our Bomberman Editor-class

	//create a window
	hWnd = CreateWindow(szClassName, szClassName, WS_CLIPCHILDREN|WS_BORDER|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,
						0, 0, 518, 469, NULL, NULL, hInstance, NULL);

	if (hWnd)
	{
		g_hInstance = hInstance;
		
		hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR1));
		
		if (strlen(lpCmdLine))
		{
			strcpy(szStrFile,lpCmdLine);
			hBitmap = LoadAgeImageBig(szStrFile);
			bFile = TRUE;
			SetWindowTitle();
		}

		ShowWindow(hWnd, nShowCmd);
		UpdateWindow(hWnd);

		while ( GetMessage(&message, NULL, 0, 0) )	//get a message
		{
			TranslateMessage(&message);				//translate if neccesary
			TranslateAccelerator(hWnd, hAccel, &message);
			DispatchMessage(&message);				//send message
		}


		DeleteObject(hBitmap);
	}
	else
		MessageBox(NULL, "Couldn't create window", "Error", MB_OK | MB_ICONEXCLAMATION);

	return message.wParam;		//return exit-code
}
