	org	&h100
;
bDos	equ	5
;
; V9990 <-> V99x8 Switch - Command line version
;
; Written by: BiFi 2001
;
	jp	start
	db	13,"V99xx Switch V1.0 - By BiFi 2001",26
;
options:	db	0	; Bit0=VDP, Bit1=GFX, Bit2=Quiet
;
printOpt:	ld	a,(options)
	and	4
	ret	nz
printBdos:	ld	c,9
	jp	bDos
;
start:	call	parseOptions
	ld	de,tIntro
	ld	a,(options)
	and	3
	jr	nz,setMode
printUsage:	call	printBdos
	ld	de,tUsage
	jp	printBdos

setMode:	xor	3
	jr	z,printUsage
	call	printOpt
	ld	de,tSelect1
	call	printOpt

	ld	a,(options)
	and	2
	jr	nz,setGfx

	ld	a,16
	ld	de,tVdp
	jr	endMode

setGfx:	xor	a
	ld	de,tGfx

endMode:	out	(&h6f),a
	call	printOpt
	ld	de,tSelect2
	jp	printOpt
;
parseOptions:	ld	hl,&h80
	ld	c,(hl)
	ld	b,0
	inc	hl
	inc	c
	dec	c
	ret	z

	ld	de,options
parseLoop:	ld	a,"/"
	cpir
	ret	nz
	ret	po

	ld	a,(hl)
	ex	de,hl
	or	32
	cp	"v"
	jr	nz,parseOptG
	set	0,(hl)
parseOptG:	cp	"g"
	jr	nz,parseOptQ
	set	1,(hl)

parseOptQ:	cp	"q"
	jr	nz,parseDone
	set	2,(hl)

parseDone:	ex	de,hl
	jr	parseLoop
;
tIntro:	db	"V99xx Switch V1.0 - For Video9000 only",13,10
	db	"Written by BiFi 2001",13,10,10,"$"
tSelect1:	db	"V99$"
tSelect2:	db	" Selected",13,10,"$"
tVdp:	db	"x8$"
tGfx:	db	"90$"
tUsage:	db	"Usage: V9SWITCH /{V|G} [/Q]"
	db	13,10,9,"/V = Select V99x8"
	db	13,10,9,"/G = Select V9990"
	db	13,10,9,"/Q = Quiet (Batch files)$"
