	org	&h100
;
bDos	equ	5
;
; Magic Replayer Skin setter
;
; Written by: BiFi 2001
;
	jp	start
	db	13,"Magic Replayer Skin setter. BiFi 2001",26
;
start:	ld	de,tIntro	; Write intro
	call	printBDos

	ld	c,&h6f	; Check DOS version
	call	bDos
	ld	a,b
	cp	2	; DOS2 or higher?
	jr	nc,dos2

	ld	de,tNoDos2	; It isn't, write error and quit
printBDos:	ld	c,9
	jp	bDos

noFile:	pop	de
	ld	de,tNoName	; No filename given
	jr	printBDos

noSkin:	ld	de,tNoSkin
	jr	printBDos
;
dos2:	ld	hl,&h80	; Check length of command line
	ld	a,(hl)
	and	a	; Write usage and quit when it's empty
	ld	de,tUsage
	jr	z,printBDos
	push	hl
	call	parseParms
	pop	de	; Put the command line pointer in DE

	ld	a,(options)
	bit	1,a
	jr	nz,viewSkin
	and	1
	jr	z,findPath

	xor	a
	ld	(tEnvValue),a
	jr	setEnvValue

findPath:	inc	de	; Find first valid character for name
	ld	a,(de)
	cp	32	; Space is an invalid character
	jr	z,findPath
	cp	9	; TAB is an invalid charcter
	jr	z,findPath

	push	de
	ld	bc,&h5b	; Parse pathname
	call	bDos

	ld	a,(tDrive)
	add	a,c
	ld	(tDrive),a

	call	dCompR
	jr	z,noFile

	bit	4,b
	jr	nz,hasExt

	ld	bc,4
	ld	hl,tDefaultExt
	ldir

hasExt:	xor	a
	ld	(de),a
	pop	de

	ld	bc,&h40
	ld	ix,fib
	call	bDos
	jr	nz,noSkin

	ld	c,&h5e
	ld	de,tFullPath
	call	bDos

setEnvValue:	ld	c,&h6c
	ld	de,tEnvValue
	ld	hl,tEnvName
	call	bDos
	ld	de,tErrorSet
	jr	nz,printBDos
	ld	de,tDoneSet
	ld	a,(options)
	and	1
	jp	z,printBDos
	ld	de,tDoneReset
	jp	printBDos
;
viewSkin:	ld	de,tDoneView
	call	printBDos
	ld	bc,&h406b
	ld	de,tEnvValue
	ld	hl,tEnvName
	call	bDos
	ld	b,a
	ld	c,&h62
	jp	nz,bDos
	ex	de,hl
	cp	(hl)
	ld	de,tEmpty
	jp	z,printBDos
printLoop:	ld	a,(hl)
	and	a
	jr	z,printDone
	push	hl
	ld	c,2
	ld	e,a
	call	bDos
	pop	hl
	inc	hl
	jr	printLoop
printDone:	ld	de,tCrLf
	jp	printBDos
;
dCompR:	ld	a,h
	cp	d
	ret	nz
	ld	a,l
	cp	e
	ret
;
parseParms:	ld	c,(hl)	; Get length
	ld	b,0
	inc	hl	; Start of string to parse
	ld	de,options
parseNext:	ld	a,"/"	; Option starts with "/"
	cpir
	ret	nz
	ret	po

	ld	a,(hl)	; Get option
	ex	de,hl
	or	32
	cp	"r"
	jr	nz,parseNoRemv
	set	0,(hl)
parseNoRemv:	cp	"v"
	jr	nz,parseNoView
	set	1,(hl)
parseNoView:	ex	de,hl
	jr	parseNext
;
options:	db	0
tIntro:	db	"SKIN version 1.2 - Written by: BiFi 2001",13,10
	db	"Easilly enable skin setting for Magic Replayer"
	db	13,10,10,"$"
tUsage:	db	"Usage: SKIN <pathspec> [/R] [/V]",13,10,9
	db	"/R = Remove skin setting",13,10,9
	db	"/V = View current skin setting",13,10,"$"
tDoneSet:	db	"Skin succesfully changed",13,10,"$"
tDoneReset:	db	"Skin succesfully removed",13,10,"$"
tDoneView:	db	"Current skin located at $"
tEmpty:	db	13,27,"KNo user skin defined"
tCrLf:	db	13,10,"$"
tErrorSet:	db	"Error detected. Skin not changed",13,10,"$"
tNoSkin:	db	"Error detected. Skinfile not found",13,10,"$"
tNoName:	db	"No skinfile given",13,10,"$"
tNoDos2:	db	"SKIN requires MSX-DOS2",13,10,"$"
tDefaultExt:	db	".SKN"
tEnvName:	db	"SKIN",0
tEnvValue	equ	$
tDrive:	db	"@:\"
tFullPath:	ds	64
fib	equ	$
