	org	&hc000
;
bDos	equ	&hf37d
calStm	equ	&hfd89
extBio	equ	&hffca
;
; KUN BASIC Compiler loader - Revised version (With proper comment)
;
; Written by: BiFi'96
;
start:	call	iniCal	; Initialize fake CALL statement
	call	iniMap	; Initialize DOS2 mapper support
	call	tmpPag	; Request and use segment
	call	setDma	; Set DMA address
	call	wriNam	; Put name in FCB
	call	opeFil	; Open file en adjust FCB
	call	reaFil	; Read file
	call	cloFil	; Close file
	call	exeRom	; Start transfer code in 'ROM'
	jp	oldPag	; Enable old page, free segment en end
;
; Diverse Variables
;
filNam:	db	"KUNBASICOVL"	; Filename for overlay file
oldMap:	db	0	; Mapper segment before & after load
tmpMap:	db	0	; Mapper segment during load
tmpSlt:	db	0	; Slot address of "tmpMap"
;
; Check version of MSX-DOS
;
dosVer:	ld	c,&h6f	; BDOS function for checking DOS version
	call	bDos
	or	a	; Non zero?
	ret	nz	; Then it's not DOS2 (earlier)
	ld	a,b	; Check DOS-kernel version itself
	cp	2	; Set flags for checking
	ret
;
; Write filename in FCB
;
wriNam:	ld	hl,filNam	; Start of (encoded) filename
	ld	de,FCB+1	; Where to put it (FCB)
	ld	b,11	; Length of name (always 11)
write:	ld	a,(hl)	; Get character
;             xor     l                ; Decode character
	ld	(de),a	; Write it in the FCB
	inc	de	; Next address in FCB
	inc	hl	; Next address (encoded) filename
	djnz	write	; Until all characters are done
	ld	hl,(&hf860)	; Address in FILTAB in HL
	ld	e,(hl)	; Address of Basic FCB in DE
	inc	hl
	ld	d,(hl)
	inc	de	; Get 4th byte in table
	inc	de
	inc	de
	inc	de
	ld	a,(de)	; Is called device
	ld	(FCB),a	; Put this one in the BDOS FCB
	ret
;
; Init- and Mapper routines
;
iniCal:	ld	hl,calStm	; Start of CALL statement name
	ld	a,"B"	; Make a fake "CALL BC"
	ld	(hl),a
	inc	hl
	inc	a
	ld	(hl),a
	inc	hl
	sub	a
	ld	(hl),a
	ret
;
iniMap:	call	dosVer	; Check DOS version
	ret	c	; Return when not DOS2
	xor	a	; Get mapper support entry-table
	ld	de,&h402
	call	extBio
	ld	(dosMap+1),hl	; Save the address in the code
	ret
;
tmpPag:	call	dosVer	; Check DOS version
	jr	c,setDos	; Use DOS1 method (IO-ports)

	ld	de,&h27	; Get current mapper segment
	call	dosMap
	ld	(oldMap),a	; Keep this to return it later

	xor	a	; Request a mapper segment
	ld	b,0
	ld	de,&h0	; Request segment routine of DOS2
	call	dosMap
	jr	c,memErr	; Print error when the request failed
	ld	(tmpMap),a	; Keep this segment code to use and free
	ld	a,b
	ld	(tmpSlt),a	; Keep the slot of this segment too

	ld	a,(tmpMap)	; Use the requested segment
use2:	ex	af,af'
	ld	a,(tmpSlt)	; Get the slot code
	ld	b,a
	ex	af,af'
	ld	de,&h24	; Use in page 2 routine of DOS2
	jp	dosMap

setDos:	in	a,(&hfe)	; Get current mapper segment
	ld	(oldMap),a	; Keep it to return it later
	ld	a,3	; Use this segment to load it in
	out	(&hfe),a
	ret

memErr:	ld	e,7
errors:	jp	&h406f
;
oldPag:	call	dosVer	; Check DOS version
	jr	c,resDos	; Use DOS1 method (IO-ports)

	ld	a,(oldMap)	; Put the old segment back
	call	use2

	ld	a,(tmpSlt)	; Free this segment
	ld	b,a
	ld	a,(tmpMap)
	ld	de,&h3	; Free segment routine of DOS2
	jp	dosMap

resDos:	ld	a,(oldMap)	; Get old mapper segment
	out	(&hfe),a	; Restore it
	ret
;
exeRom:	ld	hl,(&h8004)	; Start init-code (CALL BC)
	jp	(hl)
;
dosMap:	ld	hl,0	; Address filled by "iniMap" routine
	add	hl,de	; Add calling address to start address
	jp	(hl)
;
; Disk access routines
;
setDma:	ld	c,&h1a	; Set DMA address
	ld	de,&h8000
	call	bDos

	ld	b,48	; Number of byte to fill
	ld	hl,FCB	; Fill from the FCB
clrFcb:	ld	(hl),0	; Fill it with zeroes
	inc	hl	; Next address in the chain
	djnz	clrFcb	; Until all are done
	ret
;
opeFil:	ld	c,&h0f	; Open file in FCB
	ld	de,FCB
	call	bDos
	inc	a	; &HFF when error
	jr	z,opeErr	; Print error when detected
	ld	hl,0	; Adjust FCB
	ld	(FCB+12),hl
	ld	hl,1	; Ajust file record length
	ld	(FCB+14),hl
	ret

opeErr:	call	oldPag	; Restore old segment & free requested
	ld	e,53	; Error "File not found"
	jr	errors
;
reaFil:	ld	c,&h27	; Read (HL) records from file in FCB
	ld	de,FCB
	ld	hl,&h4000
	call	bDos
	dec	a	; &H01 when error
	jr	z,reaErr	; Find out what's wrong
	ret

reaErr:	push	hl	; Keep number of records read
	call	oldPag	; Restore old segment & free requested
	pop	hl	; Restore number of records read
	ld	a,h	; Take the MSB
	cp	&h40	; Less than &H40?
	ld	e,55	; Error "Input past end"
	jr	c,errors
	ld	e,69	; Error "Disk I/O error"
	jr	errors
;
cloFil:	ld	c,&h10	; Close file in FCB
	ld	de,FCB
	call	bDos
	inc	a	; &HFF when error
	jr	z,cloErr	; Print it when detected
	ret

cloErr:	call	oldPag	; Restore old segment & free requested
	ld	e,64	; Error "File still open"
	jp	errors
;
FCB	equ	$	; File Control Block starts here
